# -*- coding: utf-8 -*-

from __future__ import print_function, absolute_import, division

import codecs


def safe_convert(value, type_, default=None):
    try:
        return type_(value)
    except (TypeError, ValueError):
        return default


def safe_divide(numerator, denominator, default=None):
    try:
        return numerator / denominator
    except ZeroDivisionError:
        return default


def safe_list_get(list_, index):
    try:
        return list_[index]
    except Exception:
        return None


def safe_dict_get(dict_, key):
    try:
        return dict_[key]
    except Exception:
        return None


def load_file(path, mode='r'):
    with codecs.open(path, mode) as file_:
        return file_.read().strip()


def save_file(path, data, mode='w'):
    with codecs.open(path, mode) as file_:
        return file_.write(data)


def parse_key_value_string(string, delimeter, separator=' '):
    pairs = string.split(separator)
    dictionary = {}
    for pair in pairs:
        key, value = pair.split(delimeter, 1)
        dictionary[key] = value
    return dictionary


def reverse_dictionary(dictionary, strict=False):
    if not strict:
        return {value: key for key, value in dictionary.items()}
    else:
        reversed_ = {}
        for key, value in dictionary.items():
            reversed_[value] = reversed_.get(value, [])
            reversed_[value].append(key)
        return reversed_


def byteify(input):
    if isinstance(input, unicode):
        return input.encode('utf-8')
    elif isinstance(input, dict):
        return {
            byteify(key): byteify(value)
            for key, value in input.items()
        }
    elif isinstance(input, list):
        return [byteify(element) for element in input]
    else:
        return input
