from __future__ import division
from collections import OrderedDict


rel_marks = ["VITAL",
             "VITAL_CHECKED",
             "VITAL_CANDIDATE",
             "USEFUL",
             "RELEVANT_PLUS",
             "RELEVANT_MINUS",
             "IRRELEVANT",
             "STUPID",
             "NOT_SPAM",
             "NOT_VITAL",
             "SPAM",
             "TECHNICAL_SPAM",
             "VIRUS",
             "_404"]

tw_marks = ["HIGHEST",
            "HIGH",
            "MIDDLE",
            "LOW",
            "LOWEST",
            "_404"]

def prepare(pos):
    data = OrderedDict()

    for i in range(len(rel_marks)):
        row = OrderedDict()

        for j in range(len(tw_marks)):
            row[tw_marks[j]] = "N/A"

        data[rel_marks[i]] = row


    #print data['VITAL']

    f = open("cansuculluANSEARCH-397p{0}-final-results.txt".format(pos))
    for line in f:
        rel, tw, bug, clicks, shows, ctr = line.strip().split(('\t'))
        rel_mark = rel.split('=')[-1]
        tw_mark = tw.split('=')[-1]
        data[rel_mark][tw_mark] = ctr
    f.close()
    #print data['VITAL']
    return data


def tab_print(pos, data, replace=True):
    filename = "cansuculluANSEARCH-397p{0}-matrix.txt".format(pos)
    f = open(filename, 'w+')

    # First row
    f.write(' ')
    for i in tw_marks:
        f.write('\t'+i)
    f.write('\n')

    # Rest of the rows
    for i in range(len(data.keys())):
        f.write(rel_marks[i])
        for j in data[data.keys()[i]].values():
            f.write('\t'+str(j))
        f.write('\n')
    f.close()

    # For non-american excel
    if replace:
        f = open(filename,'r')
        text = f.read()
        new_text = text.replace('.', ',')
        f.close()
        f = open(filename,'w')
        f.write(new_text)
        f.close()


def prepare_details(pos):
    data_details = OrderedDict()

    for i in range(len(rel_marks)):
        row = OrderedDict()

        for j in range(len(tw_marks)):
            row[tw_marks[j]] = "N/A"

        data_details[rel_marks[i]] = row


    #print data_details['VITAL']

    f = open("cansuculluANSEARCH-397p{0}-final-results.txt".format(pos))
    for line in f:
        rel, tw, bug, clicks, shows, ctr = line.strip().split(('\t'))
        rel_mark = rel.split('=')[-1]
        tw_mark = tw.split('=')[-1]
        data_details[rel_mark][tw_mark] = str(clicks) + ' / ' + str(shows)
    f.close()
    #print data_details['VITAL']
    return data_details


def tab_print_details(pos, data, replace=False):
    filename = "cansuculluANSEARCH-397p{0}-matrix-details.txt".format(pos)
    f = open(filename, 'w+')

    # First row
    f.write(' ')
    for i in tw_marks:
        f.write('\t'+i)
    f.write('\n')

    # Rest of the rows
    for i in range(len(data.keys())):
        f.write(rel_marks[i])
        for j in data[data.keys()[i]].values():
            f.write('\t'+str(j))
        f.write('\n')
    f.close()

    # For non-american excel
    if replace:
        f = open(filename,'r')
        text = f.read()
        new_text = text.replace('.', ',')
        f.close()
        f = open(filename,'w')
        f.write(new_text)
        f.close()


if __name__ == '__main__':

    bulk = range(0,1)
    for pos in bulk:
        data = prepare(pos)
        tab_print(pos, data)
    
        data = prepare_details(pos)
        tab_print_details(pos, data)
