#!/usr/bin/env python
#coding=utf-8

from mapreducelib import MapReduce, Record
import libra

def hasLongClick(clicks):
    for clk in clicks:
        #if clk.DwellTime > 30:
        if clk.DwellTimeOnService > 30:
            return True

    return False


testIdExp = "16231"

# fltcm2 = libra.TRequestFilter()
# fltcm2.Add("relev_filter", "cm2>0.3")
# fltcm2.Init()

# fltCpo = libra.TRequestFilter()
# fltCpo.Add("relev_filter", "!(~Cpo)")
# fltCpo.Init()

# fltIl = libra.TRequestFilter()
# fltIl.Add("relev_filter", "il==1")
# fltIl.Init()

fltRnk = libra.TRequestFilter()
fltRnk.Add("search_props_filter", "WEB.RankingModel==tr||WEB.RankingModel==tr.long")
fltRnk.Init()

fltTdi = libra.TRequestFilter()
# fltTdi.Add("search_props_filter", "UPPER.ApplyBlender.TdiIsInterleavingCorrect==1") #old
# fltTdi.Add("search_props_filter", "UPPER.Tdi4All_d.TdiIsInterleavingCorrect==1") #new
fltTdi.Add("search_props_filter", "WEB.Trustworthiness.Message_final==Success")
fltTdi.Init()

from urlparse import urlparse

def process(key, recs):
    try:
        session = libra.ParseSession(recs, 'blockstat.dict')
    except:
        return
    
    for request in session:
        
        if not request.IsA("TYandexWebRequest") or not fltTdi.Filter(request) or request.PageNo != 0 or request.ServiceDomRegion != "tr":
            continue

        query = request.Query

        ranking_model = 'none'
        if request.IsA("TMiscRequestProperties"):
            ranking_model = request.SearchPropsValues.get("WEB.RankingModel", "")

        if request.HasTestID(testIdExp):
            for block in request.GetMainBlocks():
                main_result = block.GetMainResult()
                if main_result.IsA("TWebResult"):
                    url = str(main_result.Url)
                    pos = str(main_result.Position)

                    if 'TdiSrc' in main_result.Markers.keys():

                        clicks = block.GetClicks()
                        if len(clicks) <= 0:
                            clck = '0'
                            long_clck = 0
                        else:
                            clck = str(len(clicks))
                            long_clck = 0
                            for clk in clicks:
                                if clk.DwellTimeOnService > 30:
                                    long_clck += 1

                        long_clck = str(long_clck)

                        key_0 = main_result.Markers['TdiSrc'] + '\t' + pos + '\t' + url + '\t' + query
                        key_1 = main_result.Markers['TdiSrc'] + '\t' + url + '\t' + query
                        key_2 = main_result.Markers['TdiSrc'] + '\t' + query
                        key_3 = main_result.Markers['TdiSrc'] + '\t' + pos + '\t' + url
                        key_4 = main_result.Markers['TdiSrc'] + '\t' + url
                        key_5 = main_result.Markers['TdiSrc'] + '\t' + pos
                        key_6 = main_result.Markers['TdiSrc']

                        value_ = clck + '\t' + long_clck

                        yield Record(key_0[:4096] , '',  value_, tableIndex = 0)
                        yield Record(key_1[:4096] , '',  value_, tableIndex = 1)
                        yield Record(key_2[:4096] , '',  value_, tableIndex = 2)
                        yield Record(key_3[:4096] , '',  value_, tableIndex = 3)
                        yield Record(key_4[:4096] , '',  value_, tableIndex = 4)
                        yield Record(key_5[:4096] , '',  value_, tableIndex = 5)
                        yield Record(key_6[:4096] , '',  value_, tableIndex = 6)


def finalize(key, records):
    total_clicks = 0
    total_long_clicks = 0
    total_shows = 0

    for rec in records:
        click, long_click = rec.value.split('\t')
        total_clicks += int(click)
        total_long_clicks += int(long_click)
        total_shows += 1

    value_ = str(total_clicks) + '\t' + str(total_long_clicks) + '\t' + str(total_shows)
    yield Record(rec.key, '', value_)


def main():

    MapReduce.useDefaults(server='sakura.search.yandex.net',
                          username='ranking',
                          mrExec='/Berkanavt/bin/mapreduce-dev',
                          verbose=True)

    srcTable = 'tr/user_sessions/201508'
    dstTables = ['cansucullu/ANSEARCH-397/EXP-5205/map/query-type-pos-url',
                 'cansucullu/ANSEARCH-397/EXP-5205/map/query-type-url',
                 'cansucullu/ANSEARCH-397/EXP-5205/map/query-type',
                 'cansucullu/ANSEARCH-397/EXP-5205/map/type-pos-url',
                 'cansucullu/ANSEARCH-397/EXP-5205/map/type-url',
                 'cansucullu/ANSEARCH-397/EXP-5205/map/type-pos',
                 'cansucullu/ANSEARCH-397/EXP-5205/map/type',
                 ]

    days = range(14, 21)


    for day in days:
        srcTableFinal = srcTable + str(day)
        MapReduce.runReduce(process,srcTable=srcTableFinal,dstTables=dstTables,files=['/home/cansucullu/bin/blockstat.dict'],appendMode=True)

    for dstTable in dstTables:
        MapReduce.runReduce(finalize,srcTable=dstTable,dstTable=dstTable[:33]+'reduce'+dstTable[36:],files=['/home/cansucullu/bin/blockstat.dict'],sortMode=True)


if __name__ == '__main__':
    main()
