# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
import os

def MyMap(key, records):
    for rec in records:
        key_items = rec.key.split('\t')
        value_items = rec.value.split('\t')

        if len(key_items) == 2 and len(value_items) == 1: # from cansucullu/ANSEARCH-397/assessors-relevance table
            key = key_items[1] # url
            value = key_items[0] + '\t' + value_items[0] # query \t r_mark
            yield Record(key,'',value)

        if len(key_items) == 1 and len(value_items) == 1: # from cansucullu/ANSEARCH-397/assessors-trustworthiness table
            key = key_items[0] # url
            value = value_items[0] # t_mark
            yield Record(key,'',value)



def MyReduce(key, records):
    condition1 = False
    condition2 = False

    for rec in records:
        items = rec.value.split('\t')
        if len(items) == 2:
            query = items[0]
            r_mark = items[1]
            condition1 = True

        if len(items) == 1:
            t_mark = items[0]
            condition2 = True

    if condition1 and condition2:
        value = 'query=' + query + '\t' + 'r_mark=' + r_mark + '\t' + 't_mark=' + t_mark
        yield Record(key, '', value)

def main():

    MapReduce.useDefaults(
                            server   = 'cedar00.search.yandex.net:8013',
                            username = 'ranking',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                         )

    srcTable = 'cansucullu/ANSEARCH-397/assessors-trustworthiness'
    srcTable2 = 'cansucullu/ANSEARCH-397/assessors-relevance'

    dstTable = 'cansucullu/ANSEARCH-397/relevance-assessors-trustworthiness-preparation'
    dstTable2 = 'cansucullu/ANSEARCH-397/relevance-assessors-trustworthiness'

    MapReduce.runReduce(MyMap, srcTable = srcTable, dstTable = dstTable, appendMode=True)
    MapReduce.runReduce(MyMap, srcTable = srcTable2, dstTable = dstTable, appendMode=True)
    MapReduce.sortTable(dstTable)
    MapReduce.runReduce(MyReduce, srcTable = dstTable, dstTable = dstTable2, sortMode = True)


if __name__ == '__main__':
    main()
