# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
import os

def map(key, records):
    for rec in records:
        yield Record(rec.key,'',rec.value)

def combine(key, records):

    condition1 = False
    condition2 = False

    for rec in records:
        items = rec.value.split('\t')

        if len(items) == 4: # a problem in clicks= tab correct it afterwards
            clicks = items[0]
            shows = items[1]
            ctr = items[2]
            condition1 = True

        if len(items) == 2:
            r_mark = items[0]
            t_mark = items[1]
            condition2 = True
    
    if condition1 and condition2:
        key_ = rec.key
        value = clicks + '\t' + shows + '\t' + ctr + '\t' + r_mark + '\t' + t_mark
        yield Record(key_, '', value)


def reverse(key, records):
    for rec in records:
        query, url = rec.key.split('\t')
        clicks, shows, ctr, r_mark, t_mark = rec.value.split('\t')
        key_ = r_mark + '\t' + t_mark
        value = clicks.split('=')[1] + '\t' + shows.split('=')[1]
        yield Record(key_, '', value)

def finalize(key, records):
    big_total_clicks = 0
    big_total_shows = 0
    for rec in records:
        click, show = rec.value.split('\t')
        big_total_clicks += int(click)
        big_total_shows += int(show)

    big_CTR = float(big_total_clicks) / float(big_total_shows)
    value = str(big_total_clicks) + '\t' + str(big_total_shows) + '\t' + str(big_CTR)
    yield Record(rec.key, '', value)


def main():

    MapReduce.useDefaults(
                            server   = 'cedar00.search.yandex.net:8013',
                            username = 'ranking',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                         )
    srcTable = 'cansucullu/ANSEARCH-397/relevance-assessors-trustworthiness-ready'
    srcTable2 = 'cansucullu/ANSEARCH-397/p0-reduce'
    dstTable = 'cansucullu/ANSEARCH-397/p0-combined-preparation'
    dstTable2 = 'cansucullu/ANSEARCH-397/p0-combined'
    dstTable3 = 'cansucullu/ANSEARCH-397/p0-combined-reversed'
    dstTable4 = 'cansucullu/ANSEARCH-397/p0-final-results'

    MapReduce.runReduce(map, srcTable = srcTable, dstTable = dstTable, appendMode=True)
    MapReduce.runReduce(map, srcTable = srcTable2, dstTable = dstTable, appendMode=True)
    MapReduce.sortTable(dstTable)
    MapReduce.runReduce(combine, srcTable = dstTable, dstTable = dstTable2, sortMode = True)
    MapReduce.runReduce(reverse, srcTable = dstTable2, dstTable = dstTable3, sortMode = True)
    MapReduce.runReduce(finalize, srcTable = dstTable3, dstTable = dstTable4, sortMode = True)


if __name__ == '__main__':
    main()
