# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
import os

def combine(key, records):
    condition1 = False
    condition2 = False

    for rec in records:
        if len(rec.value.split('.')) == 1: # we have a mark
            tw_mark = rec.value
            condition1 = True
        else:
            host = rec.value
            condition2 = True

    if condition1 and condition2:
        value = host + '\t' + tw_mark
        yield Record(key, '', value)

def main():

    MapReduce.useDefaults(
                            server   = 'cedar00.search.yandex.net:8013',
                            username = 'ranking',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                         )

    srcTable1 = "cansucullu/ANSEARCH-397/new-assessors-trustworthiness"
    srcTable2 = "cansucullu/ANSEARCH-397/all-hosts"
    dstTable = "cansucullu/ANSEARCH-397/new-assessors-trustworthiness-ready"
    MapReduce.dropTable(dstTable)
    MapReduce.runReduce(combine, srcTables=[srcTable1, srcTable2], dstTable=dstTable, sortMode=True)


if __name__ == '__main__':
    main()
