from __future__ import division

import numpy as np
import matplotlib.pyplot as plt

__author__ = 'cansucullu'

def main():

    xticks = ['LOWEST', 'LOW', 'MIDDLE', 'HIGH', 'HIGHEST']
    count = -1
    user_count = 0

    subplot_nos = ['331', '332', '333', '334', '335', '336', '337', '338', '339']
    for line in open('host-sample'):

        host, LOWEST, LOW, MIDDLE, HIGH, HIGHEST, total, user_content = line.rstrip().split('\t')

        count += 1

        fig_no = count // 9

        sup_title = 'Hosts with NO User Generated Content'
        color = 'blue'
        if user_content == '1':
            sup_title = 'Hosts with User Generated Content'
            color = 'red'

        plt.figure(fig_no)

        plt.suptitle(sup_title)

        plt.subplot(subplot_nos[count % 9])

        #plt.tight_layout(pad=1)

        y = [LOWEST, LOW, MIDDLE, HIGH, HIGHEST]
        for i in range(len(y)):
            y[i] = int(y[i]) / float(total)
        x = np.arange(len(y))

        plt.bar(x,y,color=color)
        plt.xticks(x+0.4,xticks)
        plt.yticks(np.linspace(0,1,6))
        plt.title('{0} ({1} urls)'.format(host,total))
        plt.subplots_adjust(bottom=0.05, left=0.05, right=0.95, top=0.9, wspace = 0.4, hspace = 0.4)

    plt.show()


if __name__ == '__main__':
    main()
