from __future__ import division

__author__ = 'cansucullu'

import sys
import re
import datetime
import requests
import urllib
import urllib2
import urlparse
import json
import time
import logging
import collections

import yt.wrapper as yt


def module_filter(module):
    if not module:
        return True
    name = getattr(module, '__name__', '')
    return not (name == 'uatraits' or name.startswith('statbox'))


yt.config["auto_merge_output"]["action"] = "merge"
yt.config["pickling"]["module_filter"] = module_filter
yt.config.set_proxy('hahn.yt.yandex.net')
yt.config.CREATE_RECURSIVE = True
yt.config.TREAT_UNEXISTING_AS_EMPTY = True
yt.config.TOKEN = 'ae8bcc6bbaa7469694dae8d819f40191'


class RetentionCalculator:
    def __init__(self):
        self.clids = ["2189882", "2219050", "2219052", "2224320", "2235099",
                      "2167028", "2211117", "2211122", "2220626", "2228830", ]
        self.yasofts = ['litevbchrome_chr', 'homesearchextchrome_chr', 'searchextchrome_chr', 'startextchrome_chr']

        self.all_clids = dict([
            ('2189882', 'Search Extension dayuse'),
            ('2196600', 'Search Extension omnibox'),
            ('2187647', 'Search Extension na'),
            ('2220368', 'Search Extension na'),
            ('2219050', 'Search Pop-up Screen Extension dayuse'),
            ('2219051', 'Search Pop-up Screen Extension omnibox'),
            ('2224775', 'Search Pop-up Screen Extension na'),
            ('2219052', 'New Tab Extension dayuse'),
            ('2219053', 'New Tab Extension omnibox'),
            ('2219054', 'New Tab Extension Yandex logo on new tab'),
            ('2219055', 'New Tab Extension new tab'),
            ('2224771', 'New Tab Extension na'),
            ('2224320', 'Homepage Extension dayuse'),
            ('2224321', 'Homepage Extension omnibox'),
            ('2224322', 'Homepage Extension homepage & startpage'),
            ('2224323', 'Homepage Extension context menu search'),
            ('2235099', 'Homepage Experiment dayuse'),
            ('2235100', 'Homepage Experiment omnibox'),
            ('2235101', 'Homepage Experiment homepage & startpage'),
            ('2235102', 'Homepage Experiment context menu search'),
        ])

        self.export_access_log_table_raw = '//statbox/export-access-log/'

        self.install_table_raw = '//home/turkey-analytics/cansucullu/RetentionData/install/'
        self.unique_install_table_raw = '//home/turkey-analytics/cansucullu/RetentionData/unique-install/'

        self.dayuse_table_raw = '//home/turkey-analytics/cansucullu/RetentionData/dayuse/'
        self.unique_dayuse_table_raw = '//home/turkey-analytics/cansucullu/RetentionData/unique-dayuse/'

        self.retention_pivot_table = '//home/turkey-analytics/cansucullu/RetentionData/PivotTable'
        self.bnrd_pivot_table = '//home/turkey-analytics/cansucullu/RetentionData/Bannerid/PivotTable'

        self.retention_temporary_dir = '//home/turkey-analytics/cansucullu/RetentionData/temp/'

        #  Note: I add another dir for yasoft
        self.statface_names = dict([
            ('immediate retention', 'yandex.com.tr/Special/Metrics/Switch/AudienceMetrics/YaSoftImmediateRetention'),
            ('real retention', 'yandex.com.tr/Special/Metrics/Switch/RetentionAnalysis/YaSoftRetentionSummary'),
            ('smooth dayuse', 'yandex.com.tr/Special/Metrics/Switch/AudienceMetrics/YaSoftDayuse'),
            ('retention bannerid', 'yandex.com.tr/Special/Metrics/Switch/RetentionAnalysis/RetentionBannerid'),
            ('retention bannerid filtered', 'yandex.com.tr/Special/Metrics/Switch/RetentionAnalysis/RetentionBanneridFiltered'),
        ])

        self.date_format = '%Y-%m-%d'
        self.time_format = '%Y-%m-%d %H:%M:%S'

        self.stat_data = dict([
            ('StatRobotUser', 'robot_cansucullu'),
            ('StatRobotPassword', 'Tai0epood8'),
        ])

    def prepare_dates(self, start_date, stop_date):
        days_list = []

        if start_date <= stop_date:
            start = datetime.datetime.strptime(start_date, self.date_format)
            stop = datetime.datetime.strptime(stop_date, self.date_format)
            delta = (stop - start).days + 1

            for i in xrange(delta):
                new_date_datetime = start + datetime.timedelta(days=i)
                days_list.append(new_date_datetime.strftime(self.date_format))

            return days_list

        else:
            start = datetime.datetime.strptime(stop_date, self.date_format)
            stop = datetime.datetime.strptime(start_date, self.date_format)
            delta = (stop - start).days + 1

            for i in xrange(delta):
                new_date_datetime = start + datetime.timedelta(days=i)
                days_list.append(new_date_datetime.strftime(self.date_format))

            days_list.reverse()
            return days_list

    def get_ndays_difference(self, input_date, n):
        input_date_datetime = datetime.datetime.strptime(input_date, self.date_format)

        if n > 0:
            output_date_datetime = input_date_datetime + datetime.timedelta(days=n)
        else:
            output_date_datetime = input_date_datetime - datetime.timedelta(days=abs(n))

        output_date = output_date_datetime.strftime(self.date_format)

        return output_date

    def update_daily_statface_report(self, name, data):
        url = 'https://stat.yandex-team.ru/_api/report/data'
        # headers = {'StatRobotUser': 'robot_cansucullu', 'StatRobotPassword': 'Tai0epood8'}
        headers = {'StatRobotUser': self.stat_data['StatRobotUser'],
                   'StatRobotPassword': self.stat_data['StatRobotPassword']}
        values = {
            'name': self.statface_names[name],
            'scale': 'd',
            'data': json.dumps({'values': data})
        }

        data = urllib.urlencode(values)
        req = urllib2.Request(url, data, headers)
        response = urllib2.urlopen(req)

    def update_daily_statface_report_overwrite(self, name, data):
        url = 'https://stat.yandex-team.ru/_api/report/data'
        # headers = {'StatRobotUser': 'robot_cansucullu', 'StatRobotPassword': 'Tai0epood8'}
        headers = {'StatRobotUser': self.stat_data['StatRobotUser'],
                   'StatRobotPassword': self.stat_data['StatRobotPassword']}
        values = {
            'name': self.statface_names[name],
            'scale': 'd',
            'data': json.dumps({'values': data}),
            'replace_mask': 'fielddate',
        }

        data = urllib.urlencode(values)
        req = urllib2.Request(url, data, headers)
        response = urllib2.urlopen(req)

    def read_statface_data(self, name, date):
        graph_dict = {'fielddate': date}
        url = 'https://stat.yandex-team.ru/yandex.com.tr/Special/Metrics/Switch/AudienceMetrics/ImmediateRetention'
        headers = {'StatRobotUser': self.stat_data['StatRobotUser'],
                   'StatRobotPassword': self.stat_data['StatRobotPassword']}
        data = {
            'scale': 'd',
            'date_min': '{0}'.format(date),
            'date_max': '{0}'.format(date),
            'type': 'json'
        }
        request = requests.get(url, params=data, headers=headers)
        response = json.loads(request.content)['values']
        return response

    def mainloop(self):

        while True:
            missing_dates = self.check_export_access_log()
            print "missing_dates", missing_dates
            if len(missing_dates) == 0:  # Tables are up to date
                print time.strftime(self.time_format), "There is no new export-access-log. Now sleeping"
                time.sleep(3600)
            else:
                for date in missing_dates:
                    """
                    moment = datetime.datetime.now()
                    log_file = 'logs/retention' + moment.strftime('%Y%m%d%H%M%S') + '.html'
                    logging.basicConfig(filename=log_file, level=logging.DEBUG, format='%(levelname)s ::: %(asctime)s : %(filename)s : %(message)s')

                    logging.info('Export-access-log is ready for {0}'.format(date))
                    logging.warning("There is no new export-access-log. Now sleeping")
                    """
                    try:

                        while True:
                            try:
                                print time.strftime(self.time_format), "Updating for export-access-log", date
                                self.update_daily_stat_tables(date)
                            except Exception, e:
                                print str(e),
                                print time.strftime(
                                    self.time_format), "Some error happened during updating for export-access-log {0}, Now sleeping".format(
                                    date)
                                time.sleep(180)
                                continue
                            break

                        while True:
                            try:
                                print time.strftime(self.time_format), "Running smooth audience report update", date
                                self.run_smooth_audience_report(date)
                            except Exception, e:
                                print str(e),
                                print time.strftime(
                                    self.time_format), "Some error happened during smooth audience report update {0}, Now sleeping".format(
                                    date)
                                time.sleep(180)
                                continue
                            break

                        while True:
                            previous_day = self.get_ndays_difference(date, -1)
                            try:
                                print time.strftime(
                                    self.time_format), "Running immediate retention report update", previous_day
                                self.run_immediate_retention_report(previous_day)
                            except Exception, e:
                                print str(e),
                                print time.strftime(
                                    self.time_format), "Some error happened during immediate retention report update {0}, Now sleeping".format(
                                    previous_day)
                                time.sleep(180)
                                continue
                            break

                        while True:
                            try:
                                print time.strftime(self.time_format), "Updating for real retention pivot table", date
                                self.update_retention_pivot_table(date)
                            except Exception, e:
                                print str(e),
                                print time.strftime(
                                    self.time_format), "Some error happened during real retention pivot table {0}, Now sleeping".format(
                                    date)
                                time.sleep(180)
                                continue
                            break

                        while True:
                            try:
                                print time.strftime(api.time_format), "update_bnrd_pivot_table", date
                                api.update_bnrd_pivot_table(date)
                            except:
                                print time.strftime(
                                    api.time_format), "Some error happened during update_bnrd_pivot_table {0}, Now sleeping".format(
                                    date)
                                time.sleep(180)
                                continue
                            break

                    except Exception, e:
                        print str(e)

                date = missing_dates[-1]

                while True:
                    try:
                        print time.strftime(self.time_format), "Running run_bnrd_real_retention_report", date
                        self.run_bnrd_real_retention_report(date)
                    except Exception, e:
                        print str(e),
                        print time.strftime(
                            self.time_format), "Some error happened during run_bnrd_real_retention_report {0}, Now sleeping".format(
                            date)
                        time.sleep(180)
                        continue
                    break

                while True:
                    try:
                        print time.strftime(self.time_format), "Running real retention report update", date
                        self.run_real_retention_report(date)
                    except Exception, e:
                        print str(e),
                        print time.strftime(
                            self.time_format), "Some error happened during real retention report update {0}, Now sleeping".format(
                            date)
                        time.sleep(180)
                        continue
                    break

    def run_report(self, report):
        missing_dates = self.check_export_access_log()
        print "missing_dates", missing_dates
        if len(missing_dates) == 0:  # Tables are up to date
            print time.strftime(self.time_format), "There is no new export-access-log."
        else:
            for date in missing_dates:
                self.update_daily_stat_tables(date)

                if report == 'YaSoftDayuse':
                    self.run_smooth_audience_report(date)

                if report == 'YaSoftImmediateRetention':
                    previous_day = self.get_ndays_difference(date, -1)
                    self.run_immediate_retention_report(previous_day)

                self.update_retention_pivot_table(date)

                self.update_bnrd_pivot_table(date)

            date = missing_dates[-1]
            if report in ('RetentionBannerid', 'RetentionBanneridFiltered'):
                self.run_bnrd_real_retention_report(date)

            if report == 'YaSoftRetentionSummary':
                self.run_real_retention_report(date)

    def run_report(self, report):
        if report == 'UpdateTables':
            missing_dates = self.check_export_access_log()
            print "missing_dates", missing_dates
            if len(missing_dates) == 0:  # Tables are up to date
                print time.strftime(self.time_format), "There is no new export-access-log"
            else:
                for date in missing_dates:
                    self.update_retention_pivot_table(date)
                    self.update_bnrd_pivot_table(date)
                    self.update_daily_stat_tables(date)

        else:
            missing_dates = self.check_export_access_log()
            if len(missing_dates) > 0:
                print 'Tables are not up to date! Waiting for the next trial for running {}'.format(report)
                return

            today_date = datetime.date.today()
            yesterday_date = today_date - datetime.timedelta(1)
            date = yesterday_date.strftime('%Y-%m-%d')

            if report == 'YaSoftDayuse':
                self.run_smooth_audience_report(date)

            if report == 'YaSoftImmediateRetention':
                previous_day = self.get_ndays_difference(date, -1)
                self.run_immediate_retention_report(previous_day)

            if report in ('RetentionBannerid', 'RetentionBanneridFiltered'):
                self.run_bnrd_real_retention_report(date)

            if report == 'YaSoftRetentionSummary':
                self.run_real_retention_report(date)



    def mainloop_fix(self, dates):

        for date in dates:

            while True:
                try:
                    print time.strftime(self.time_format), "Updating for export-access-log", date
                    self.update_daily_stat_tables(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(
                        self.time_format), "Some error happened during updating for export-access-log {0}, Now sleeping".format(
                        date)
                    time.sleep(180)
                    continue
                break

            while True:
                try:
                    print time.strftime(self.time_format), "Running smooth audience report update", date
                    self.run_smooth_audience_report(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(
                        self.time_format), "Some error happened during smooth audience report update {0}, Now sleeping".format(
                        date)
                    time.sleep(180)
                    continue
                break

            while True:
                try:
                    previous_day = self.get_ndays_difference(date, -1)
                    print time.strftime(self.time_format), "Running immediate retention report update", previous_day
                    self.run_immediate_retention_report(previous_day)
                except Exception, e:
                    print str(e),
                    print time.strftime(
                        self.time_format), "Some error happened during immediate retention report update {0}, Now sleeping".format(
                        previous_day)
                    time.sleep(180)
                    continue
                break

            while True:
                try:
                    print time.strftime(self.time_format), "Updating for real retention pivot table", date
                    self.update_retention_pivot_table(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(
                        self.time_format), "Some error happened during real retention pivot table {0}, Now sleeping".format(
                        date)
                    time.sleep(180)
                    continue
                break

    def check_export_access_log(self):
        export_access_log_list = yt.list(self.export_access_log_table_raw[:-1])
        unique_dayuse_tables_list = yt.list(self.unique_dayuse_table_raw[:-1])

        max_source = datetime.datetime.strptime(max(export_access_log_list), self.date_format)
        max_target = datetime.datetime.strptime(max(unique_dayuse_tables_list), self.date_format)

        delta = (max_source - max_target).days
        if delta == 0:
            missing_dates = []
        elif delta >= 1:
            missing_dates = self.prepare_dates(max_target.strftime(self.date_format),
                                               max_source.strftime(self.date_format))
            missing_dates.pop(0)
            # Last watchlog is not final, remove it too
            missing_dates.pop(-1)
            """
            if yt.get_attribute(self.export_access_log_table_raw + missing_dates[-1], 'sorted') == 'false':
                missing_dates.pop(-1)
            #Double check
            if len(missing_dates) > 0:
                if yt.get_attribute(self.export_access_log_table_raw + missing_dates[-1], 'sorted') == 'false':
                    missing_dates.pop(-1)


            if yt.get_attribute(self.export_access_log_table_raw + missing_dates[-1], '_statinfra_log_day_closed')['closed'] != '1':
                missing_dates.pop(-1)
            """

        else:
            pass
        # print self.prepare_dates(max_target.strftime(self.date_format), max_source.strftime(self.date_format))
        # print missing_dates

        if yt.is_empty(self.export_access_log_table_raw + max(export_access_log_list)):
            missing_dates = []  # check if table exists but it is empty (sometimes it happens)

        return missing_dates

    def update_daily_stat_tables(self, date):
        """ yasoft based """
        source_table = self.export_access_log_table_raw + date

        install_table = self.install_table_raw + date
        unique_install_table = self.unique_install_table_raw + date

        dayuse_table = self.dayuse_table_raw + date
        unique_dayuse_table = self.unique_dayuse_table_raw + date

        # Install Part
        if date < '2014-11-26':
            yt.run_map(
                YaSoftMapper(self.yasofts, self.clids, date, status='install'),
                source_table=source_table,
                destination_table=install_table,
                format=yt.DsvFormat(),
            )
        else:
            yt.run_map(
                YaSoftMapper2(self.yasofts, self.clids, date, status='install'),
                source_table=source_table,
                destination_table=install_table,
                format=yt.DsvFormat(),
            )

        yt.run_sort(
            source_table=install_table,
            destination_table=install_table,
            sort_by=['yasoft'],
        )
        yt.run_reduce(
            UniqueReducer(),
            source_table=install_table,
            destination_table=unique_install_table,
            reduce_by=['yasoft'],
            format=yt.DsvFormat(),
        )

        # Dayuse Part
        if date < '2014-11-26':
            yt.run_map(
                YaSoftMapper(self.yasofts, self.clids, date, status='dayuse'),
                source_table=source_table,
                destination_table=dayuse_table,
                format=yt.DsvFormat(),
            )
        else:
            yt.run_map(
                YaSoftMapper2(self.yasofts, self.clids, date, status='dayuse'),
                source_table=source_table,
                destination_table=dayuse_table,
                format=yt.DsvFormat(),
            )

        yt.run_sort(
            source_table=dayuse_table,
            destination_table=dayuse_table,
            sort_by=['yasoft'],
        )
        yt.run_reduce(
            UniqueReducer(),
            source_table=dayuse_table,
            destination_table=unique_dayuse_table,
            reduce_by=['yasoft'],
            format=yt.DsvFormat(),
        )

    def run_smooth_audience_report(self, date):

        print date
        dayuses = self.calculate_audience(date)
        print dayuses
        sdayuses = self.calculate_smooth_audience(date)
        print sdayuses

        stat_dict = {}
        for yasoft in self.yasofts:
            stat_dict['fielddate'] = date
            stat_dict['yasoft'] = yasoft
            stat_dict['dayuse'] = dayuses[yasoft]
            stat_dict['sdayuse'] = sdayuses[yasoft]
            self.update_daily_statface_report(name='smooth dayuse', data=[stat_dict])

    def calculate_audience(self, date):
        dayuses = {}
        for yasoft in self.yasofts:
            dayuses[yasoft] = []

        dayuse_table_final = self.unique_dayuse_table_raw + date

        for line in yt.read_table(dayuse_table_final, format='dsv'):
            items = line.strip().split('\t')

            # Prepare record dictionary
            record = {}
            for item in items:
                key, value = item.split('=', 1)
                record[key] = value

            dayuses[record['yasoft']].append(record['ui'])

        install_table_final = self.unique_install_table_raw + date
        for line in yt.read_table(install_table_final, format='dsv'):
            items = line.strip().split('\t')

            # Prepare record dictionary
            record = {}
            for item in items:
                key, value = item.split('=', 1)
                record[key] = value

            dayuses[record['yasoft']].append(record['ui'])

        for yasoft in self.yasofts:
            dayuses[yasoft] = len(set(dayuses[yasoft]))

        return dayuses

    def calculate_smooth_audience(self, date):
        begin_date = self.get_ndays_difference(date, -6)
        days = self.prepare_dates(begin_date, date)

        sdayuses = {}
        for yasoft in self.yasofts:
            sdayuses[yasoft] = []

        for day in days:

            dayuse_table_final = self.unique_dayuse_table_raw + day

            for line in yt.read_table(dayuse_table_final, format='dsv'):
                items = line.strip().split('\t')

                # Prepare record dictionary
                record = {}
                for item in items:
                    key, value = item.split('=', 1)
                    record[key] = value

                sdayuses[record['yasoft']].append(record['ui'])

            install_table_final = self.unique_install_table_raw + date
            for line in yt.read_table(install_table_final, format='dsv'):
                items = line.strip().split('\t')

                # Prepare record dictionary
                record = {}
                for item in items:
                    key, value = item.split('=', 1)
                    record[key] = value

                sdayuses[record['yasoft']].append(record['ui'])

        for yasoft in self.yasofts:
            sdayuses[yasoft] = len(set(sdayuses[yasoft]))

        return sdayuses

    def run_immediate_retention_report(self, date):
        next_day = self.get_ndays_difference(input_date=date, n=1)
        dayuse_table_final = self.unique_dayuse_table_raw + next_day

        if not yt.is_empty(dayuse_table_final):

            data, immediate_retention_numbers, immediate_retention_stats = self.calculate_immediate_retention(date)
            # weekly_installs, weekly_next_day_active, smooth_retention = self.calculate_smooth_immediate_retention(date)

            for yasoft in self.yasofts:
                stat_dict = {}
                stat_dict['fielddate'] = date
                stat_dict['yasoft'] = yasoft
                stat_dict['install'] = len(data[yasoft])
                stat_dict['next_day_active'] = immediate_retention_numbers[yasoft]

                if stat_dict['install'] > 100:
                    stat_dict['immediate_retention'] = immediate_retention_stats[yasoft]

                """
                stat_dict['weekspan_installs'] = weekly_installs[yasoft]

                if stat_dict['weekspan_installs'] > 100:
                    stat_dict['smooth_retention'] = smooth_retention[yasoft]

                stat_dict['weekspan_next_day_active'] = weekly_next_day_active[yasoft]
                """

                self.update_daily_statface_report(name='immediate retention', data=[stat_dict])

    def calculate_immediate_retention(self, date):
        print "immediate retention", date
        current_day = date
        next_day = self.get_ndays_difference(input_date=date, n=1)

        install_table_final = self.unique_install_table_raw + current_day
        dayuse_table_final = self.unique_dayuse_table_raw + next_day

        installation_data = {}
        immediate_retention_numbers = {}
        immediate_retention_stats = {}

        for yasoft in self.yasofts:
            installation_data[yasoft] = []
            immediate_retention_numbers[yasoft] = 0
            immediate_retention_stats[yasoft] = 0

        # if not yt.is_empty(dayuse_table_final):
        for line in yt.read_table(install_table_final, format='dsv'):
            items = line.strip().split('\t')

            # Prepare record dictionary
            record = {}
            for item in items:
                key, value = item.split('=', 1)
                record[key] = value

            installation_data[record['yasoft']].append(record['ui'])

        for line in yt.read_table(dayuse_table_final, format='dsv'):
            items = line.strip().split('\t')

            # Prepare record dictionary
            record = {}
            for item in items:
                key, value = item.split('=', 1)
                record[key] = value

            if record['ui'] in installation_data[record['yasoft']]:
                immediate_retention_numbers[record['yasoft']] += 1

        for yasoft in self.yasofts:
            if len(installation_data[yasoft]) != 0:
                immediate_retention_stats[yasoft] = immediate_retention_numbers[yasoft] / len(installation_data[yasoft])

        return installation_data, immediate_retention_numbers, immediate_retention_stats

    def calculate_smooth_immediate_retention(self, date):
        end_date = date
        initial_date = self.get_ndays_difference(date, -6)
        weekdays = self.prepare_dates(initial_date, end_date)

        weekly_installs = {}
        weekly_next_day_active = {}
        smooth_retention = {}

        for yasoft in self.yasofts:
            weekly_installs[yasoft] = 0
            weekly_next_day_active[yasoft] = 0

        for weekday in weekdays:
            data, immediate_retention_numbers, immediate_retention_stats = self.calculate_immediate_retention(weekday)

            for yasoft in self.yasofts:
                weekly_installs[yasoft] += len(data[yasoft])
                weekly_next_day_active[yasoft] += immediate_retention_numbers[yasoft]

        for yasoft in self.yasofts:
            if weekly_installs[yasoft] == 0:
                smooth_retention[yasoft] = 0
            else:
                smooth_retention[yasoft] = weekly_next_day_active[yasoft] / weekly_installs[yasoft]

        return weekly_installs, weekly_next_day_active, smooth_retention

    def run_real_retention_report(self, date, execute_operations=True):
        # self.update_retention_pivot_table(date)
        if execute_operations:
            self.execute_retention_pivot_table_operations()
        results = self.calculate_real_retention()

        one_week = self.get_ndays_difference(date, -6)
        two_weeks = self.get_ndays_difference(date, -13)
        three_weeks = self.get_ndays_difference(date, -20)
        four_weeks = self.get_ndays_difference(date, -27)

        for day in results:
            print day
            if day < one_week:
                for yasoft in results[day].keys():
                    stat_dict = {}
                    stat_dict['fielddate'] = day
                    stat_dict['yasoft'] = yasoft
                    stat_dict['install'] = results[day][yasoft]['install']
                    stat_dict['0day_active'] = results[day][yasoft]['zeroactive']

                    if results[day][yasoft]['install'] > 99:
                        stat_dict['0day_retention'] = results[day][yasoft]['zeroretention']

                    if day < two_weeks:
                        stat_dict['7day_active'] = results[day][yasoft]['sevenactive']
                        if results[day][yasoft]['install'] > 99:
                            stat_dict['7day_retention'] = results[day][yasoft]['sevenretention']

                    if day < three_weeks:
                        stat_dict['14day_active'] = results[day][yasoft]['fourteenactive']
                        if results[day][yasoft]['install'] > 99:
                            stat_dict['14day_retention'] = results[day][yasoft]['fourteenretention']

                    if day < four_weeks:
                        stat_dict['21day_active'] = results[day][yasoft]['twentyoneactive']
                        if results[day][yasoft]['install'] > 99:
                            stat_dict['21day_retention'] = results[day][yasoft]['twentyoneretention']

                    else:
                        pass

                    print stat_dict
                    self.update_daily_statface_report(name='real retention', data=[stat_dict])

    def update_retention_pivot_table(self, date):
        if date < '2014-11-26':
            yt.run_map(
                RetentionPivotTableMapper(self.yasofts, self.clids, date),
                source_table=self.export_access_log_table_raw + date,
                destination_table=yt.TablePath(self.retention_pivot_table, append=True),
                format=yt.DsvFormat(),
            )
        else:
            yt.run_map(
                RetentionPivotTableMapper2(self.yasofts, self.clids, date),
                source_table=self.export_access_log_table_raw + date,
                destination_table=yt.TablePath(self.retention_pivot_table, append=True),
                format=yt.DsvFormat(),
            )

        yt.run_sort(
            source_table=self.retention_pivot_table,
            destination_table=self.retention_pivot_table,
            sort_by=['timestamp']
        )

    def execute_retention_pivot_table_operations(self):
        # Sort by ui
        print "Sort by ui"
        yt.run_sort(
            source_table=self.retention_pivot_table,
            destination_table=self.retention_pivot_table + '-ui-sorted',
            sort_by=['ui']
        )

        # Reduce by ui to get row = eval(line.strip()) per ui
        print "Reduce by ui to get activeness per ui"
        yt.run_reduce(
            UiActivenessReducer(self.yasofts, self.date_format),
            source_table=self.retention_pivot_table + '-ui-sorted',
            destination_table=self.retention_pivot_table + '-ui-reduce',
            reduce_by=['ui'],
            format=yt.DsvFormat(),
        )

        # Sort by first_install i.e. install date
        print "Sort by first_install i.e. install date"
        yt.run_sort(
            source_table=self.retention_pivot_table + '-ui-reduce',
            destination_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            sort_by=['first_install']
        )

        # Reduce by install_date to get activeness per ui
        print "Reduce by install_date to get activeness per ui"
        yt.run_reduce(
            YasoftActivenessReducer(self.yasofts),
            source_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            destination_table=self.retention_pivot_table + '-activeness-frequency',
            reduce_by=['first_install'],
            format=yt.DsvFormat(),
        )

        # Sort PivotTable-activeness-frequency
        print "Sort PivotTable-activeness-frequency"
        yt.run_sort(
            source_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            destination_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            sort_by=['install_date', 'yasoft', 'activeness', 'count']
        )

    def calculate_real_retention(self):
        url = 'http://hahn.yt.yandex.net/api/v2/read?path={0}-activeness-frequency&output_format[$value]=json'.format(
            self.retention_pivot_table)
        r = requests.get(url)

        lines = r.text[:-1].split('\n')

        data = {}

        for line in lines:
            row = eval(line.strip())

            if not row["install_date"] in data:
                data[row["install_date"]] = {}
                data[row["install_date"]][row["yasoft"]] = {}
                data[row["install_date"]][row["yasoft"]][row["activeness"]] = int(row["count"])
            else:
                if not row["yasoft"] in data[row["install_date"]]:
                    data[row["install_date"]][row["yasoft"]] = {}
                    data[row["install_date"]][row["yasoft"]][row["activeness"]] = int(row["count"])
                else:
                    data[row["install_date"]][row["yasoft"]][row["activeness"]] = int(row["count"])

        results = {}
        for i in data.keys():
            results[i] = {}
            for j in data[i].keys():
                results[i][j] = {}

        # install
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    sum_ += int(data[i][j][k])
                    # print sum_,
                results[i][j]['install'] = sum_

        # zero active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 0:
                        sum_ += int(data[i][j][k])
                results[i][j]['zeroactive'] = sum_

        # zero retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['zeroretention'] = results[i][j]['zeroactive'] / results[i][j]['install']

        # seven active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 6:
                        sum_ += int(data[i][j][k])
                        # print sum_,
                results[i][j]['sevenactive'] = sum_

        # seven retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['sevenretention'] = results[i][j]['sevenactive'] / results[i][j]['install']

        # fourteen active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 13:
                        sum_ += int(data[i][j][k])
                        # print sum_,
                results[i][j]['fourteenactive'] = sum_

        # fourteen retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['fourteenretention'] = results[i][j]['fourteenactive'] / results[i][j]['install']

        # twentyone active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 20:
                        sum_ += int(data[i][j][k])
                        # print sum_,
                results[i][j]['twentyoneactive'] = sum_

        # seven retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['twentyoneretention'] = results[i][j]['twentyoneactive'] / results[i][j]['install']

        return results

    def one_time_fix(self):

        """
        dates = self.prepare_dates('2015-09-28', '2015-10-05')
        for date in dates:
            while True:
                try:
                    print time.strftime(self.time_format), "Updating for export-access-log", date
                    self.update_daily_stat_tables(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(self.time_format), "Some error happened during Updating for export-access-log {0}, Now sleeping".format(date)
                    time.sleep(180)
                    continue
                break

        dates = self.prepare_dates('2015-09-28', '2015-10-05')
        for date in dates:
            while True:
                try:
                    print time.strftime(self.time_format), "Running smooth audience report update", date
                    self.run_smooth_audience_report(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(self.time_format), "Some error happened during Running smooth audience report update {0}, Now sleeping".format(date)
                    time.sleep(180)
                    continue
                break

        dates = self.prepare_dates('2015-09-29', '2015-10-05')
        for date in dates:
            previous_day = self.get_ndays_difference(date, -1)
            while True:
                try:
                    print time.strftime(self.time_format), "Running immediate retention report update", previous_day
                    self.run_immediate_retention_report(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(self.time_format), "Some error happened during run_immediate_retention_report {0}, Now sleeping".format(previous_day)
                    time.sleep(180)
                    continue
                break


        dates = self.prepare_dates('2015-05-29', '2015-09-27')
        for date in dates:
            while True:
                try:
                    print time.strftime(self.time_format), "Updating for export-access-log", date
                    self.update_daily_stat_tables(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(self.time_format), "Some error happened during Updating for export-access-log {0}, Now sleeping".format(date)
                    time.sleep(180)
                    continue
                break

        dates = self.prepare_dates('2015-05-29', '2015-09-27')
        dates = self.prepare_dates('2015-07-22', '2015-09-27')
        for date in dates:
            while True:
                try:
                    print time.strftime(self.time_format), "Running smooth audience report update", date
                    self.run_smooth_audience_report(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(self.time_format), "Some error happened during Running smooth audience report update {0}, Now sleeping".format(date)
                    time.sleep(180)
                    continue
                break

        dates = self.prepare_dates('2015-05-29', '2015-09-28')
        """
        dates = self.prepare_dates('2015-07-14', '2015-08-27')
        for date in dates:
            previous_day = self.get_ndays_difference(date, -1)
            while True:
                try:
                    print time.strftime(self.time_format), "Running immediate retention report update", previous_day
                    self.run_immediate_retention_report(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(
                        self.time_format), "Some error happened during run_immediate_retention_report {0}, Now sleeping".format(
                        previous_day)
                    time.sleep(180)
                    continue
                break

        """
        print time.strftime(api.time_format), "Backup existing table"
        yt.copy(api.retention_pivot_table, api.retention_pivot_table + '-backup-beforeaddyasoftversionclidcheck')
        print time.strftime(api.time_format), "Delete existing table"
        yt.remove(api.retention_pivot_table)

        dates = self.prepare_dates('2015-05-29', '2015-10-05')
        for date in dates:
            while True:
                try:
                    print time.strftime(self.time_format), "Updating for real retention pivot table", date
                    self.update_retention_pivot_table(date)
                except Exception, e:
                    print str(e),
                    print time.strftime(self.time_format), "Some error happened during Updating for real retention pivot table {0}, Now sleeping".format(date)
                    time.sleep(180)
                    continue
                break

        print time.strftime(self.time_format), "Running real retention report update", dates[-1]
        self.run_real_retention_report(dates[-1])
        """

    def one_time_injection(self):
        yt.copy(self.retention_pivot_table, self.retention_pivot_table + '-backup-add2235099')

        new_clid = ['2235099']
        new_yasoft = ['homesearchextchrome_chr']

        # Update Intermediary Tables
        dates = self.prepare_dates('2015-09-21', '2015-09-29')

        for date in dates:
            source_table = self.export_access_log_table_raw + date

            install_table = self.install_table_raw + date
            unique_install_table = self.unique_install_table_raw + date

            dayuse_table = self.dayuse_table_raw + date
            unique_dayuse_table = self.unique_dayuse_table_raw + date

            # Install Part

            yt.run_map(
                YaSoftMapper(new_yasoft, new_clid, date, status='install'),
                source_table=source_table,
                destination_table=yt.TablePath(install_table, append=True),
                format=yt.DsvFormat(),
            )
            yt.run_sort(
                source_table=install_table,
                destination_table=install_table,
                sort_by=['yasoft'],
            )
            yt.run_reduce(
                UniqueReducer(),
                source_table=install_table,
                destination_table=unique_install_table,
                reduce_by=['yasoft'],
                format=yt.DsvFormat(),
            )

            # Dayuse Part
            yt.run_map(
                YaSoftMapper(new_yasoft, new_clid, date, status='dayuse'),
                source_table=source_table,
                destination_table=yt.TablePath(dayuse_table, append=True),
                format=yt.DsvFormat(),
            )
            yt.run_sort(
                source_table=dayuse_table,
                destination_table=dayuse_table,
                sort_by=['yasoft'],
            )
            yt.run_reduce(
                UniqueReducer(),
                source_table=dayuse_table,
                destination_table=unique_dayuse_table,
                reduce_by=['yasoft'],
                format=yt.DsvFormat(),
            )

            # PivotTable Part
            yt.run_map(
                RetentionPivotTableMapper(new_yasoft, new_clid, date),
                source_table=self.export_access_log_table_raw + date,
                destination_table=yt.TablePath(self.retention_pivot_table, append=True),
                format=yt.DsvFormat(),
            )

        # Run Reports
        dates = self.prepare_dates('2015-09-21', '2015-09-28')

        for date in dates:
            self.run_immediate_retention_report(date)

        self.run_real_retention_report('2015-09-29')

    def test_bannerid(self):
        """ yasoft based """
        dates = ['2015-11-02', '2015-11-03']

        for date in dates:
            source_table = self.export_access_log_table_raw + date

            destination_table = self.retention_temporary_dir + 'export_access_log-dayuse-' + date
            # Install Part

            yt.run_map(
                YaSoftMapperWithRequest(self.yasofts, self.clids, date, status='dayuse'),
                source_table=source_table,
                destination_table=destination_table,
                format=yt.DsvFormat(),
            )
            yt.run_sort(
                source_table=destination_table,
                destination_table=destination_table,
                sort_by=['yasoft'],
            )

    def test_bannerid_existance(self):
        dates = self.prepare_dates('2015-10-01', '2015-11-01')
        dates = self.prepare_dates('2015-09-01', '2015-09-30')
        dates = self.prepare_dates('2015-11-02', '2015-11-08')
        for date in dates:
            source_table = self.export_access_log_table_raw + date

            destination_table = self.retention_temporary_dir + 'bnrd-export_access_log-' + date
            # Install Part

            yt.run_map(
                YaSoftMapperOnlyWithBnrd(self.yasofts, self.clids, date),
                source_table=source_table,
                destination_table=destination_table,
                format=yt.DsvFormat(),
            )
            yt.run_sort(
                source_table=destination_table,
                destination_table=destination_table,
                sort_by=['yasoft'],
            )

    def test_check_bannerid_values(self):

        bnrd_table_raw = "//home/turkey-analytics/cansucullu/RetentionData/temp/bnrd-export_access_log-"
        output_reduce_table = "//home/turkey-analytics/cansucullu/RetentionData/temp/bnrd-export_access_log-analysis"
        dates = self.prepare_dates('2015-09-24', '2015-11-08')

        for date in dates:
            bnrd_table = bnrd_table_raw + date

            yt.run_reduce(
                BanneridReducer(date),
                source_table=bnrd_table,
                destination_table=yt.TablePath(output_reduce_table, append=True),
                reduce_by=['yasoft'],
                format=yt.DsvFormat(),
            )

        yt.run_sort(
            source_table=output_reduce_table,
            destination_table=output_reduce_table,
            sort_by=['date', 'yasoft', 'ver'],
        )

    def check_installations_by_version(self):

        install_table_raw = "//home/turkey-analytics/cansucullu/RetentionData/install/"
        output_reduce_table = "//home/turkey-analytics/cansucullu/RetentionData/temp/bnrd-all-export_access_log-analysis"
        dates = self.prepare_dates('2015-09-24', '2015-11-08')

        for date in dates:
            install_table = install_table_raw + date

            while True:
                try:
                    print time.strftime(self.time_format), "Updating for export-access-log", date

                    yt.run_reduce(
                        YaSoftVerCounterReducer(date),
                        source_table=install_table,
                        destination_table=yt.TablePath(output_reduce_table, append=True),
                        reduce_by=['yasoft'],
                        format=yt.DsvFormat(),
                    )

                except Exception, e:
                    print str(e),
                    print time.strftime(
                        self.time_format), "Some error happened during updating for export-access-log {0}, Now sleeping".format(
                        date)
                    time.sleep(180)
                    continue
                break

        yt.run_sort(
            source_table=output_reduce_table,
            destination_table=output_reduce_table,
            sort_by=['date', 'yasoft', 'ver'],
        )

    def update_bnrd_pivot_table(self, date):
        yt.run_map(
            BanneridRetentionPivotTableMapper(self.yasofts, self.clids, date),
            source_table=self.export_access_log_table_raw + date,
            destination_table=yt.TablePath(self.bnrd_pivot_table, append=True),
            format=yt.DsvFormat(),
        )
        yt.run_sort(
            source_table=self.bnrd_pivot_table,
            destination_table=self.bnrd_pivot_table,
            sort_by=['timestamp']
        )

    def execute_bnrd_pivot_table_operations(self):
        # Sort by ui
        print "Sort by ui"
        yt.run_sort(
            source_table=self.bnrd_pivot_table,
            destination_table=self.bnrd_pivot_table + '-ui-sorted',
            sort_by=['ui']
        )

        # Reduce by ui to get activeness per ui
        print "Reduce by ui to get activeness per ui"
        yt.run_reduce(
            BanneridUiActivenessReducer(self.yasofts, self.date_format),
            source_table=self.bnrd_pivot_table + '-ui-sorted',
            destination_table=self.bnrd_pivot_table + '-ui-reduce',
            reduce_by=['ui'],
            format=yt.DsvFormat(),
        )

        # Sort by first_install i.e. install date
        print "Sort by first_install i.e. install date"
        yt.run_sort(
            source_table=self.bnrd_pivot_table + '-ui-reduce',
            destination_table=self.bnrd_pivot_table + '-ui-reduce-installdate-sorted',
            sort_by=['first_install']
        )

        # Reduce by install_date to get activeness per ui
        print "Reduce by install_date to get activeness per ui"
        yt.run_reduce(
            BanneridYasoftActivenessReducer(self.yasofts),
            source_table=self.bnrd_pivot_table + '-ui-reduce-installdate-sorted',
            destination_table=self.bnrd_pivot_table + '-activeness-frequency',
            reduce_by=['first_install'],
            format=yt.DsvFormat(),
        )

        print "Sort PivotTable-activeness-frequency"
        yt.run_sort(
            source_table=self.bnrd_pivot_table + '-activeness-frequency',
            destination_table=self.bnrd_pivot_table + '-activeness-frequency',
            sort_by=['install_date', 'yasoft', 'bnrd', 'activeness', 'count']
        )

    def get_path_from_yasoftbnrd(self, yasoftbnrd):
        yasoft, bnrd = yasoftbnrd.split('\t')

        if bnrd == 'NA':
            return '\t{}\t{}\t'.format(yasoft, bnrd)

        else:
            source = bnrd[:4]
            target = bnrd[4:6]
            story = bnrd[6:8]

            source_map = {
                '1098': 'gdn',
                '0898': 'search',
                '5998': 'facebook',
                '0098': 'default',
            }

            target_map = {
                '04': 'chrome',
                '05': 'opera',
                '06': 'firefox',
                '07': 'ie',
                '00': 'default',
            }

            story_map = {
                '00': 'default',
                '01': 'ceviri',
                '02': 'brand',
                '03': 'futbol',
                '04': 'football',
                '05': 'havadurumu',
                '06': 'kahvefali',
                '07': 'oyun',
                '08': 'panorama',
                '09': 'sansoyunlari',
                '10': 'sureler',
                '11': 'trafik',
                '12': 'video',
                '13': 'secimler',
                '14': 'coffee',
                '15': 'panorama-live',
                '16': 'yemektarifi',
                '17': 'ekle',
                '18': 'ruyatabirleri',
                '19': 'videogames',
            }

            level_1 = '\t{}\t'.format(yasoft)
            level_2 = '\t{}\t{}\t'.format(yasoft, source_map[source])
            level_3 = '\t{}\t{}\t{}\t'.format(yasoft, source_map[source], target_map[target])
            level_4 = '\t{}\t{}\t{}\t{}\t'.format(yasoft, source_map.get(source, 'NA'), target_map.get(target, 'NA'),
                                                  story_map.get(story, 'NA'))

            return level_4

    def get_details_from_yasoftbnrd(self, yasoftbnrd):
        yasoft, bnrd = yasoftbnrd.split('\t')

        if bnrd == 'NA':
            bnrd = 'NONE'
            return [yasoft, bnrd, bnrd, bnrd, bnrd]

        else:
            source = bnrd[:4]
            target = bnrd[4:6]
            story = bnrd[6:8]
            variant = bnrd[8:]

            source_map = {
                '1098': 'gdn',
                '0898': 'search',
                '5998': 'facebook',
                '0098': 'default',
            }

            target_map = {
                '04': 'chrome',
                '05': 'opera',
                '06': 'firefox',
                '07': 'ie',
                '00': 'default',
            }

            story_map = {
                '00': 'default',
                '01': 'ceviri',
                '02': 'brand',
                '03': 'futbol',
                '04': 'football',
                '05': 'havadurumu',
                '06': 'kahvefali',
                '07': 'oyun',
                '08': 'panorama',
                '09': 'sansoyunlari',
                '10': 'sureler',
                '11': 'trafik',
                '12': 'video',
                '13': 'secimler',
                '14': 'coffee',
                '15': 'panorama-live',
                '16': 'yemektarifi',
                '17': 'ekle',
                '18': 'ruyatabirleri',
                '19': 'videogames',
            }

            story_map = get_bannerid_from_bunker()

            return [yasoft, source_map.get(source, 'NA'), target_map.get(target, 'NA'), story_map.get(story, 'NA'), variant]

    def run_bnrd_real_retention_report(self, date, execute_operations=True):
        # self.update_retention_pivot_table(date)
        if execute_operations:
            self.execute_bnrd_pivot_table_operations()
        results = self.calculate_bnrd_real_retention()

        one_week = self.get_ndays_difference(date, -6)
        two_weeks = self.get_ndays_difference(date, -13)
        three_weeks = self.get_ndays_difference(date, -20)
        four_weeks = self.get_ndays_difference(date, -27)

        data = {}
        for day in results:
            print "bnrd", day
            stat_list = []
            stat_list_filtered = []
            data[day] = {}

            for yasoftbnrd in results[day].keys():
                yasoft, source, target, story, variant = self.get_details_from_yasoftbnrd(yasoftbnrd)

                if yasoft not in data[day]:
                    data[day][yasoft] = {}

                    data[day][yasoft]['install'] = 0
                    data[day][yasoft]['zeroactive'] = 0
                    data[day][yasoft]['sevenactive'] = 0
                    data[day][yasoft]['fourteenactive'] = 0
                    data[day][yasoft]['twentyoneactive'] = 0

                if source not in data[day][yasoft]:
                    data[day][yasoft][source] = {}

                    data[day][yasoft][source]['install'] = 0
                    data[day][yasoft][source]['zeroactive'] = 0
                    data[day][yasoft][source]['sevenactive'] = 0
                    data[day][yasoft][source]['fourteenactive'] = 0
                    data[day][yasoft][source]['twentyoneactive'] = 0

                if target not in data[day][yasoft][source]:
                    data[day][yasoft][source][target] = {}

                    data[day][yasoft][source][target]['install'] = 0
                    data[day][yasoft][source][target]['zeroactive'] = 0
                    data[day][yasoft][source][target]['sevenactive'] = 0
                    data[day][yasoft][source][target]['fourteenactive'] = 0
                    data[day][yasoft][source][target]['twentyoneactive'] = 0

                if story not in data[day][yasoft][source][target]:
                    data[day][yasoft][source][target][story] = {}

                    data[day][yasoft][source][target][story]['install'] = 0
                    data[day][yasoft][source][target][story]['zeroactive'] = 0
                    data[day][yasoft][source][target][story]['sevenactive'] = 0
                    data[day][yasoft][source][target][story]['fourteenactive'] = 0
                    data[day][yasoft][source][target][story]['twentyoneactive'] = 0

                if variant not in data[day][yasoft][source][target][story]:
                    data[day][yasoft][source][target][story][variant] = {}

                    data[day][yasoft][source][target][story][variant]['install'] = 0
                    data[day][yasoft][source][target][story][variant]['zeroactive'] = 0
                    data[day][yasoft][source][target][story][variant]['sevenactive'] = 0
                    data[day][yasoft][source][target][story][variant]['fourteenactive'] = 0
                    data[day][yasoft][source][target][story][variant]['twentyoneactive'] = 0

                data[day][yasoft][source][target][story][variant]['install'] += results[day][yasoftbnrd]['install']
                data[day][yasoft][source][target][story][variant]['zeroactive'] += results[day][yasoftbnrd]['zeroactive']
                data[day][yasoft][source][target][story][variant]['sevenactive'] +=  results[day][yasoftbnrd]['sevenactive']
                data[day][yasoft][source][target][story][variant]['fourteenactive'] += results[day][yasoftbnrd]['fourteenactive']
                data[day][yasoft][source][target][story][variant]['twentyoneactive'] += results[day][yasoftbnrd]['twentyoneactive']

                data[day][yasoft][source][target][story]['install'] += results[day][yasoftbnrd]['install']
                data[day][yasoft][source][target][story]['zeroactive'] += results[day][yasoftbnrd]['zeroactive']
                data[day][yasoft][source][target][story]['sevenactive'] += results[day][yasoftbnrd]['sevenactive']
                data[day][yasoft][source][target][story]['fourteenactive'] += results[day][yasoftbnrd]['fourteenactive']
                data[day][yasoft][source][target][story]['twentyoneactive'] += results[day][yasoftbnrd]['twentyoneactive']

                data[day][yasoft][source][target]['install'] += results[day][yasoftbnrd]['install']
                data[day][yasoft][source][target]['zeroactive'] += results[day][yasoftbnrd]['zeroactive']
                data[day][yasoft][source][target]['sevenactive'] += results[day][yasoftbnrd]['sevenactive']
                data[day][yasoft][source][target]['fourteenactive'] += results[day][yasoftbnrd]['fourteenactive']
                data[day][yasoft][source][target]['twentyoneactive'] += results[day][yasoftbnrd]['twentyoneactive']

                data[day][yasoft][source]['install'] += results[day][yasoftbnrd]['install']
                data[day][yasoft][source]['zeroactive'] += results[day][yasoftbnrd]['zeroactive']
                data[day][yasoft][source]['sevenactive'] += results[day][yasoftbnrd]['sevenactive']
                data[day][yasoft][source]['fourteenactive'] += results[day][yasoftbnrd]['fourteenactive']
                data[day][yasoft][source]['twentyoneactive'] += results[day][yasoftbnrd]['twentyoneactive']

                data[day][yasoft]['install'] += results[day][yasoftbnrd]['install']
                data[day][yasoft]['zeroactive'] += results[day][yasoftbnrd]['zeroactive']
                data[day][yasoft]['sevenactive'] += results[day][yasoftbnrd]['sevenactive']
                data[day][yasoft]['fourteenactive'] += results[day][yasoftbnrd]['fourteenactive']
                data[day][yasoft]['twentyoneactive'] += results[day][yasoftbnrd]['twentyoneactive']

            keys_to_exclude = ['install', 'zeroactive', 'sevenactive', 'fourteenactive', 'twentyoneactive']
            keys_to_exclude = set(keys_to_exclude)

        print data.keys()
        for day in list(set(data.keys()) - set(['2015-08-21'])):
            for yasoft in list(set(data[day].keys()) - keys_to_exclude):
                for source in list(set(data[day][yasoft].keys()) - keys_to_exclude):
                    for target in list(set(data[day][yasoft][source].keys()) - keys_to_exclude):
                        for story in list(set(data[day][yasoft][source][target].keys()) - keys_to_exclude):
                            for variant in list(set(data[day][yasoft][source][target][story].keys()) - keys_to_exclude):

                                path = '\t{}\t{}\t{}\t{}\t{}\t'.format(yasoft, source, target, story, variant)
                                stat_dict = {}
                                stat_dict['fielddate'] = day
                                stat_dict['path'] = path.upper()
                                stat_dict['install'] = data[day][yasoft][source][target][story][variant]['install']
                                stat_dict['0day_active'] = data[day][yasoft][source][target][story][variant]['zeroactive']
                                if day < two_weeks:
                                    stat_dict['7day_active'] = data[day][yasoft][source][target][story][variant]['sevenactive']
                                if day < three_weeks:
                                    stat_dict['14day_active'] = data[day][yasoft][source][target][story][variant]['fourteenactive']
                                if day < four_weeks:
                                    stat_dict['21day_active'] = data[day][yasoft][source][target][story][variant]['twentyoneactive']
                                print stat_dict
                                stat_list.append(stat_dict)
                                if stat_dict['install'] >= 100:
                                    stat_list_filtered.append(stat_dict)
                                #self.update_daily_statface_report(name='retention bannerid', data=[stat_dict])

                            path = '\t{}\t{}\t{}\t{}\t'.format(yasoft, source, target, story)
                            stat_dict = {}
                            stat_dict['fielddate'] = day
                            stat_dict['path'] = path.upper()
                            stat_dict['install'] = data[day][yasoft][source][target][story]['install']
                            stat_dict['0day_active'] = data[day][yasoft][source][target][story]['zeroactive']
                            if day < two_weeks:
                                stat_dict['7day_active'] = data[day][yasoft][source][target][story]['sevenactive']
                            if day < three_weeks:
                                stat_dict['14day_active'] = data[day][yasoft][source][target][story]['fourteenactive']
                            if day < four_weeks:
                                stat_dict['21day_active'] = data[day][yasoft][source][target][story]['twentyoneactive']
                            print stat_dict
                            stat_list.append(stat_dict)
                            if stat_dict['install'] >= 100:
                                stat_list_filtered.append(stat_dict)
                                # self.update_daily_statface_report(name='retention bannerid', data=[stat_dict])

                        path = '\t{}\t{}\t{}\t'.format(yasoft, source, target)
                        stat_dict = {}
                        stat_dict['fielddate'] = day
                        stat_dict['path'] = path.upper()
                        stat_dict['install'] = data[day][yasoft][source][target]['install']
                        stat_dict['0day_active'] = data[day][yasoft][source][target]['zeroactive']
                        if day < two_weeks:
                            stat_dict['7day_active'] = data[day][yasoft][source][target]['sevenactive']
                        if day < three_weeks:
                            stat_dict['14day_active'] = data[day][yasoft][source][target]['fourteenactive']
                        if day < four_weeks:
                            stat_dict['21day_active'] = data[day][yasoft][source][target]['twentyoneactive']
                        print stat_dict
                        stat_list.append(stat_dict)
                        if stat_dict['install'] >= 100:
                            stat_list_filtered.append(stat_dict)
                            # self.update_daily_statface_report(name='retention bannerid', data=[stat_dict])

                    path = '\t{}\t{}\t'.format(yasoft, source)
                    stat_dict = {}
                    stat_dict['fielddate'] = day
                    stat_dict['path'] = path.upper()
                    stat_dict['install'] = data[day][yasoft][source]['install']
                    stat_dict['0day_active'] = data[day][yasoft][source]['zeroactive']
                    if day < two_weeks:
                        stat_dict['7day_active'] = data[day][yasoft][source]['sevenactive']
                    if day < three_weeks:
                        stat_dict['14day_active'] = data[day][yasoft][source]['fourteenactive']
                    if day < four_weeks:
                        stat_dict['21day_active'] = data[day][yasoft][source]['twentyoneactive']
                    print stat_dict
                    stat_list.append(stat_dict)
                    if stat_dict['install'] >= 100:
                        stat_list_filtered.append(stat_dict)
                        # self.update_daily_statface_report(name='retention bannerid', data=[stat_dict])

                path = '\t{}\t'.format(yasoft)
                stat_dict = {}
                stat_dict['fielddate'] = day
                stat_dict['path'] = path.upper()
                stat_dict['install'] = data[day][yasoft]['install']
                stat_dict['0day_active'] = data[day][yasoft]['zeroactive']
                if day < two_weeks:
                    stat_dict['7day_active'] = data[day][yasoft]['sevenactive']
                if day < three_weeks:
                    stat_dict['14day_active'] = data[day][yasoft]['fourteenactive']
                if day < four_weeks:
                    stat_dict['21day_active'] = data[day][yasoft]['twentyoneactive']
                print stat_dict
                stat_list.append(stat_dict)
                if stat_dict['install'] >= 100:
                    stat_list_filtered.append(stat_dict)
                    # self.update_daily_statface_report(name='retention bannerid', data=[stat_dict])

            self.update_daily_statface_report_overwrite(name='retention bannerid', data=stat_list)
            self.update_daily_statface_report_overwrite(name='retention bannerid filtered', data=stat_list_filtered)

    def _backup_run_bnrd_real_retention_report(self, date, execute_operations=True):
        # self.update_retention_pivot_table(date)
        if execute_operations:
            self.execute_bnrd_pivot_table_operations()
        results = self.calculate_bnrd_real_retention()

        one_week = self.get_ndays_difference(date, -6)
        two_weeks = self.get_ndays_difference(date, -13)
        three_weeks = self.get_ndays_difference(date, -20)
        four_weeks = self.get_ndays_difference(date, -27)

        for day in results:
            print day
            if day < one_week:
                for yasoftbnrd in results[day].keys():

                    stat_dict = {}
                    stat_dict['fielddate'] = day

                    stat_dict['path'] = self.get_path_from_yasoftbnrd(yasoftbnrd)

                    stat_dict['install'] = results[day][yasoftbnrd]['install']
                    stat_dict['0day_active'] = results[day][yasoftbnrd]['zeroactive']

                    if results[day][yasoftbnrd]['install'] > 99:
                        stat_dict['0day_retention'] = results[day][yasoftbnrd]['zeroretention']

                    if day < two_weeks:
                        stat_dict['7day_active'] = results[day][yasoftbnrd]['sevenactive']
                        if results[day][yasoftbnrd]['install'] > 99:
                            stat_dict['7day_retention'] = results[day][yasoftbnrd]['sevenretention']

                    if day < three_weeks:
                        stat_dict['14day_active'] = results[day][yasoftbnrd]['fourteenactive']
                        if results[day][yasoftbnrd]['install'] > 99:
                            stat_dict['14day_retention'] = results[day][yasoftbnrd]['fourteenretention']

                    if day < four_weeks:
                        stat_dict['21day_active'] = results[day][yasoftbnrd]['twentyoneactive']
                        if results[day][yasoftbnrd]['install'] > 99:
                            stat_dict['21day_retention'] = results[day][yasoftbnrd]['twentyoneretention']

                    else:
                        pass

                    print stat_dict
                    self.update_daily_statface_report(name='retention bannerid', data=[stat_dict])

    def calculate_bnrd_real_retention(self):
        url = 'http://hahn.yt.yandex.net/api/v2/read?path={0}-activeness-frequency&output_format[$value]=json'.format(
            self.bnrd_pivot_table)
        r = requests.get(url)

        lines = r.text[:-1].split('\n')

        data = {}

        for line in lines:
            row = eval(line.strip())

            # Important Part
            # bnrds_to_exclude = ['809943164', '0010101010', '0101040001']
            bnrds_to_exclude = ['']
            if row["bnrd"] not in bnrds_to_exclude:
                row["yasoftbnrd"] = str(row["yasoft"]) + '\t' + str(row["bnrd"])

                if not row["install_date"] in data:
                    data[row["install_date"]] = {}
                    data[row["install_date"]][row["yasoftbnrd"]] = {}
                    data[row["install_date"]][row["yasoftbnrd"]][row["activeness"]] = int(row["count"])
                else:
                    if not row["yasoftbnrd"] in data[row["install_date"]]:
                        data[row["install_date"]][row["yasoftbnrd"]] = {}
                        data[row["install_date"]][row["yasoftbnrd"]][row["activeness"]] = int(row["count"])
                    else:
                        data[row["install_date"]][row["yasoftbnrd"]][row["activeness"]] = int(row["count"])

        results = {}
        for i in data.keys():
            results[i] = {}
            for j in data[i].keys():
                results[i][j] = {}

        # install
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    sum_ += int(data[i][j][k])
                    # print sum_,
                results[i][j]['install'] = sum_

        # zero active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 0:
                        sum_ += int(data[i][j][k])
                results[i][j]['zeroactive'] = sum_

        # zero retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['zeroretention'] = results[i][j]['zeroactive'] / results[i][j]['install']

        # seven active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 6:
                        sum_ += int(data[i][j][k])
                        # print sum_,
                results[i][j]['sevenactive'] = sum_

        # seven retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['sevenretention'] = results[i][j]['sevenactive'] / results[i][j]['install']

        # fourteen active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 13:
                        sum_ += int(data[i][j][k])
                        # print sum_,
                results[i][j]['fourteenactive'] = sum_

        # fourteen retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['fourteenretention'] = results[i][j]['fourteenactive'] / results[i][j]['install']

        # twentyone active
        for i in data.keys():
            for j in data[i].keys():
                sum_ = 0
                for k in data[i][j].keys():
                    if int(k) > 20:
                        sum_ += int(data[i][j][k])
                        # print sum_,
                results[i][j]['twentyoneactive'] = sum_

        # seven retention
        for i in data.keys():
            for j in data[i].keys():
                results[i][j]['twentyoneretention'] = results[i][j]['twentyoneactive'] / results[i][j]['install']

        return results

    def temporary_things(self):
        # Reduce by install_date to get activeness per ui
        print "Reduce by install_date to get activeness per ui"
        yt.run_reduce(
            YasoftActivenessReducer(self.yasofts),
            source_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            destination_table=self.retention_pivot_table + '-activeness-frequency',
            reduce_by=['first_install'],
            format=yt.DsvFormat(),
        )

        # Sort PivotTable-activeness-frequency
        print "Sort PivotTable-activeness-frequency"
        yt.run_sort(
            source_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            destination_table=self.retention_pivot_table + '-ui-reduce-installdate-sorted',
            sort_by=['install_date', 'yasoft', 'activeness', 'count']
        )


class YaSoftMapper:
    def __init__(self, software_to_check, clids_to_check, date, status):
        self.clids_to_check = clids_to_check
        self.date = date
        self.software_to_check = software_to_check
        self.status = status

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        items = rec['value'].split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        if data.has_key('request') and data.has_key('cookies') and data.has_key('timestamp'):

            # request part
            url = data['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(data['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'
            if cookie_final == '':
                cookie_final = '-'

            # clid part
            if params.has_key('clid'):
                clid_final = params['clid'][0]
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
            else:
                clid_final = "NA"

            # timestamp part
            if data.has_key('timestamp'):
                timestamp_final = str(data['timestamp']).replace('/', '-')
            else:
                timestamp_final = "NA"

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # bnrd part
            if params.has_key('bnrd'):
                bnrd_final = params['bnrd'][0]
            else:
                bnrd_final = "NA"

            # ip part
            ip_final = data.get('ip', 'NA')

            # yield part
            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and data.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            if yield_condition:
                if params['stat'][0] == self.status:
                    yield {
                        # 'day': self.date,
                        'clid': clid_final,
                        'ui': params['ui'][0][1:-1],  # eliminate brackets in ui
                        'yandexuid': "y" + cookie_final,
                        'timestamp': timestamp_final,
                        'yasoft': yasoft_final,
                        # 'stat': params['stat'][0],
                        'ver': version_final,
                        'bnrd': bnrd_final,
                        'ip': ip_final,
                    }


class YaSoftMapper2:
    def __init__(self, software_to_check, clids_to_check, date, status):
        self.clids_to_check = clids_to_check
        self.date = date
        self.software_to_check = software_to_check
        self.status = status

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        if rec.has_key('request') and rec.has_key('cookies') and rec.has_key('timestamp'):

            # request part
            url = rec['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(rec['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'
            if cookie_final == '':
                cookie_final = '-'

            # clid part
            if params.has_key('clid'):
                clid_final = params['clid'][0]
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
            else:
                clid_final = "NA"

            # timestamp part
            if rec.has_key('timestamp'):
                timestamp_final = str(rec['timestamp']).replace('/', '-')
            else:
                timestamp_final = "NA"

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # bnrd part
            if params.has_key('bnrd'):
                bnrd_final = params['bnrd'][0]
            else:
                bnrd_final = "NA"

            # ip part
            ip_final = rec.get('ip', 'NA')

            # yield part
            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and rec.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'startextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            if yield_condition:
                if params['stat'][0] == self.status:
                    yield {
                        # 'day': self.date,
                        'clid': clid_final,
                        'ui': params['ui'][0][1:-1],  # eliminate brackets in ui
                        'yandexuid': "y" + cookie_final,
                        'timestamp': timestamp_final,
                        'yasoft': yasoft_final,
                        # 'stat': params['stat'][0],
                        'ver': version_final,
                        'bnrd': bnrd_final,
                        'ip': ip_final,
                    }


class YaSoftMapperWithRequest:
    def __init__(self, software_to_check, clids_to_check, date, status):
        self.clids_to_check = clids_to_check
        self.date = date
        self.software_to_check = software_to_check
        self.status = status

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        items = rec['value'].split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        if data.has_key('request') and data.has_key('cookies') and data.has_key('timestamp'):

            # request part
            url = data['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(data['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'
            if cookie_final == '':
                cookie_final = '-'

            # clid part
            if params.has_key('clid'):
                clid_final = params['clid'][0]
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
            else:
                clid_final = "NA"

            # timestamp part
            if data.has_key('timestamp'):
                timestamp_final = str(data['timestamp']).replace('/', '-')
            else:
                timestamp_final = "NA"

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # yield part
            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and data.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            if yield_condition:
                if params['stat'][0] == self.status:
                    yield {
                        # 'day': self.date,
                        'clid': clid_final,
                        'ui': params['ui'][0][1:-1],  # eliminate brackets in ui
                        'yandexuid': "y" + cookie_final,
                        'timestamp': timestamp_final,
                        'yasoft': yasoft_final,
                        'stat': params['stat'][0],
                        'ver': version_final,
                        'request': url,
                    }

            """
            if params.has_key('stat') and params.has_key('ui') and data.has_key('timestamp'):
                if clid_final in self.clids_to_check:
                    if yasoft_final in self.software_to_check:
                        if params['stat'][0] == self.status:
                            yield {
                                #'day': self.date,
                                'clid': clid_final,
                                'ui': params['ui'][0][1:-1], # eliminate brackets in ui
                                'yandexuid': "y"+cookie_final,
                                'timestamp': timestamp_final,
                                'yasoft': yasoft_final,
                                #'stat': params['stat'][0],
                                'ver': version_final,
                            }
            """


class YaSoftMapperOnlyWithBnrd:
    def __init__(self, software_to_check, clids_to_check, date):
        self.clids_to_check = clids_to_check
        self.date = date
        self.software_to_check = software_to_check

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        items = rec['value'].split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        if data.has_key('request') and data.has_key('cookies') and data.has_key('timestamp'):

            # request part
            url = data['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(data['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'
            if cookie_final == '':
                cookie_final = '-'

            # clid part
            if params.has_key('clid'):
                clid_final = params['clid'][0]
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
            else:
                clid_final = "NA"

            # timestamp part
            if data.has_key('timestamp'):
                timestamp_final = str(data['timestamp']).replace('/', '-')
            else:
                timestamp_final = "NA"

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # yield part
            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and data.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            # bnrd part
            if params.has_key('bnrd'):
                bnrd_final = params['bnrd'][0]
            else:
                bnrd_final = "NA"
                yield_condition = False

            if yield_condition:
                yield {
                    # 'day': self.date,
                    'clid': clid_final,
                    'ui': params['ui'][0][1:-1],  # eliminate brackets in ui
                    'yandexuid': "y" + cookie_final,
                    'timestamp': timestamp_final,
                    'yasoft': yasoft_final,
                    'stat': params['stat'][0],
                    'ver': version_final,
                    'request': url,
                    'bnrd': bnrd_final,
                }


class ExportAccessLogMapper:
    def __init__(self, clids_to_check, date, status):
        self.clids_to_check = clids_to_check
        self.date = date
        self.status = status

    def __call__(self, rec):
        items = rec['value'].split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        if data.has_key('request') and data.has_key('cookies') and data.has_key('timestamp') and data.has_key(
                'cookies'):

            # request part
            url = data['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(data['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'

            if cookie_final == '':
                cookie_final = '-'

            # clid part
            clid_final = "NA"
            clid_condition = params.has_key('clid') or params.has_key('clid1')
            if params.has_key('clid'):
                clid_final = params['clid'][0]
                clid_condition = True
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
                clid_condition = True
            else:
                clid_condition = False

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # yield part
            if clid_condition == True and params.has_key('stat') and params.has_key('ui') and data.has_key('timestamp'):
                if clid_final in self.clids_to_check:
                    # if params['stat'][0] == 'install':
                    if params['stat'][0] == self.status:
                        yield {
                            # 'day':self.d,
                            'clid': clid_final,
                            'ui': params['ui'][0][1:-1],  # eliminate brackets in ui
                            'yandexuid': "y" + cookie_final,
                            'timestamp': str(data['timestamp']).replace('/', '-'),
                            'yasoft': yasoft_final,
                        }


class UniqueReducer():
    def __call__(self, key, recs):
        uis = []
        for rec in recs:
            uis.append(rec['ui'])

        uis = set(uis)

        for ui in uis:
            # yield {'clid':key['clid'], 'ui':str(ui)}
            yield {'yasoft': key['yasoft'], 'ui': str(ui)}


class RetentionPivotTableMapper:
    def __init__(self, yasofts_to_check, clids_to_check, date):
        self.clids_to_check = clids_to_check
        self.yasofts_to_check = yasofts_to_check
        self.date = date

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        items = rec['value'].split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        if data.has_key('request') and data.has_key('cookies') and data.has_key('timestamp') and data.has_key(
                'cookies'):

            # request part
            url = data['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(data['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'

            # clid part
            clid_final = "NA"
            clid_condition = params.has_key('clid') or params.has_key('clid1')
            if params.has_key('clid'):
                clid_final = params['clid'][0]
                clid_condition = True
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
                clid_condition = True
            else:
                clid_condition = False

            # timestamp part
            if data.has_key('timestamp'):
                timestamp_final = str(data['timestamp']).replace('/', '-')
            else:
                timestamp_final = "NA"

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # yield part
            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and data.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            if yield_condition:
                yield {
                    'day': self.date,
                    'yasoft': yasoft_final,
                    'ui': params['ui'][0][1:-1],
                    'stat': params['stat'][0],
                    'yandexuid': "y" + cookie_final,
                    'timestamp': str(data['timestamp']).replace('/', '-'),
                }


class RetentionPivotTableMapper2:
    def __init__(self, yasofts_to_check, clids_to_check, date):
        self.clids_to_check = clids_to_check
        self.yasofts_to_check = yasofts_to_check
        self.date = date

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        if rec.has_key('request') and rec.has_key('cookies') and rec.has_key('timestamp') and rec.has_key('cookies'):

            # request part
            url = rec['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(rec['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'

            # clid part
            clid_final = "NA"
            clid_condition = params.has_key('clid') or params.has_key('clid1')
            if params.has_key('clid'):
                clid_final = params['clid'][0]
                clid_condition = True
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
                clid_condition = True
            else:
                clid_condition = False

            # timestamp part
            if rec.has_key('timestamp'):
                timestamp_final = str(rec['timestamp']).replace('/', '-')
            else:
                timestamp_final = "NA"

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # yield part
            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and rec.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'startextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            if yield_condition:
                yield {
                    'day': self.date,
                    'yasoft': yasoft_final,
                    'ui': params['ui'][0][1:-1],
                    'stat': params['stat'][0],
                    'yandexuid': "y" + cookie_final,
                    'timestamp': str(rec['timestamp']).replace('/', '-'),
                }


class UiActivenessReducer():
    def __init__(self, yasofts, date_format):
        self.yasofts = yasofts
        self.date_format = date_format

    def __call__(self, key, recs):
        data = {}

        for yasoft in self.yasofts:
            data[yasoft] = {}
            data[yasoft]['install'] = []
            data[yasoft]['dayuse'] = []

        for rec in recs:
            yasoft = rec['yasoft']
            stat = rec['stat']
            day = rec['day']

            if data.has_key(yasoft):
                if data[yasoft].has_key(stat):
                    data[yasoft][stat].append(datetime.datetime.strptime(day, self.date_format))

        for yasoft in data.keys():
            if len(data[yasoft]['install']) > 0:  # If there is at least one install record

                first_install = min(data[yasoft]['install'])

                if len(data[yasoft]['dayuse']) == 0:
                    yield {
                        'ui': key['ui'],
                        'yasoft': yasoft,
                        'activeness': str(0),
                        'first_install': first_install.strftime(self.date_format),
                        'last_dayuse': '0',
                    }
                else:
                    last_dayuse = max(data[yasoft]['dayuse'])
                    delta = last_dayuse - first_install
                    activeness = str(delta.days)
                    yield {
                        'ui': key['ui'],
                        'yasoft': yasoft,
                        'activeness': activeness,
                        'first_install': first_install.strftime(self.date_format),
                        'last_dayuse': last_dayuse.strftime(self.date_format),
                    }


class YasoftActivenessReducer():
    def __init__(self, yasofts):
        self.yasofts = yasofts

    def __call__(self, key, recs):
        data = {}

        for yasoft in self.yasofts:
            data[yasoft] = {}

        for rec in recs:
            first_install = key['first_install']
            activeness = rec['activeness']
            yasoft = rec['yasoft']
            last_dayuse = rec['last_dayuse']
            ui = rec['ui']

            if data.has_key(yasoft):
                if not data[yasoft].has_key(activeness):
                    data[yasoft][activeness] = 1
                else:
                    data[yasoft][activeness] += 1

        for yasoft in data.keys():
            for activeness in data[yasoft].keys():
                count = data[yasoft][activeness]
                yield {
                    'install_date': key['first_install'],
                    'yasoft': yasoft,
                    'activeness': int(activeness),
                    'count': int(count),
                }


class BanneridRetentionPivotTableMapper:
    def __init__(self, yasofts_to_check, clids_to_check, date):
        self.clids_to_check = clids_to_check
        self.yasofts_to_check = yasofts_to_check
        self.date = date

        self.tr_versions = ['8.14.8', '8.11.4', '8.11.3', '8.11.2', '8.11.0', '8.10.2', '8.10.1', '8.9.1', '8.10.0']

    def __call__(self, rec):
        if rec.has_key('request') and rec.has_key('cookies') and rec.has_key('timestamp') and rec.has_key('cookies'):

            # request part
            url = rec['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(rec['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'

            # clid part
            clid_final = "NA"
            clid_condition = params.has_key('clid') or params.has_key('clid1')
            if params.has_key('clid'):
                clid_final = params['clid'][0]
                clid_condition = True
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
                clid_condition = True
            else:
                clid_condition = False

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            # bnrd part
            if params.has_key('bnrd'):
                bnrd_final = params['bnrd'][0]
            else:
                bnrd_final = "NA"

            # ip part
            ip_final = rec.get('ip', 'NA')

            yield_condition = False
            if params.has_key('stat') and params.has_key('ui') and rec.has_key('timestamp'):
                if yasoft_final == 'litevbchrome_chr':
                    yield_condition = True
                elif yasoft_final == 'homesearchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'startextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                elif yasoft_final == 'searchextchrome_chr':
                    if clid_final in self.clids_to_check:
                        yield_condition = True
                    else:
                        if version_final in self.tr_versions:
                            yield_condition = True
                else:
                    pass

            if yield_condition:
                yield {
                    'day': self.date,
                    'yasoft': yasoft_final,
                    'ui': params['ui'][0][1:-1],
                    'stat': params['stat'][0],
                    'yandexuid': "y" + cookie_final,
                    'timestamp': str(rec['timestamp']).replace('/', '-'),
                    'bnrd': bnrd_final,
                    'ip': ip_final,
                }


class BanneridUiActivenessReducer():
    def __init__(self, yasofts, date_format):
        self.yasofts = yasofts
        self.date_format = date_format

    def __call__(self, key, recs):
        data = {}

        for yasoft in self.yasofts:
            data[yasoft] = {}
            data[yasoft]['install'] = []
            data[yasoft]['dayuse'] = []

        for rec in recs:
            yasoft = rec['yasoft']
            stat = rec['stat']
            day = rec['day']
            bnrd = rec['bnrd']

            if data.has_key(yasoft):
                if data[yasoft].has_key(stat):
                    data[yasoft][stat].append(datetime.datetime.strptime(day, self.date_format))

        for yasoft in data.keys():
            if len(data[yasoft]['install']) > 0:  # If there is at least one install record

                first_install = min(data[yasoft]['install'])

                if len(data[yasoft]['dayuse']) == 0:
                    yield {
                        'ui': key['ui'],
                        'yasoft': yasoft,
                        'activeness': str(0),
                        'first_install': first_install.strftime(self.date_format),
                        'last_dayuse': '0',
                        'bnrd': bnrd,
                    }
                else:
                    last_dayuse = max(data[yasoft]['dayuse'])
                    delta = last_dayuse - first_install
                    activeness = str(delta.days)
                    yield {
                        'ui': key['ui'],
                        'yasoft': yasoft,
                        'activeness': activeness,
                        'first_install': first_install.strftime(self.date_format),
                        'last_dayuse': last_dayuse.strftime(self.date_format),
                        'bnrd': bnrd,
                    }


class BanneridYasoftActivenessReducer():
    def __init__(self, yasofts):
        self.yasofts = yasofts

    def __call__(self, key, recs):
        data = {}

        for yasoft in self.yasofts:
            data[yasoft] = {}

        for rec in recs:
            first_install = key['first_install']
            activeness = rec['activeness']
            yasoft = rec['yasoft']
            last_dayuse = rec['last_dayuse']
            ui = rec['ui']
            bnrd = rec['bnrd']

            if data.has_key(yasoft):

                if not bnrd in data[yasoft].keys():
                    data[yasoft][bnrd] = {}

                if not activeness in data[yasoft][bnrd].keys():
                    data[yasoft][bnrd][activeness] = 1
                else:
                    data[yasoft][bnrd][activeness] += 1

        for yasoft in data.keys():
            for bnrd in data[yasoft].keys():
                for activeness in data[yasoft][bnrd].keys():
                    count = data[yasoft][bnrd][activeness]
                    yield {
                        'install_date': key['first_install'],
                        'yasoft': yasoft,
                        'activeness': activeness,
                        'count': str(count),
                        'bnrd': bnrd,
                    }


class SoftGuidYasoftMapper:
    def __init__(self, clids_to_check):
        self.clids_to_check = clids_to_check

    def __call__(self, rec):
        items = rec['value'].split('\t')
        # items = value.split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        # if data.has_key('yasoft') and data.has_key('clid'):
        c = 1
        if c == 1:
            clid_final = data['clid']
            yasoft_final = data['yasoft']

            if clid_final in self.clids_to_check:
                yield {
                    'yasoft': yasoft_final,
                    'clid': clid_final,
                }


class SoftGuidYasoftUniqueReducer():
    def __init__(self):
        pass

    def __call__(self, key, recs):
        data = {}
        yasoft = key['yasoft']
        data[yasoft] = []

        for rec in recs:
            clid = rec['clid']
            data[yasoft].append(clid)

        for yasoft in data.keys():
            yield {
                'yasoft': yasoft,
                'clids': str(set(data[yasoft])),
                'count': str(len(data[yasoft])),
            }


class BanneridReducer():
    def __init__(self, date):
        self.date = date

    def __call__(self, key, recs):
        yasoft = key['yasoft']

        data = {}  # creat empty dict strucuture will be yasoft > ver > bnrd > count

        for rec in recs:  # reduce loop
            stat = rec['stat']  # take stat

            if stat == 'install':  # check if status is install

                ver = rec['ver']  # take version
                if not ver in data:  # check if version exists in yasoft
                    data[ver] = {}  # create dict in dict

                bnrd = rec['bnrd']  # take bnrd
                if not bnrd in data[ver]:  # check id bnrd exists in yasoft > ver
                    data[ver][bnrd] = 0  # create initial zero

                data[ver][bnrd] += 1

        for ver in data.keys():
            for bnrd in data[ver].keys():
                yield {
                    'date': self.date,
                    'yasoft': yasoft,
                    'ver': ver,
                    'bnrd': bnrd,
                    'count': data[ver][bnrd],
                }


class YaSoftVerCounterReducer():
    def __init__(self, date):
        self.date = date

    def __call__(self, key, recs):
        yasoft = key['yasoft']

        data = {}  # creat empty dict strucuture will be yasoft > ver > bnrd > count

        for rec in recs:  # reduce loop
            ver = rec['ver']  # take version
            if not ver in data:  # check if version exists in yasoft
                data[ver] = 0  # create zero if does not exist
            data[ver] += 1

        for ver in data.keys():
            yield {
                'date': self.date,
                'yasoft': yasoft,
                'ver': ver,
                'count': data[ver],
            }


def explore_new_extension(clids, name):
    # clids = ['2235099', '2235100', '2235101', '2235102']
    # clids = ['2189882', '2196600', '2187647', '2220368']

    soft_guid_yasoft_table_raw = '//statbox/statbox/soft_guid_yasoft/'
    soft_guid_yasoft_table = soft_guid_yasoft_table_raw + '2015-09-27'

    output_map_table = '//home/turkey-analytics/cansucullu/AddExtension/{0}-map'.format(name)
    output_reduce_table = '//home/turkey-analytics/cansucullu/AddExtension/{0}-reduce'.format(name)

    yt.run_map(
        SoftGuidYasoftMapper(clids),
        source_table=soft_guid_yasoft_table,
        destination_table=yt.TablePath(output_map_table, append=True),
        format=yt.DsvFormat(),
    )

    # Sort by ui
    print "Sort by yasoft"
    yt.run_sort(
        source_table=output_map_table,
        destination_table=output_map_table,
        sort_by=['yasoft']
    )

    # Reduce by ui to get activeness per ui
    print "Reduce to get unique values"
    yt.run_reduce(
        SoftGuidYasoftUniqueReducer(),
        source_table=output_map_table,
        destination_table=output_reduce_table,
        reduce_by=['yasoft'],
        format=yt.DsvFormat(),
    )


def explore_new_extension_in_export_access_log(name, date):
    clids = ['2235099', '2235100', '2235101', '2235102']
    # clids = ['2189882', '2196600', '2187647', '2220368']

    soft_guid_yasoft_table_raw = '//statbox/export-access-log/'
    soft_guid_yasoft_table = soft_guid_yasoft_table_raw + date

    output_map_table = '//home/turkey-analytics/cansucullu/AddExtension/export-access-log-{0}-{1}-map'.format(name, date)
    output_reduce_table = '//home/turkey-analytics/cansucullu/AddExtension/export-access-log-{0}-{1}-reduce'.format(name,
                                                                                                               date)

    yt.run_map(
        ExportAccessLogMapper(clids, date, 'install'),
        source_table=soft_guid_yasoft_table,
        destination_table=yt.TablePath(output_map_table, append=True),
        format=yt.DsvFormat(),
    )

    # Sort by ui
    print "Sort by yasoft"
    yt.run_sort(
        source_table=output_map_table,
        destination_table=output_map_table,
        sort_by=['yasoft']
    )

    # Reduce by ui to get activeness per ui
    print "Reduce to get unique values"
    yt.run_reduce(
        SoftGuidYasoftUniqueReducer(),
        source_table=output_map_table,
        destination_table=output_reduce_table,
        reduce_by=['yasoft'],
        format=yt.DsvFormat(),
    )


def explore_yasoft_ver_clid_in_export_access_log(condition):
    date = '2015-10-04'

    export_access_log_table_raw = '//statbox/export-access-log/'
    export_access_log_table = export_access_log_table_raw + date

    if condition:
        output_map_table = '//home/turkey-analytics/cansucullu/temp/export-access-log-yasoftverclid-yasoftcheck-{0}-map'.format(
            date)
        output_reduce_table = '//home/turkey-analytics/cansucullu/temp/export-access-log-yasoftverclid-yasoftcheck-{0}-reduce'.format(
            date)
    else:
        output_map_table = '//home/turkey-analytics/cansucullu/temp/export-access-log-yasoftverclid-{0}-map'.format(date)
        output_reduce_table = '//home/turkey-analytics/cansucullu/temp/export-access-log-yasoftverclid-{0}-reduce'.format(
            date)

    print output_map_table
    print output_reduce_table

    """
    yt.run_map(
        EALMapper(condition),
        source_table = export_access_log_table,
        destination_table=output_map_table,
        format=yt.DsvFormat(),
    )

    # Sort by ui
    print "Sort by yasoft"
    yt.run_sort(
        source_table=output_map_table,
        destination_table=output_map_table,
        sort_by=['value']
    )
    """

    # Reduce by ui to get activeness per ui
    print "Reduce to get unique values"
    yt.run_reduce(
        EALReducer(),
        source_table=output_map_table,
        destination_table=output_reduce_table,
        reduce_by=['value'],
        format=yt.DsvFormat(),
    )


class EALMapper:
    def __init__(self, condition):
        self.yasofts_to_check = ['litevbchrome_chr', 'homesearchextchrome_chr', 'searchextchrome_chr',
                                 'startextchrome_chr', 'vbch']
        self.condition = condition

    def __call__(self, rec):
        items = rec['value'].split('\t')
        data = {}
        for item in items:
            key, value = item.split('=', 1)
            data[key] = value

        if data.has_key('request') and data.has_key('cookies') and data.has_key('timestamp') and data.has_key(
                'cookies'):

            # request part
            url = data['request']
            decoded = urllib.unquote(url)
            parsed = urlparse.urlparse(decoded)
            params = urlparse.parse_qs(parsed.query)

            # cookies part
            yandexuid_regex = re.compile('(yandexuid=)([^&]*)')
            try:
                cookie_final = yandexuid_regex.search(data['cookies']).group(2)
                cookie_final = cookie_final.split(';')[0]
            except:
                cookie_final = '-'

            if cookie_final == '':
                cookie_final = '-'

            # clid part
            clid_final = "NA"
            clid_condition = params.has_key('clid') or params.has_key('clid1')
            if params.has_key('clid'):
                clid_final = params['clid'][0]
                clid_condition = True
            elif params.has_key('clid1'):
                clid_final = params['clid1'][0]
                clid_condition = True
            else:
                clid_condition = False

            # yasoft part
            if params.has_key('yasoft'):
                yasoft_final = params['yasoft'][0]
            else:
                yasoft_final = "NA"

            # version part
            if params.has_key('ver'):
                version_final = params['ver'][0]
            else:
                version_final = "NA"

            if params.has_key('stat'):
                stat_final = params['stat'][0]
            else:
                stat_final = "NA"

            # yield part
            if self.condition:
                if yasoft_final in self.yasofts_to_check:
                    yield {
                        'value': yasoft_final + '\t' + version_final + '\t' + clid_final,
                        'stat': stat_final,
                        # 'clid':clid_final,
                        # 'yasoft': yasoft_final,
                        # 'ver': version_final,
                    }
            else:
                yield {
                    'value': yasoft_final + '\t' + version_final + '\t' + clid_final,
                    'stat': stat_final,
                    # 'clid':clid_final,
                    # 'yasoft': yasoft_final,
                    # 'ver': version_final,
                }


class EALReducer:
    def __call__(self, key, recs):

        statuses = {}
        for rec in recs:
            if not rec['stat'] in statuses.keys():
                statuses[rec['stat']] = 1
            else:
                statuses[rec['stat']] += 1

        for stat in statuses.keys():
            yield {'value': key['value'], 'stat': str(stat) + '=' + str(statuses[stat])}


def get_bannerid_from_bunker():
    # url = 'http://bunker-api-dot.yandex.net/v1/cat?node=/promo-switch-ru/settings'
    url = 'http://bunker-api-dot.yandex.net/v1/cat?node=/promo-tr-test/settings'
    uh = urllib.urlopen(url)
    data = uh.read()
    js = json.loads(str(data))
    creatives = js['bannerid']['creatives']['list']
    story_map = collections.OrderedDict()
    for i in range(len(creatives)):
        key_ = str(i + 1).zfill(2)
        value_ = creatives[i]
        if value_ == 'default':
            value_ = 'brand'
        story_map[key_] = value_
    # print story_map
    return story_map


if __name__ == '__main__':
    api = RetentionCalculator()
    api.run_report(sys.argv[1])
