import requests
import json
import time
import pandas as pd


class Request:
    def __update_limit__(self):
        self.params['limit'] = str(self.limit)
    def __update_cursor__(self):
        self.params['offset'] = str(self.cursor)
    def __init__(self, token, counter_ids, mobile=False):
        self.__desktop_gate = 'https://api-metrika.yandex.ru/stat/v1/data'
        self.__mobile_gate = 'https://beta.api-appmetrika.yandex.ru/stat/v1/data'

        self.__gate = self.__mobile_gate if mobile else self.__desktop_gate
        self.params = {
            'oauth_token': token,
            'ids': counter_ids,
            'metrics': None,
            'accuracy': '1',
            'date1': '7daysAgo',
            'date2': 'yesterday',
            'dimensions': None,
            'filters': None,
            'group': 'week',
            'sort': None
        }
        self.cursor = 1
        self.limit = 1000

    def __execute__(self, info):
        if self.params['metrics'] == None:
            raise Exception("No metrics in request")
        real_params = {
            'limit': self.__update_limit__(),
            'offset': self.__update_cursor__()
        }
        for k in self.params.keys():
            value = self.params[k]
            if value != None:
                real_params[k] = value
        res = requests.get(self.__gate, params=real_params)
        response = json.loads(res.text)
        try:
            if info:
                print(res.url)
                print("Sampling: {0} ({1}%, total rows:{2})".format(response['sampled'], response['sample_share'] * 100, response['total_rows']))
            for k in response.keys():
                if k == 'data' and (getattr(self, 'data', False) != False):
                    self.data += response['data']
                    self.last_data = response['data']
                else:
                    setattr(self, k, response[k])
            self.rows = len(self.data)
            self.cursor += self.limit
        except:
            errors = response['errors']
            for error in errors:
                print('Error: {0}\nMessage: {1}'.format(error['error_type'], error['message'].encode('utf')))
            raise Exception('Bad Metrika Request')

    def __row_to_list__(self, row):
        res = []
        for d in row['dimensions']:
            res.append(d['name'])
        res += row['metrics']
        return res

    def get(self, info=False):
        self.__execute__(info)

    def get_all(self, info=False):
        while True:
            self.__execute__(info)
            if self.cursor > self.total_rows:
                break
            time.sleep(1)

    def set_dimensions(self, x):
        self.params['dimensions'] = x
        return self

    def set_metrics(self, x):
        self.params['metrics'] = x
        return self

    def set_filters(self, x):
        self.params['filters'] = x
        return self

    def set_date1(self, x):
        self.params['date1'] = x
        return self

    def set_date2(self, x):
        self.params['date2'] = x
        return self

    def pandas_data(self):
        dimensions_headers = [dim[5:] for dim in self.query['dimensions']]
        metrics_headers = [dim[5:] for dim in self.query['metrics']]
        headers = dimensions_headers + metrics_headers
        temp_data = [self.__row_to_list__(row) for row in self.data]
        pandas_data = pd.DataFrame(data=temp_data, columns=headers)
        return pandas_data


if __name__ == '__main__':
    print("Metrika API 0.2")
