import urllib
import urllib2
import requests
import logging
import time

query_mobile_audience = """
SELECT
    StartDate AS `ym:m:date`,
    uniqIf(DeviceIDHash, SessionType = 0) AS `ym:m:users`
FROM events_all
SAMPLE 10 / 10
WHERE ((StartDate = toDate('{date}')) AND (APIKey = {appid})) AND ((DeviceIDHash GLOBAL IN
(
    SELECT DeviceIDHash AS `ym:mc:device`
    FROM tracking_events_all
    SAMPLE 10 / 10
    WHERE ((StartDate >= toDate('2015-01-01')) AND (APIKey = {appid})) AND (if((EventType = 9) OR (EventType = 10), PublisherID, 18446744073709551615) = 254)
)) AND (regionToCountry(RegionID, 'ua') = 225))
GROUP BY `ym:m:date`
    WITH TOTALS
HAVING uniqIf(DeviceIDHash, SessionType = 0) > 0.
ORDER BY `ym:m:date` DESC
LIMIT 0, 10
"""


query_mobile_installs = """
SELECT
    StartDate AS `ym:m:date`,
    uniqIf(DeviceIDHash, SessionType = 0) AS `ym:m:users`
FROM events_all
SAMPLE 10 / 10
WHERE ((StartDate = toDate('{date}')) AND (APIKey = {appid})) AND ((DeviceIDHash GLOBAL IN
(
    SELECT DeviceIDHash AS `ym:mc:device`
    FROM tracking_events_all
    SAMPLE 10 / 10
    WHERE ((StartDate = toDate('{date}')) AND (APIKey = {appid})) AND (if((EventType = 9) OR (EventType = 10), PublisherID, 18446744073709551615) = 254)
)) AND ((DeviceIDHash, StartDate) GLOBAL IN
(
    SELECT
        DeviceIDHash AS `ym:m:device`,
        StartDate AS `ym:m:specialDefaultDate`
    FROM events_all
    SAMPLE 10 / 10
    WHERE ((StartDate = toDate('{date}')) AND (APIKey = {appid})) AND (EventType = 1)
)) AND (regionToCountry(RegionID, 'ua') = 225))
GROUP BY `ym:m:date`
    WITH TOTALS
HAVING uniqIf(DeviceIDHash, SessionType = 0) > 0.
ORDER BY `ym:m:date` DESC
LIMIT 0, 10
"""

def get_clickhouse_data(
                        query, connection_timeout=1500,
                        host='http://mtmega01i.yandex.ru:8123/'
):

    params = {'query': query, 'user': 'chikachoff', 'password': 'DS0DkMl7'}
    query_get = urllib.urlencode(params)
    url = host + '?' + query_get
    # print url
    req = urllib2.Request(url)
    res = urllib2.urlopen(req, timeout=connection_timeout)
    result = res.read()
    return result


def post_clickhouse_data(
        query, connection_timeout=1500,
        host='http://mtmega.yandex.ru:8123/'
):
    params = {'query': query, 'user': 'chikachoff', 'password': 'DS0DkMl7'}
    query_get = urllib.urlencode(params)
    url = host + '?' + query_get
    req = urllib2.Request(url)
    res = urllib2.urlopen(req, timeout=connection_timeout, data='')
    result = res.read()
    return result


def upload(
    table, content, connection_timeout=2000,
    host='http://mtmega01i.yandex.ru:8123/'
):
    delete_query = 'DROP TABLE ' + table + ';'
    create_query = 'CREATE TABLE ' + table + '(yauid String) ENGINE = Log'
    post_clickhouse_data(delete_query)
    post_clickhouse_data(create_query)
    query_dict = {
             'user': 'chikachoff',
             'password': 'DS0DkMl7',
             'query': 'INSERT INTO ' + table + ' FORMAT TabSeparated'
    }
    query_get = urllib.urlencode(query_dict)
    url = host + '?' + query_get
    r = requests.post(url, data=content, timeout=connection_timeout)
    result = r.text
    if 'Exception' in result:
        logging.warning(host + ' \n ' + result)
    else:
        return result


def findSearches(uids, start, end):
    content = '\n'.join(uids) + '\n'
    table = 'yandex_uids_table'
    upload(table=table, content=content)
# Calc search hits done by users having given yandexuids
    user_query= "SELECT \
        count() \
        FROM hits_all \
        WHERE (EventDate >= toDate('{start}')) AND (EventDate <= toDate('{end}')) \
        AND (IsRobot = 0) \
        AND (CounterID IN (731962, 21689008, 22555771, 6414910, 33250276, 815578, \
                           22709875, 22709869, 22709881, 9927988, 21467089, 11803342, \
                           22555765, 30835491, 25201802)) \
        AND (toString(UserID) GLOBAL IN (SELECT * from {table})) \
        AND NOT DontCountHits".format(start=start, end=end, table=table)
###
    result = post_clickhouse_data(user_query)
    a = result.split('\n')
    return a[0]

#print findSearches(['999999971447057422', 'y13872031433766438'], '{date}', '{date}')


def get_mobileapp_portal_audience_ru(appid, date):
    result = None
    while not result:
        try:
            result = post_clickhouse_data(query_mobile_audience.format(appid=appid, date=date))
        except urllib2.HTTPError:
            time.sleep(1)
    result = result.split('\n')
    try:
        date = result[0].split()[0]
        count = result[0].split()[1]
    except IndexError:
        count = 0
    return count

def get_mobileapp_portal_installs_ru(appid, date):
    result = None
    while not result:
        try:
            result = post_clickhouse_data(query_mobile_installs.format(appid=appid, date=date))
        except urllib2.HTTPError:
            time.sleep(1)
    result = result.split('\n')
    try:
        date = result[0].split()[0]
        count = result[0].split()[1]
    except IndexError:
        count = 0
    return count

# print get_mobileapp_portal_installs_ru('42989', '2016-02-16')
#print get_mobileapp_portal_audience_ru('42989', '2016-02-16')
