#!/usr/bin/env python2.7
#!coding: utf-8
import sys
import json
import requests
from datetime import datetime, timedelta
from helpers import update_stat


report_name = 'Yandex_RU/Special/Metrics/Switch/portalmobiledistributionpromolib'


apps = {
    '10321': 'androidSearch',
    '42989': 'iosSearch',
    # '5746': 'searchwinphone',
    '106400': 'androidBro',
    '19531': 'iphoneBro',
    '19534': 'ipadBro'
}

regions = {
    'ru': '225'
}

publishers = {
    'portal': '254',
    'promolib': '44'
}


def daterange(start, end):
    start = datetime.strptime(start, '%Y-%m-%d')
    end = datetime.strptime(end, '%Y-%m-%d')
    current = start
    while current <= end:
        yield current.strftime('%Y-%m-%d')
        current += timedelta(days=1)


def update_statface_report(rows):
    url = 'https://stat.yandex-team.ru/_api/report/data'
    headers = {
        'StatRobotUser': 'robot_aydogank',
        'StatRobotPassword': 'Aish3ohy9u'
    }
    values = {
        'name': report_name,
        'scale': 'd',
        'data': {'values': rows}
    }
    r = requests.post(url, data=values, headers=headers, timeout=5)
    return r


def get_installs(start, end, domain, app_id, publisher, region):
    url = 'https://beta.api-appmetrika.yandex.ru/stat/v1/data/bytime'
    data = {
        'metrics': ['ym:m:users'],
        # 'dimensions': ['ym:mc:publisher', 'ym:mc:campaign',
        #                'ym:mc:urlParamKey', 'ym:mc:urlParamValue'],
        'filters': "(ym:m:regionCountry=={region}) AND exists ym:m:device,\
                     ym:m:specialDefaultDate with \
                     (ym:m:eventType=='EVENT_INIT') AND exists ym:mc:device \
                     with (ym:mc:publisher=={publisher})".format(
                        region=region,
                        publisher=publisher
                     ),
        'group': 'day',
        'date1': start,
        'date2': end,
        'oauth_token': 'AQAAAAAME5e9AAL5laEi5tvWRUberBtISAeHGiM',
        'pretty': '1',
        'ids': app_id,
        'request_domain': domain,
    }
    r = requests.get(url, params=data)
    try:
        out = json.loads(r.content)['data'][0]['metrics'][0][0]
        return out
    except:
        # if token expires, go to https://oauth.yandex.com/authorize?response_type=token&client_id=ccf059d24609487aaa356a4ba099e60e
        # see https://tech.yandex.com/oauth/doc/dg/tasks/get-oauth-token-docpage/
        # client_id = ccf059d24609487aaa356a4ba099e60e
        #out = json.loads(r.content)
        print r.content
        # print 0


def metrics_daily(day):
    result = {'fielddate': day}
    for app in apps:
        for publisher in publishers:
            metric = ''.join([apps[app], '_{}_install'.format(publisher)])
            installs = get_installs(start=day, end=day,
                                    domain='ru', app_id=app,
                                    publisher=publishers[publisher],
                                    region=regions['ru'])
            result[metric] = installs

    return result


def main():
    today = datetime.today()
    yesterday = (today - timedelta(days=1)).strftime('%Y-%m-%d')
    try:
        datefrom = sys.argv[1]
    except:
        datefrom = yesterday
    try:
        dateto = sys.argv[2]
    except:
        dateto = yesterday

    for day in daterange(datefrom, dateto):
        print metrics_daily(day)
        update_stat([metrics_daily(day)], report_name)
        print 'Report {} updated date {}'.format(report_name, day)

if __name__ == '__main__':
    main()
    # print get_installs(start='2016-04-05', end='2016-04-12', domain='ru',
    #                    app_id='42989', publisher='254', region='225')

