import json
import urllib
import urllib2
import sys
import time

from datetime import datetime, timedelta
from ClickhouseConnector import get_mobileapp_portal_audience_ru
from ClickhouseConnector import get_mobileapp_portal_installs_ru
from helpers import update_stat, daterange

report_name = 'Yandex_RU/Special/Metrics/Switch/PortalMobileDistribution'

app_ids = {
    '10321': 'searchappandroid',
    '42989': 'searchappios',
    # '5746': 'searchwinphone',
    '106400': 'yabroandroid',
    '19531': 'yabroiphone',
    '19534': 'yabroipad'
}


def metrics_daily(day):
    result = {'fielddate': day}
    for app in app_ids:
        metric = ''.join([app_ids[app], 'installs'])
        installs = get_mobileapp_portal_installs_ru(app, day)
        result[metric] = installs

        metric = ''.join([app_ids[app], 'audience'])
        audience = get_mobileapp_portal_audience_ru(app, day)
        result[metric] = audience
    return result


def main():
    today = datetime.today()
    yesterday = (today - timedelta(days=1)).strftime('%Y-%m-%d')
    try:
        datefrom = sys.argv[1]
    except:
        datefrom = yesterday
    try:
        dateto = sys.argv[2]
    except:
        dateto = yesterday

    for day in daterange(datefrom, dateto):
        print metrics_daily(day)
        update_stat([metrics_daily(day)], report_name)
        print 'Report {} updated date {}'.format(report_name, day)

if __name__ == '__main__':
    main()
