#!coding: utf-8
import json
import io

INFILE = 'promolib.json'
OUTFILE = 'promolib_product_fixed.json'

with open(INFILE) as fp:
    indata = json.load(fp)

cnt = 0

for num, elem in enumerate(indata):
    elem_all_text = json.dumps(elem, indent=2, encoding='utf8',
                               ensure_ascii=False)
    # taxi
    if any([
        'yandextaxi://' in elem_all_text,
        'ru.yandex.taxi' in elem_all_text,
    ]):
        indata[num]['__product'] = 'taxi'
    elif any([
        'ru.yandex.yandexmaps' in elem_all_text,
        'yandexmaps://' in elem_all_text
    ]):
        indata[num]['__product'] = 'maps'

    elif any([
        'ru.yandex.searchplugin' in elem_all_text,
        'yandexsearch://' in elem_all_text
    ]):
        indata[num]['__product'] = 'search'

    elif any([
        'ru.yandex.yandexnavi' in elem_all_text,
        'yandexnavi://' in elem_all_text
    ]):
        indata[num]['__product'] = 'navi'

    elif any([
        'com.yandex.launcher' in elem_all_text,
    ]):
        indata[num]['__product'] = 'launcher'

    elif any([
        'ru.yandex.market' in elem_all_text,
        'yandexmarket://' in elem_all_text,
        'market.yandex' in elem_all_text,
    ]):
        indata[num]['__product'] = 'market'

    elif any([
        'ru.yandex.yandexbus' in elem_all_text,
        'yandextransport://' in elem_all_text,
    ]):
        indata[num]['__product'] = 'transport'

    elif any([
        'ru.yandex.metro' in elem_all_text,
        'yandexmetro://' in elem_all_text,
        'Metro' in elem_all_text,
    ]):
        indata[num]['__product'] = 'metro'

    elif any([
        'yandexradio://' in elem_all_text,
        'ru.yandex.radio' in elem_all_text,
    ]):
        indata[num]['__product'] = 'radio'

    elif any([
        'ru.yandex.auto' in elem_all_text,
        'autoru' in elem_all_text,
    ]):
        indata[num]['__product'] = 'autoru'

    elif any([
        'ru.yandex.toloka.hybrid' in elem_all_text,
    ]):
        indata[num]['__product'] = 'toloka'

    elif any([
        'ru.yandex.mobile.avia' in elem_all_text,
    ]):
        indata[num]['__product'] = 'avia'

    elif any([
        'yandexmusic://' in elem_all_text,
        'ru.yandex.mobile.music' in elem_all_text,
    ]):
        indata[num]['__product'] = 'music'

    elif any([
        u'Почта' in elem_all_text,
    ]):
        indata[num]['__product'] = 'mail'

    elif any([
        u'https://itunes.apple.com/ru/app/edadil-akcii-i-skidki-na-produkty/id700569948?mt=8' in elem_all_text,
        u'com.edadeal.android' in elem_all_text,
    ]):
        indata[num]['__product'] = 'edadil'

    elif any([
        u'kinopoisk' in elem_all_text,
    ]):
        indata[num]['__product'] = 'kinopoisk'

    elif any([
        u'yandexbrowser-open-url://' in elem_all_text,
        u'com.yandex.browser' in elem_all_text,
        u'yandexbrowser://' in elem_all_text,
    ]):
        indata[num]['__product'] = 'browser'

    elif any([
        u'Клавиатур' in elem_all_text,
    ]):
        indata[num]['__product'] = 'keyboard'

    elif any([
        u'ru.yandex.weatherplugin' in elem_all_text,
        u'yandexweather://' in elem_all_text,
    ]):
        indata[num]['__product'] = 'pogoda'

    elif any([
        u'https://ru.research.net/' in elem_all_text,
    ]):
        indata[num]['__product'] = 'research'

# check
for num, elem in enumerate(indata):
    if elem['__product'] == 'product':
        print json.dumps(elem, indent=2, encoding='utf8', ensure_ascii=False)
        indata.pop(num)

with io.open(OUTFILE, 'w', encoding='utf8') as fp:
    data = json.dumps(indata, indent=4, encoding='utf8-', ensure_ascii=False)
    fp.write(data)
