#!/usr/bin/env python

import smtplib
import datetime
import os
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.mime.image import MIMEImage


__author__ = 'chikachoff'
# Test config
# user = 'chikachoff'
# password = ''
# to_addr = 'chikachoff@yandex-team.ru'

# Config:
user = os.environ['USER']
password = os.environ['PASS']
to_addr = 'switch-ru@yandex-team.ru'
from_addr = '{login}@yandex-team.ru'.format(login=user)
cc_addr = 'chikachoff@yandex-team.ru'
html_path = os.path.join(os.path.dirname(os.path.realpath(__file__)),
                         'switch_daily.html')
with open(html_path, 'r') as f:
    html = f.read()
current_directory = os.path.dirname(os.path.abspath(__file__))
date_today = datetime.date.today().strftime('%d.%m.%Y')

# Create message container
msg = MIMEMultipart('related')
msg['Subject'] = 'Switch.RU Daily: {date}'.format(date=date_today)
msg['From'] = from_addr
msg['To'] = to_addr
msg["Cc"] = cc_addr
msg_text = MIMEText(html, 'html')
msg.attach(msg_text)
print '/'.join([current_directory, 'conversions.png'])

with open('/'.join([current_directory, 'conversions.png']), 'rb') as fp:
    msg_image_conversions = MIMEImage(fp.read(), _subtype='png')

with open('/'.join([current_directory, 'cpa.png']), 'rb') as fp:
    msg_image_cpa = MIMEImage(fp.read(), _subtype='png')
msg_image_conversions.add_header('Content-ID', '<image_conversions>')
msg_image_cpa.add_header('Content-ID', '<image_cpa>')
msg.attach(msg_image_conversions)
msg.attach(msg_image_cpa)


server = smtplib.SMTP_SSL('smtp.yandex-team.ru', 465)
# server.set_debuglevel(1)
server.ehlo()

server.login(user=from_addr, password=password)

server.sendmail(from_addr, to_addr, msg.as_string())
print 'Message to {} sent at: {}'.format(to_addr, datetime.datetime.now())

server.quit()
