#!/usr/bin/env/ python2.7
# -*- coding: utf-8 -*-
import json
import requests
import urlparse
from collections import defaultdict

measures = ['CampaignName',
            'Clicks',
            'Impressions',
            'Cost',
            'CreativeFinalUrls']
cost_divisor = 1000000.0


def get_new_access_token():
    url = 'https://www.googleapis.com/oauth2/v3/token'
    data = {'client_id': '375274511279-v11ercttf7181299nennk8gv69st2val.apps.googleusercontent.com',
            'client_secret': 'eTJeEeYx-8dDGR9Mqcw3u3ND',
            'refresh_token': 'YOUR_REFRESH_TOKEN_HERE',
            'grant_type': 'refresh_token'}
    r = requests.post(url, data=data)
    access_token = json.loads(r.text)['access_token']
    return access_token


def get_adwords_data(start_date, end_date):
    host = 'https://adwords.google.com/api/adwords/reportdownload/v201506'
    access_token = get_new_access_token()
    header = {'Authorization': 'Bearer %s' % access_token,
              'Content-Type': 'application/x-www-form-urlencoded',
              'developerToken': '0Ke5zfuIvVfCewcaiYolCg',
              'clientCustomerId': '189-149-9566'}

    dates = {'start': start_date.replace('-', ''), 'end': end_date.replace('-', '')}
    fields = '<fields>{}</fields>\n' * len(measures)
    __rdxml = '''<reportDefinition xmlns="https://adwords.google.com/api/adwords/cm/v201506">
<selector>\n''' + \
              fields.format(*measures) + \
              '''
   <predicates>
     <field>CampaignStatus</field>
     <operator>EQUALS</operator>
     <values>ENABLED</values>
   </predicates>
   <predicates>
     <field>Status</field>
     <operator>EQUALS</operator>
     <values>ENABLED</values>
   </predicates>
   <dateRange>
     <min>{start}</min>
     <max>{end}</max>
   </dateRange>
</selector>
<reportName>Ad Performance Report</reportName>
<reportType>AD_PERFORMANCE_REPORT</reportType>
 <dateRangeType>CUSTOM_DATE</dateRangeType>
 <downloadFormat>TSV</downloadFormat>
</reportDefinition>'''.format(**dates)
    r = requests.post(host, headers=header, data={'__rdxml': __rdxml})
    response = r.content
    return response


def parse_adwords_data(start, end):
    switch_adv_groups = []
    adwords_data = get_adwords_data(start, end)
    for line in adwords_data.split('\n')[2:-1]:
        adv_group = line.split('\t')
        adv_group = dict(zip(measures, adv_group))
        url = adv_group.get('CreativeFinalUrls', None)
        # Get URL params as {key:value}:
        params = dict(urlparse.parse_qs(urlparse.urlsplit(url).query))
        # RU adwords account has not only switch campaigns, so i check if campaign name has 'switch' substring:
        if 'switch' in adv_group['CampaignName'].lower():
            tmp = {'Cost': float(adv_group.get('Cost', None)) / cost_divisor,
                   'Impressions': int(adv_group.get('Impressions', None)),
                   'Clicks': int(adv_group.get('Clicks', None)),
                   'utm_source': params.get('utm_source', None),
                   'utm_medium': params.get('utm_medium', None),
                   'utm_campaign': params.get('utm_campaign', None),
                   'CampaignName': adv_group.get('CampaignName', None)}
            switch_adv_groups.append(tmp)
    return switch_adv_groups


def aggregate_by_campaign(start, end):
    result = defaultdict(dict)
    switch_adv_groups = parse_adwords_data(start, end)
    for ad_group in switch_adv_groups:
        try:
            key = u'{}\t{}\t{}'.format(ad_group['utm_source'][0].lower(),
                                       ad_group['utm_medium'][0].lower(),
                                       ad_group['utm_campaign'][0].lower())
            if ad_group['Impressions'] > 0:
                if key not in result:
                    result[key] = defaultdict(float)
                result[key]['campaign_name'] = ad_group['CampaignName']
                result[key]['impressions'] += ad_group['Impressions']
                result[key]['clicks'] += ad_group['Clicks']
                result[key]['cost'] += ad_group['Cost']
        except TypeError:
            pass
#            if ad_group['Cost'] != 0:
#                print 'No UTM for Adwords campaign:', json.dumps(ad_group, encoding='utf8',
#                                                                 ensure_ascii=False, sort_keys=True, indent=2)
    return result

# print json.dumps(aggregate_by_campaign('20150923', '20150923'), encoding='utf8',
#                  ensure_ascii=False, sort_keys=True, indent=2)

