#!/usr/bin/env python2.7
import json
import urllib2
import urlparse
from collections import defaultdict


def get_campaigns_for_account(login, token, url):
    # For documentation visit https://tech.yandex.ru/direct/doc/dg-v4/reference/GetCampaignsList-docpage/
    param = [login]
    data = {
        'token': token,
        'method': 'GetCampaignsList',
        'param': param}
    # Convert data to JSON and encode it to UTF-8
    jdata = json.dumps(data, ensure_ascii=False).encode('utf8')
    # Request api
    response = urllib2.urlopen(url, data=jdata)
    # Show the answer for request
    parsed = json.loads(response.read())
    #print json.dumps(parsed, indent=2, sort_keys=True, ensure_ascii=False)
    # Returns following structure:
    """
    {"data": [{
      "AgencyName": null,
      "CampaignID": 13830136,
      "Clicks": 23288,
      "IsActive": "Yes",
      "Login": "switch-ru",
      "ManagerName": null,
      "Name": "Switch RU RSYA Fines",
      "Rest": 1010.3,
      "Shows": 1125661,
      "StartDate": "2015-08-10",
      "Status": "Campaign is in progress",
      "StatusActivating": "Yes",
      "StatusArchive": "No",
      "StatusModerate": "Yes",
      "StatusShow": "Yes",
      "Sum": 3219.33,
      "SumAvailableForTransfer": 998.5}
    """
    campaign_ids = {campaign['CampaignID']: campaign['Name'] for campaign in parsed['data']}
    return campaign_ids


def get_campaigns_data(login, token, url, campaignids, start, end):
    result = {}
    # Returns Impressions, Clicks, Cost for a CampaignID for a given period
    # For documentation visit https://tech.yandex.ru/direct/doc/dg-v4/reference/GetSummaryStat-docpage/
    param = {'login': login,
             'CampaignIDS': campaignids,
             'StartDate': start,
             'EndDate': end,
             'Currency': 'RUB'}
    data = {'token': token,
            'method': 'GetSummaryStat',
            'locale': 'ru',
            'param': param}
    jdata = json.dumps(data, ensure_ascii=False).encode('utf8')
    response = urllib2.urlopen(url, data=jdata)
    response = json.loads(response.read())
    try:
        response = response['data']
        for campaign in response:
            result[campaign.get('CampaignID', 0)] = [campaign.get('ShowsContext', 0),
                                                     campaign.get('ClicksContext', 0),
                                                     campaign.get('SumContext', 0),
                                                     campaign.get('ShowsSearch', 0),
                                                     campaign.get('ClicksSearch', 0),
                                                     campaign.get('SumSearch', 0)]
    except IndexError:
        result[campaign.get('CampaignID', 0)] = []
    except KeyError:
        return response
    # To see API response uncomment line below
    # print json.dumps(parsed, indent=2, sort_keys=True, ensure_ascii=False)
    # Returns following structure:
    '''
    {"data": [{
      "CampaignID": 13830136,
      "ClicksContext": 2142, /* Clicks in RSYA(GDN analog by Yandex) */
      "ClicksSearch": 0, /* Clicks in Search */
      "GoalConversionContext": "44.98",
      "GoalConversionSearch": null,
      "GoalCostContext": "8.86",
      "GoalCostSearch": null,
      "SessionDepthContext": "1.25",
      "SessionDepthSearch": null,
      "ShowsContext": 104123, /* Shows in RSYA */
      "ShowsSearch": 0, /* Shows in Search */
      "StatDate": "2015-08-20",
      "SumContext": 6159.84, /* Spend in RSYA */
      "SumSearch": 0}]}
    '''
    return result


def get_utm_for_campaign_banners(login, token, url, campaignid):
    # Gets URL for each banner in the campaignid. Take UTM-data from it
    param = {'login': login,
             'CampaignIDS': [campaignid],
             'FieldsNames': ['AdGroupName', 'Title', 'Href'],
             'GetPhrases': 'No'}
    data = {'token': token,
            'method': 'GetBanners',
            'param': param}
    jdata = json.dumps(data, ensure_ascii=False).encode('utf8')
    response = urllib2.urlopen(url, data=jdata)
    parsed = json.loads(response.read())
    unique_utms = set()
    urls = [banner['Href'] for banner in parsed['data']]
    for url in urls:
        params = dict(urlparse.parse_qs(urlparse.urlsplit(url).query))
        utm_source = params.get('utm_source', None)[0]
        utm_medium = params.get('utm_medium', None)[0]
        utm_campaign = params.get('utm_campaign', None)[0]
        utms_joined = u'{}\t{}\t{}'.format(utm_source.lower(),
                                           utm_medium.lower(),
                                           utm_campaign.lower())
        unique_utms.add(utms_joined)
    try:
        return {campaignid: list(unique_utms)[0]}
    except IndexError:
        return {campaignid: []}


def get_rsya_data(start, end):
    """
    For documentation visit https://tech.yandex.ru/direct/doc/dg-v4/examples/python-json-docpage/
    New API access requests are moderated.
    Use contacts at https://beta.wiki.yandex-team.ru/direkt/api/ to speed up moderation.
    """
    result = defaultdict(dict)
    # Adress for sending JSON requests
    url = 'https://api.direct.yandex.ru/live/v4/json/'
    # OAuth
    token = 'your_token_here'
    # Direct login
    login = 'switch-ru'
    campaignids = get_campaigns_for_account(login=login, token=token, url=url)
    campaigns_data = get_campaigns_data(login=login, token=token, url=url, campaignids=campaignids.keys(), start=start, end=end)
#    print 'campaigns data:', campaigns_data['error_detail']
    for campaignid in campaignids.keys():
        utms = get_utm_for_campaign_banners(login=login, token=token, url=url, campaignid=campaignid)
        try:
            key = utms[campaignid]
            if campaigns_data[campaignid][0] > 0:  #  [campaignid][0] == ShowsContext (means this campaign is RSYA)
                impressions, clicks, cost = campaigns_data[campaignid][:3]
            if impressions > 0:
                if key not in result:
                    result[key] = defaultdict(float)
                result[key]['campaign_name'] = campaignids[campaignid]
                result[key]['impressions'] += impressions
                result[key]['clicks'] += clicks
                result[key]['cost'] += cost
        except IndexError:
            pass
#            print 'No UTM for Direct campaign:', campaignids[campaignid]
        except KeyError:
            pass
#            print 'No shows, clicks, sum for campaignid:', campaignid
#            print 'Look at direct.py get_rsya_data()'
    return result

#print json.dumps(get_rsya_data('20151124', '20151124'), encoding='utf8',
#                 ensure_ascii=False, sort_keys=True, indent=2)

