#!/usr/bin/env python2.7
import datetime
import json


def json_print(data):
    readeable_output = json.dumps(data, encoding='utf8',
                                  ensure_ascii=False, sort_keys=True, indent=2)
    print readeable_output


def days_range(start, stop):
    start = datetime.datetime.strptime(start, '%Y%m%d')
    stop = datetime.datetime.strptime(stop, '%Y%m%d')
    days_count = int((stop - start).days) + 1
    day_list = [(stop - datetime.timedelta(days=x)).strftime('%Y%m%d') for x in xrange(days_count)]
    return day_list[::-1]

