#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
'''
Run this code from switch directory (2 levels up)
'''
import datetime
import time
import logging
import os
import sys
import json
campaigns_folder = '/'.join([os.getcwd(), 'reports/campaigns'])
sys.path.insert(0, campaigns_folder)
import adwords
import direct
import gos
import updateGraph
from metrica import get_metrica_conversions, get_metrica_clicks_chrome_share
from collections import Counter

timestamp = str(int(time.time()))
log_file = '/'.join([os.getcwd(), 'reports/logs/campaigns', timestamp + '.html'])
logging.basicConfig(filename=log_file, level=logging.DEBUG, format='%(levelname)s ::: %(asctime)s : %(filename)s : %(message)s')


def combine(start, end):
    combined = {}
    adwords_data = adwords.aggregate_by_campaign(start, end)
    direct_data = direct.get_rsya_data(start, end)
    metrica_data = get_metrica_conversions(start, end)
    chrome_share = get_metrica_clicks_chrome_share(start, end)
    for key in adwords_data:
        combined[key] = adwords_data[key]
        if key in metrica_data:
            combined[key]['conversions'] = metrica_data[key]
        else:
            combined[key]['conversions'] = 0
        if key in chrome_share:
            combined[key]['chromeshare'] = chrome_share[key]
    for key in direct_data:
        combined[key] = direct_data[key]
        if key in metrica_data:
            combined[key]['conversions'] = metrica_data[key]
        else:
            combined[key]['conversions'] = 0
        if key in chrome_share:
            combined[key]['chromeshare'] = chrome_share[key]
    # Fixme for this very campaigns:
    if 'google\tsearch\tbrand_gdn' in combined:
        if 'google\tgdn\tbrand_gdn' in combined:
            a = Counter(combined['google\tgdn\tbrand_gdn'])
            b = Counter(combined['google\tsearch\tbrand_gdn'])
            if 'chromeshare' not in a:
                a['chromeshare'] = [0, 0]
            if 'chromeshare' not in b:
                b['chromeshare'] = [0, 0]
            combined['google\tgdn\tbrand_gdn'] = dict(a + b)
            chrsh = combined['google\tgdn\tbrand_gdn']['chromeshare']
            chrsh = [chrsh[0]+chrsh[2], chrsh[1]+chrsh[3]]
            combined['google\tgdn\tbrand_gdn']['chromeshare'] = chrsh

            combined.pop('google\tsearch\tbrand_gdn')
        else:
            combined['google\tgdn\tbrand_gdn'] = combined.pop('google\tsearch\tbrand_gdn')
    if 'google\tsearch\tbrand_rem_gdn' in combined:
        if 'google\tgdn\tbrand_rem_gdn' in combined:
            a = Counter(combined['google\tgdn\tbrand_rem_gdn'])
            if 'chromeshare' not in a:
                a['chromeshare'] = [0, 0]
            b = Counter(combined['google\tsearch\tbrand_rem_gdn'])
            if 'chromeshare' not in b:
                b['chromeshare'] = [0, 0]
            combined['google\tgdn\tbrand_rem_gdn'] = dict(a + b)
            chrsh = combined['google\tgdn\tbrand_rem_gdn']['chromeshare']
            chrsh = [chrsh[0]+chrsh[2], chrsh[1]+chrsh[3]]
            combined['google\tgdn\tbrand_rem_gdn']['chromeshare'] = chrsh

            combined.pop('google\tsearch\tbrand_rem_gdn')
        else:
            combined['google\tgdn\tbrand_rem_gdn'] = combined.pop('google\tsearch\tbrand_rem_gdn')
    for campaign in metrica_data:
        if campaign not in combined and metrica_data[campaign] > 0:
            if campaign not in ['google\tsearch\tbrand_rem_gdn', 'google\tsearch\tbrand_gdn']:
            #    print u'Missing campaign from metrica: {} \t Conversions: {}'.format(campaign, metrica_data[campaign])
                combined[campaign] = {}
                combined[campaign]['conversions'] = metrica_data[campaign]
                combined[campaign]['clicks'] = 0
                combined[campaign]['impressions'] = 0
                combined[campaign]['cost'] = 0
                combined[campaign]['chromeshare'] = 0
    # /fixme mode off
    return combined

today_date = datetime.date.today()
yesterday_date = today_date - datetime.timedelta(1)
yesterday = yesterday_date.strftime('%Y-%m-%d')
today = today_date.strftime('%Y-%m-%d')
old_data = False
if old_data:
    for day in gos.days_range('20151004', '20151005'):
        print 'Day', day
        data = combine(day, day)
        updateGraph.update_all(day, data)
else:
    if time.localtime().tm_hour < 1:
        logging.info('Starting RU-Campaigns report whole day yesterday ({})'.format(yesterday))
        logging.info('Combining data')
        try:
            data = combine(yesterday, yesterday)
            logging.info('Combining data: success\nUpdating stat...')
        except:
            logging.critical('Combining data failed. Check main.py combine()')
        try:
            updateGraph.update_all(yesterday, data)
            logging.info('Updating stat: success')
        except:
            logging.critical('Updating stat failed')
        log_metrics = json.dumps(data, sort_keys=True, indent=2)
        logging.info(log_metrics)
    else:
        logging.info('Starting RU-Campaigns report update today.\nCombining data')
        try:
            data = combine(today, today)
            logging.info('Combining data: success\nUpdating stat...')
        except:
            logging.critical('Combining data failed. Check main.py combine()')
        try:
            updateGraph.update_all(today, data)
            logging.info('Updating stat: success')
        except:
            logging.critical('Updating stat failed')
        log_metrics = json.dumps(data, sort_keys=True, indent=2)
        logging.info(log_metrics)

