#!/usr/bin/env/ python
# -*- coding: utf-8 -*-

import requests
import json
from collections import defaultdict

__author__ = 'chikachoff'


def get_metrica_conversions(start, end):
    campaign_conversions = defaultdict(int)
    url = 'https://beta.api-metrika.yandex.ru/stat/v1/data'
    data = {'dimensions': ['ym:s:UTMSource', 'ym:s:UTMMedium', 'ym:s:UTMCampaign'],
            'metrics': ['ym:s:goal11840621reaches'],
            'date1': start,
            'date2': end,
            'oauth_token': 'a55d84a6481d410c95341ceb45cd172f',
            'pretty': '1',
            'ids': '31119731'}
    r = requests.get(url, params=data)
    out = r.content
    for item in json.loads(out)['data']:
        try:
            source = item['dimensions'][0]['name'].lower()
            medium = item['dimensions'][1]['name'].lower()
            campaign = item['dimensions'][2]['name'].lower()
            installs = item['metrics'][0]
            campaign_conversions[u'{}\t{}\t{}'.format(source, medium, campaign)] += int(installs)
        except AttributeError:
            print 'Empty UTM-label', item
    return campaign_conversions

# readeable_output = json.dumps(get_metrica_conversions('20151001', '20151001'), encoding='utf8',
#                               ensure_ascii=False, sort_keys=True, indent=2)
# print readeable_output


def get_metrica_clicks_chrome_share(start, end):
    url = 'https://beta.api-metrika.yandex.ru/stat/v1/data'
    data = {'dimensions': ['ym:s:UTMSource', 'ym:s:UTMMedium', 'ym:s:UTMCampaign', 'ym:s:browser'],
            'metrics': ['ym:s:visits'],
            'date1': start,
            'date2': end,
            'oauth_token': 'a55d84a6481d410c95341ceb45cd172f',
            'pretty': '1',
            'ids': '31119731'}
    r = requests.get(url, params=data)
    out = r.content
    campaign_clicks = defaultdict(list)
    for item in json.loads(out)['data']:
        utm_source = item['dimensions'][0]['name']
        utm_medium = item['dimensions'][1]['name']
        utm_campaign = item['dimensions'][2]['name']
        browser = item['dimensions'][3]['name']
        clicks = item['metrics'][0]
        if utm_source and utm_medium and utm_campaign:
            utm_source = utm_source.lower()
            utm_medium = utm_medium.lower()
            utm_campaign = utm_campaign.lower()
            key = u'{}\t{}\t{}'.format(utm_source, utm_medium, utm_campaign)
            if key in campaign_clicks:
                campaign_clicks[key]['total'] += clicks
                if browser == 'Google Chrome':
                    campaign_clicks[key]['chrome'] += clicks
            else:
                campaign_clicks[key] = defaultdict(float)
                campaign_clicks[key]['total'] += clicks
                if browser == 'Google Chrome':
                    campaign_clicks[key]['chrome'] += clicks
        else:
            print 'Campaign without UTM:', item

    chrome_share = {campaign: [campaign_clicks[campaign]['chrome'], campaign_clicks[campaign]['total']]
                    for campaign in campaign_clicks}
    return chrome_share

# print json.dumps(get_metrica_clicks_chrome_share('20150922', '20150922'), encoding='utf8',
#                  ensure_ascii=False, sort_keys=True, indent=2)


def get_metrica_placement(start, end):
    url = 'https://beta.api-metrika.yandex.ru/stat/v1/data'
    data = {'dimensions': ['ym:s:UTMSource', 'ym:s:UTMMedium', 'ym:s:UTMCampaign', 'ym:s:UTMContent'],
            'metrics': ['ym:s:visits', 'ym:s:goal11840621reaches'],
            'date1': start,
            'date2': end,
            'oauth_token': 'a55d84a6481d410c95341ceb45cd172f',
            'pretty': '1',
            'ids': '31119731'}
    r = requests.get(url, params=data)
    out = r.content
    placement_visits_conversions = defaultdict(list)
    for item in json.loads(out)['data']:
        utm_source = item['dimensions'][0]['name']
        utm_medium = item['dimensions'][1]['name']
        utm_campaign = item['dimensions'][2]['name']
        placement = item['dimensions'][3]['name']
        visits = item['metrics'][0]
        conversions = item['metrics'][1]
        utm_source = utm_source.lower()
        utm_medium = utm_medium.lower()
        utm_campaign = utm_campaign.lower()
        if utm_medium in ['gdn', 'rsya']:
            key = u'{}\t{}\t{}\t{}'.format(utm_source, utm_medium, utm_campaign, placement)
            if key in placement_visits_conversions:
                placement_visits_conversions[key]['visits'] += visits
                placement_visits_conversions[key]['conversions'] += conversions
            else:
                placement_visits_conversions[key] = defaultdict(int)
                placement_visits_conversions[key]['visits'] = visits
                placement_visits_conversions[key]['conversions'] = conversions
    return placement_visits_conversions
# get_metrica_placement('20150928', '20150928')
# print json.dumps(get_metrica_placement('20150928', '20150928'), encoding='utf8',
#                  ensure_ascii=False, sort_keys=True, indent=2)
