import requests
import json

app_ids_names = {
    '10321': 'searchappandroid',
    '42989': 'searchappios',
    # '5746': 'search_winphone',
    '106400': 'yabroandroid',
    '19531': 'yabroiphone',
    '19534': 'yabroipad'
}

filter_Russia_installs_only = "(ym:m:regionCountry==225) AND \
                        exists ym:m:device,ym:m:specialDefaultDate with \
                        (ym:m:eventType=='EVENT_INIT')"

filter_Russia_audience = "(ym:m:regionCountry==225)"


def request_mobile_appmetrica(
                              start,
                              end,
                              app_id = '',
                              filter='',
                              metrics='ym:m:users',
                              dimensions='ym:m:date'
                              ):
    url = 'https://beta.api-appmetrika.yandex.ru/stat/v1/data'

    data = {
        'pretty': '1',
        'id': app_id,
        'date1': start,
        'date2': end,
        'metrics': metrics,
        'dimensions': dimensions,
        'oauth_token': 'ac3cd96a3cc64ece824c728bbfc2c623',
        'request_domain': 'com',
        'filters': filter
    }
    r = requests.get(url, params=data)
    out = r.content
    try:
        return json.loads(out)['data'][0]['metrics'][0]
    except:
        return json.loads(out)['message'].encode('utf8')


def metrics_daily(
                day='2016-01-31'
):
    result = {'fielddate': day}
    for app in app_ids_names:
        metric = ''.join([app_ids_names[app], 'newusers'])
        value = request_mobile_appmetrica(
                                start=day,
                                end=day,
                                app_id=app,
                                filter=filter_Russia_installs_only
        )
        result[metric] = value

        metric = ''.join([app_ids_names[app], 'users'])
        value = request_mobile_appmetrica(
                                start=day,
                                end=day,
                                app_id=app,
                                filter=filter_Russia_audience)
        result[metric] = value
    return result

print metrics_daily('2016-01-31')

