#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import json
import urllib2
import urllib


def update_statface_report(rows):
    url = 'https://stat.yandex-team.ru/_api/report/data'
    headers = {'StatRobotUser': 'robot_alesten', 'StatRobotPassword': 'Wi1oowaiph'}
    values = {'name': 'Yandex_RU/Special/Metrics/Switch/Campaigns',
              'scale': 'd',
              'data': json.dumps({'values': rows})
              }
    data = urllib.urlencode(values)
    req = urllib2.Request(url, data, headers)
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError as e:
        error_message = e.read()
        print error_message
        raise


def update_all(day, data):
    heads = {}
    for line in data:
        field_date = day
        # print line, data[line]
        source = line.split('\t')[0].upper()
        medium = line.split('\t')[1].upper()
        campaign = line.split('\t')[2].upper()

        source_path = u'\t{}\t'.format(source)
        medium_path = u'\t{}\t{}\t'.format(source, medium)
        campaign_path = u'\t{}\t{}\t{}\t'.format(source, medium, campaign)

        paths = [source_path, medium_path, campaign_path]

        for path in paths:
            if path not in heads:
                heads[path] = {}
                heads[path]['clicks'] = 0
                heads[path]['impressions'] = 0
                heads[path]['cost'] = 0
                heads[path]['conversions'] = 0
                heads[path]['chromeshare'] = []

        for path in paths:
            heads[path]['clicks'] += data[line]['clicks']
            heads[path]['impressions'] += data[line]['impressions']
            heads[path]['cost'] += data[line]['cost']
            heads[path]['conversions'] += data[line]['conversions']
            heads[path]['chromeshare'].append(data[line]['chromeshare'])
    heads_list = []
    for head in heads:
        # Count average for chrome share, not sum
        chrome = 0
        total = 0
        for pair in heads[head]['chromeshare']:
            if pair:
                chrome += pair[0]
                total += pair[1]
        if chrome and total:
            heads[head]['chromeshare'] = chrome / total
        else:
            heads[head]['chromeshare'] = 0

        temp_dict = {'fielddate': field_date,
                     'path': head,
                     'clicks': heads[head]['clicks'],
                     'impressions': heads[head]['impressions'],
                     'cost': heads[head]['cost'],
                     'conversions': heads[head]['conversions'],
                     'chromeshare': heads[head]['chromeshare']}
 #       print temp_dict
        heads_list.append(temp_dict)
    update_statface_report(heads_list)
 #   print 'stat updated!'
