#!/usr/bin/env/ python
# -*- coding: utf-8 -*-

from __future__ import division
import datetime
import json
import urllib
import urllib2
import requests
import time
import logging
import os
import sys
campaigns_folder = '/'.join([os.getcwd(), 'reports/campaigns'])
sys.path.insert(0, campaigns_folder)
import direct

timestamp = str(int(time.time()))
log_file = '/'.join([os.getcwd(), 'reports/logs/performance', timestamp + '.html'])
logging.basicConfig(filename=log_file, level=logging.DEBUG,
                    format='%(levelname)s ::: %(asctime)s : %(filename)s : %(message)s')


class Channel(object):
    def __init__(self):
        self.impressions = 0
        self.clicks = 0
        self.cost = 0


def get_new_access_token():
    url = 'https://www.googleapis.com/oauth2/v3/token'
    data = {'client_id': '375274511279-v11ercttf7181299nennk8gv69st2val.apps.googleusercontent.com',
            'client_secret': 'eTJeEeYx-8dDGR9Mqcw3u3ND',
            'refresh_token': 'YOUR_REFRESH_TOKEN_HERE',
            'grant_type': 'refresh_token'}
    r = requests.post(url, data=data)
    access_token = json.loads(r.text)['access_token']
    return access_token


def get_google_data(start, end):
    host = 'https://adwords.google.com/api/adwords/reportdownload/v201506'
    # access_token = 'ya29.qgFEKzZQ53tXgTCtFuvA15XFB3axozNAfNmjhnqYZ0R8h3FtFGrapw_G8KaG_nuh7G_X4dsl5fjCqA'
    access_token = get_new_access_token()
    header = {'Authorization': 'Bearer %s' % access_token,
              'Content-Type': 'application/x-www-form-urlencoded',
              'developerToken': '0Ke5zfuIvVfCewcaiYolCg',
              'clientCustomerId': '189-149-9566'}

    __rdxml = '''
    <reportDefinition xmlns="https://adwords.google.com/api/adwords/cm/v201506">
        <selector>
                <fields>CampaignName</fields>
                <fields>CampaignStatus</fields>
                <fields>Impressions</fields>
                <fields>Clicks</fields>
                <fields>Cost</fields>
                <dateRange>
                  <min>%s</min>
                  <max>%s</max>
                </dateRange>
        </selector>
        <reportName>Custom Adgroup Performance Report</reportName>
        <reportType>ADGROUP_PERFORMANCE_REPORT</reportType>
        <dateRangeType>CUSTOM_DATE</dateRangeType>
        <downloadFormat>TSV</downloadFormat>
    </reportDefinition>''' % (start, end)
    campaign = slice(0, 1)
    state = slice(1, 2)
    impression_count = slice(2, 3)
    click_count = slice(3, 4)
    cost = slice(4, 5)
    r = requests.post(host, headers=header, data={'__rdxml': __rdxml})
    response = r.content
    # print response
    gdn = Channel()
    search = Channel()
    for line in response.split('\n'):
        parts = line.split('\t')
        campaign_name = parts[campaign][0].lower()
        if 'switch' in campaign_name.lower():
            impressions = float(parts[impression_count][0])
            clicks = float(parts[click_count][0])
            cost_rubles = (float(parts[cost][0]) / (1000000.0))
            if campaign_name.endswith('_search'):
                search.impressions += impressions
                search.clicks += clicks
                search.cost += cost_rubles
            if campaign_name.endswith('_gdn'):
                gdn.impressions += impressions
                gdn.clicks += clicks
                gdn.cost += cost_rubles

    return {'search_impressions': search.impressions,
            'search_clicks': search.clicks,
            'search_cost': search.cost,
            'gdn_impressions': gdn.impressions,
            'gdn_clicks': gdn.clicks,
            'gdn_cost': gdn.cost}


def get_direct_data(start, end):
    """
    For documentation visit https://tech.yandex.ru/direct/doc/dg-v4/examples/python-json-docpage/
    New API access requests are moderated.
    Use contacts at https://beta.wiki.yandex-team.ru/direkt/api/ to speed up moderation.
    """
    rsya_cost = 0
    rsya_clicks = 0
    rsya_impressions = 0
    # Adress for sending JSON requests
    url = 'https://api.direct.yandex.ru/live/v4/json/'
    # OAuth
    token = 'YOUR_TOKEN_HERE'
    # Direct login
    login = 'switch-ru'

    campaign_ids = direct.get_campaigns_for_account(login=login, token=token, url=url).keys()
    # print campaign_ids
    param = {'login': login,
             'CampaignIDS': campaign_ids,
             'StartDate': start,
             'EndDate': end,
             'Currency': 'RUB'}
    # For documentation visit https://tech.yandex.ru/direct/doc/dg-v4/reference/GetSummaryStat-docpage/
    data = {'token': token,
            'method': 'GetSummaryStat',
            'locale': 'ru',
            'param': param}
    # Convert data to JSON and encode it to UTF-8
    jdata = json.dumps(data, ensure_ascii=False).encode('utf8')
    # Request api
    response = urllib2.urlopen(url, data=jdata)
    # Show the answer for request
    parsed = json.loads(response.read())
    # print json.dumps(parsed, indent=2, sort_keys=True, ensure_ascii=False)
    # Returns following structure:
    """
    {"data": [{
      "CampaignID": 13830136,
      "ClicksContext": 2142, /* Clicks in RSYA(GDN analog by Yandex) */
      "ClicksSearch": 0, /* Clicks in Search */
      "GoalConversionContext": "44.98",
      "GoalConversionSearch": null,
      "GoalCostContext": "8.86",
      "GoalCostSearch": null,
      "SessionDepthContext": "1.25",
      "SessionDepthSearch": null,
      "ShowsContext": 104123, /* Shows in RSYA */
      "ShowsSearch": 0, /* Shows in Search */
      "StatDate": "2015-08-20",
      "SumContext": 6159.84, /* Spend in RSYA */
      "SumSearch": 0}]}
    """
    data = parsed['data']
    if data:
        for campaign in data:
            rsya_cost += campaign['SumContext']  # includes VAT
            rsya_impressions += campaign['ShowsContext']
            rsya_clicks += campaign['ClicksContext']
    return {'rsya_cost': rsya_cost,
            'rsya_impressions': rsya_impressions,
            'rsya_clicks': rsya_clicks}
#print get_direct_data('2015-11-18', '2015-11-18')


def get_metrica_conversions(start, end):
    url = 'https://beta.api-metrika.yandex.ru/stat/v1/data'
    data = {'dimensions': ['ym:s:UTMSource', 'ym:s:UTMMedium', 'ym:s:UTMCampaign'],
            'metrics': ['ym:s:goal11840621users'],
            'date1': start,
            'date2': end,
            'oauth_token': 'a55d84a6481d410c95341ceb45cd172f',
            'pretty': '1',
            'ids': '31119731'}
    r = requests.get(url, params=data)
    out = r.content
    # print json.dumps(json.loads(out), sort_keys=True, indent=2)

    search_conversions = 0
    gdn_conversions = 0
    rsya_conversions = 0
    ya_search_conversions = 0

    for item in json.loads(out)['data']:
        source = item['dimensions'][0]['name']
        medium = item['dimensions'][1]['name']
        campaign = item['dimensions'][2]['name']
        installs = item['metrics'][0]
        if source and medium and campaign:
            source = source.lower()
            medium = medium.lower()
            campaign = campaign.lower()
            if source == 'google':
                if medium == 'gdn':
                    gdn_conversions += installs
                if medium == 'search':
                    if campaign in ['brand_gdn', 'brand_rem_gdn']:
                        gdn_conversions += installs
                    else:
                        search_conversions += installs
            elif source == 'yandex':
                if medium in ['rsya', 'cpc']:
                    rsya_conversions += installs
                elif medium == 'search':
                    ya_search_conversions += installs
    return search_conversions, gdn_conversions, rsya_conversions, ya_search_conversions
# print get_metrica_conversions('2015-09-28', '2015-09-28')


def combine_all_data(start, end):
    google_start_date = start.replace('-', '')
    google_end_date = end.replace('-', '')
    metrica_start_date = start
    metrica_end_date = end
    # Get outputs:
    metrika_output = get_metrica_conversions(metrica_start_date, metrica_end_date)
    google_output = get_google_data(google_start_date, google_end_date)
    direct_output = get_direct_data(start, end)
    # CONVERSIONS == NUMBER OF INSTALLS (AGREE IN INLINE):
    search_conversions = metrika_output[0]
    gdn_conversions = metrika_output[1]
    rsya_conversions = metrika_output[2]
    #ya_search_conversions = metrika_output[3]
    total_conversions = search_conversions + gdn_conversions + rsya_conversions
    # SPEND:
    search_spend = round(google_output['search_cost'], 4)
    gdn_spend = round(google_output['gdn_cost'], 4)
    rsya_spend = round(direct_output['rsya_cost'], 4)
    #ya_search_spend = round(direct_output['ya_search_cost'], 4)
    total_spend = search_spend + gdn_spend + rsya_spend
    # IMPRESSIONS:
    search_impressions = google_output['search_impressions']
    gdn_impressions = google_output['gdn_impressions']
    rsya_impressions = direct_output['rsya_impressions']
    #ya_search_impressions = direct_output['ya_search_impressions']
    total_impressions = search_impressions + gdn_impressions + rsya_impressions
    # CLICKS:
    search_clicks = google_output['search_clicks']
    gdn_clicks = google_output['gdn_clicks']
    rsya_clicks = direct_output['rsya_clicks']
    #ya_search_clicks = direct_output['ya_search_clicks']
    total_clicks = search_clicks + gdn_clicks + rsya_clicks
    # CPA
    try:
        search_cpa = round(search_spend / search_conversions, 4)
    except ZeroDivisionError:
        search_cpa = 0.0
    try:
        gdn_cpa = round(gdn_spend / gdn_conversions, 4)
    except ZeroDivisionError:
        gdn_cpa = 0.0
    try:
        rsya_cpa = round(rsya_spend / rsya_conversions, 4)
    except ZeroDivisionError:
        rsya_cpa = 0.0
   # try:
   #     ya_search_cpa = round(ya_search_spend / ya_search_conversions, 4)
   # except ZeroDivisionError:
   #     ya_search_cpa = 0.0
    all_cpa = round(total_spend / total_conversions, 4)
    # CTR
    try:
        search_ctr = round(search_clicks / (search_impressions * 1.0), 4)
    except ZeroDivisionError:
        search_ctr = 0.0
    try:
        gdn_ctr = round(gdn_clicks / (gdn_impressions * 1.0), 4)
    except ZeroDivisionError:
        gdn_ctr = 0.0
    try:
        rsya_ctr = round(rsya_clicks / (rsya_impressions * 1.0), 4)
    except ZeroDivisionError:
        rsya_ctr = 0.0
   # try:
   #     ya_search_ctr = round(ya_search_clicks / (ya_search_impressions * 1.0), 4)
   # except ZeroDivisionError:
   #     ya_search_ctr = 0.0
    # LANDING PAGE CONVERSION RATE:
    try:
        s_lpcr = round(search_conversions / search_clicks, 4)
    except ZeroDivisionError:
        s_lpcr = 0.0
    try:
        gdn_lpcr = round(gdn_conversions / gdn_clicks, 4)
    except ZeroDivisionError:
        gdn_lpcr = 0.0
    try:
        rsya_lpcr = round(rsya_conversions / rsya_clicks, 4)
    except ZeroDivisionError:
        rsya_lpcr = 0.0
   # try:
   #     ya_search_lpcr = round(ya_search_conversions / ya_search_clicks, 4)
   # except ZeroDivisionError:
   #     ya_search_lpcr = 0.0
    # CPC:
    try:
        search_cpc = round(search_spend / (search_clicks * 1.0), 4)
    except ZeroDivisionError:
        search_cpc = 0.0
    try:
        gdn_cpc = round(gdn_spend / (gdn_clicks * 1.0), 4)
    except ZeroDivisionError:
        gdn_cpc = 0.0
    try:
        rsya_cpc = round(rsya_spend / (rsya_clicks * 1.0), 4)
    except ZeroDivisionError:
        rsya_cpc = 0.0
   # try:
   #     ya_search_cpc = round(ya_search_spend / (ya_search_clicks * 1.0), 4)
   # except ZeroDivisionError:
   #     ya_search_cpc = 0.0

    graph_dict = {'fielddate': start,
                  'search_ctr': search_ctr, 'gdn_ctr': gdn_ctr, 'rsya_ctr': rsya_ctr,
                  'search_cpc': search_cpc, 'gdn_cpc': gdn_cpc, 'rsya_cpc': rsya_cpc,
                  'search_cost': search_spend, 'gdn_cost': gdn_spend, 'rsya_cost': rsya_spend,
                  'search_conversions': search_conversions, 'gdn_conversions': gdn_conversions,
                  'rsya_conversions': rsya_conversions,
                  'total_conversions': total_conversions,
                  'search_cpa': search_cpa, 'gdn_cpa': gdn_cpa, 'rsya_cpa': rsya_cpa, 'avg_cpa': all_cpa,
                  's_lpcr': s_lpcr, 'gdn_lpcr': gdn_lpcr, 'rsya_lpcr': rsya_lpcr}
    return graph_dict


def draw_graph(graph_dict):
    url = 'https://stat.yandex-team.ru/_api/report/data'
    headers = {'StatRobotUser': 'robot_alesten', 'StatRobotPassword': 'Wi1oowaiph'}
    values = {'name': 'Yandex_RU/Special/Metrics/Switch/Conversions',
              'scale': 'd',
              'data': json.dumps({'values': [graph_dict]})}
    # print graph_dict
    data = urllib.urlencode(values)
    req = urllib2.Request(url, data, headers)
    urllib2.urlopen(req)
    print 'Big statistics data loaded to https://stat.yandex-team.ru/Yandex_RU/Special/Metrics/Switch/Performance_beta'


def days_range(start, stop):
    start = datetime.datetime.strptime(start, '%Y-%m-%d')
    stop = datetime.datetime.strptime(stop, '%Y-%m-%d')
    days_count = int((stop - start).days) + 1
    days_list = [(stop - datetime.timedelta(days=x)).strftime('%Y-%m-%d')
                  for x in xrange(days_count)]
    return days_list[::-1]


if __name__ == "__main__":
    logging.info('RU performance report starting')
    old_data = False
    #old_data = True
    logging.info('Calculating historic data: {}'.format(old_data))
    if old_data:
        for day in days_range('2015-10-25', '2015-11-19'):
            logging.info('Calculating date: {}'.format(day))
            try:
                all_data = combine_all_data(day, day)
                result_log = json.dumps(all_data, sort_keys=True, indent=2)
                logging.info(result_log)
            except:
                logging.critical('combine_all_data failed')
            try:
                draw_graph(all_data)
                logging.info('success')
            except:
                logging.critical('failed to update graph')
    else:
        today_date = datetime.date.today()
        yesterday_date = today_date - datetime.timedelta(1)
        yesterday = yesterday_date.strftime('%Y-%m-%d')
        today = today_date.strftime('%Y-%m-%d')
        if time.localtime().tm_hour < 1:
            logging.info('Calculating full day for yesterday')
            try:
                all_data = combine_all_data(yesterday, yesterday)
                result_log = json.dumps(all_data, sort_keys=True, indent=2)
                logging.info(result_log)
            except:
                logging.critical('combine_all_data failed')
            try:
                draw_graph(all_data)
                logging.info('success')
            except:
                logging.critical('failed to update graph')
        else:
            logging.info('Calculating last hour')
            try:
                all_data = combine_all_data(today, today)
                result_log = json.dumps(all_data, sort_keys=True, indent=2)
                logging.info(result_log)
            except:
                logging.critical('combine_all_data failed')
            try:
                draw_graph(all_data)
                logging.info('success')
            except:
                logging.critical('failed to update graph')

