#!/usr/bin/env/ python
# -*- coding: utf-8 -*-

import Campaigns.gos as gos
import Campaigns.metrica as metrica
import datetime
import json
import urllib
import urllib2
import requests
import re
import time

__author__ = 'chikachoff'


def update_statface_report(rows):
    url = 'https://stat.yandex-team.ru/_api/report/data'
    headers = {'StatRobotUser': 'robot_alesten', 'StatRobotPassword': 'Wi1oowaiph'}
    values = {'name': 'Yandex_RU/Special/Metrics/Switch/PlacementPerformance',
              'scale': 'd',
              'data': json.dumps({'values': rows})
              }
    data = urllib.urlencode(values)
    req = urllib2.Request(url, data, headers)
    try:
        response = urllib2.urlopen(req)
    except urllib2.HTTPError as e:
        error_message = e.read()
        print error_message
        raise


def update_all(day, data):
    heads = {}

    for line in data:
        field_date = day
        # print line, data[line]

        channel = line.split('\t')[1].upper()
        campaign = line.split('\t')[2].upper()
        placement = line.split('\t')[3].upper()

        channel_path = '\t{}\t'.format(channel)
        campaign_path = '\t{}\t{}\t'.format(channel, campaign)
        placement_path = '\t{}\t{}\t{}\t'.format(channel, campaign, placement)

        if channel_path not in heads:
            heads[channel_path] = {}
            heads[channel_path]['visits'] = 0
            heads[channel_path]['conversions'] = 0

        if campaign_path not in heads:
            heads[campaign_path] = {}
            heads[campaign_path]['visits'] = 0
            heads[campaign_path]['conversions'] = 0

        if placement_path not in heads:
            heads[placement_path] = {}
            heads[placement_path]['visits'] = 0
            heads[placement_path]['conversions'] = 0

        heads[channel_path]['visits'] += data[line]['visits']
        heads[channel_path]['conversions'] += data[line]['conversions']

        heads[campaign_path]['visits'] += data[line]['visits']
        heads[campaign_path]['conversions'] += data[line]['conversions']

        heads[placement_path]['visits'] += data[line]['visits']
        heads[placement_path]['conversions'] += data[line]['conversions']

    print 'updating stat..'

    heads_list = []
    for head in heads:
        temp_dict = {'fielddate': field_date,
                     'path': head,
                     'visits': heads[head]['visits'],
                     'conversions': heads[head]['conversions']
                     }

        heads_list.append(temp_dict)
    # print heads_list
    update_statface_report(heads_list)
    print 'Placement Performance stat updated. Time: {}:{}'.format(time.localtime().tm_hour, time.localtime().tm_min)

today_date = datetime.date.today()
yesterday_date = today_date - datetime.timedelta(1)
yesterday = yesterday_date.strftime('%Y%m%d')

for day in gos.days_range(yesterday, yesterday):
    print 'Day', day
    data = metrica.get_metrica_placement(day, day)
    gos.json_print(data)
    update_all(day, data)
