from abc import ABC, abstractmethod


class ViewerError(Exception, ABC):
    """
    Abstract error for all custom exceptions to inherit from
    """
    pass


class ViewableError(ViewerError, ABC):
    def __init__(self):
        pass

    @abstractmethod
    def get_error(self) -> str:
        """
        :return: The text of the error message to be shown to user
        """
        pass


class PlainTextError(ViewableError):

    def __init__(self, message: str):
        super().__init__()
        self._message = message

    def get_error(self) -> str:
        return self._message


class ValidationError(PlainTextError):
    pass


class DataError(PlainTextError):
    pass


class ChytException(ViewerError):
    def __init__(self, query: str):
        self.query = query
