USE arnold;
PRAGMA SimpleColumns;
PRAGMA yt.InferSchema;
PRAGMA yson.DisableStrict;
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

DECLARE $day AS STRING;


$format_shows_location = Python3::format_shows_location(Callable<(String?, String?, String?, String?, String?, String?) -> String>,
@@


def format_shows_location_ui(service='', ui='', page_name='', location='', content_type='', content_subtype=''):
    ui = ui.decode('utf-8') if ui is not None else ''
    location = format_shows_location(service, ui, page_name, location, content_type, content_subtype)
    return f'{location}, {ui}'


def format_shows_location(service='', ui='', page_name='', location='', content_type='', content_subtype=''):
    service = service.decode('utf-8') if service is not None else ''
    page_name = page_name.decode('utf-8') if page_name is not None else ''
    location = location.decode('utf-8') if location is not None else ''
    content_type = content_type.decode('utf-8') if content_type is not None else ''
    content_subtype = content_subtype.decode('utf-8') if content_subtype is not None else ''
    if service == 'web':
        if location == 'kokos':
            return 'серп: кокос'
        if location == 'collections-snippet':
            return 'серп: спецсниппет'
        if location == 'serpviewer':
            return 'серп: просмотрщик'

    if service == 'images':
        if location == 'kokoko':
            return 'картинки: кококо'

    if service == 'morda':
        if location == 'informer':
            if content_type == 'card':
                return 'морда: информер карточки'
            else:
                return 'морда: информер'

    if service == 'collections':
        if location == 'page':
            return 'коллекции: страница {}'.format(page_name)

        if content_subtype == 'boardCards':
            return 'коллекции: карточки внутри борды'

        if content_subtype == 'cards$cardSimilarToCard' or content_subtype == 'cards$similar' or content_subtype == 'cardSimilar' or content_subtype == 'cardSimilarToCard':
            return 'коллекции: card2card'

        if location == 'similarCardToBoard':
            return 'коллекции: card2board'

        if location == 'similarBoardToBoard' or content_subtype == 'footerBoardSimilar':
            return 'коллекции: board2board'

        if location == 'channel' and content_subtype == 'channelCards':
            return 'коллекции: карточки в каналах'

        if location == 'cardPopup':
            return 'коллекции: cardPopup'

        if content_subtype == 'feedCards':
            return 'коллекции: card2user'

        if content_subtype == 'feedBoards':
            return 'коллекции: board2user'

        if content_subtype == 'boardBoards':
            return 'коллекции: борды в профиле'

        if content_subtype == 'feedRecommendations':
            return 'коллекции: рекомендации board2user в ленте card2user'

        if content_subtype == 'contestCards':
            return 'коллекции: карточки конкурсов'

        if content_subtype == 'searchCards':
            return 'коллекции: searchCards'

        if content_subtype == 'mainCards':
            return 'коллекции: mainCards'

    return f'{service}_{page_name}_{location}_{content_type}_{content_subtype}'


@@
);


DEFINE ACTION $gather_shows_clicks_for_date($date) AS

    $boards_updated_from = CAST(CAST($date AS Date) - Interval('P30D') AS String);

    $shows_clicks_tablename = "//home/collections/analytics/boards_viewer/shows_clicks/" || $date;

    $parsed_boards = (
    SELECT
        b.id as id,
        b.owner as owner_id,
        Yson::ConvertToString(document.title) as title,
        Yson::ConvertToString(document.slug) as slug,
        Yson::ConvertToString(document.service.created_at['_$date']) as created_date,
        Yson::ConvertToString(document.service.updated_at['_$date']) as updated_date,
        Yson::ConvertToInt64(document.stat.pub_cs) as pub_cs,
        Yson::ConvertToString(document['features']['corgie_v3']['value']) IN ('2', '3') as is_corgie_v3
    FROM `//home/collections-backups/db/prod/podborki/latest/board` as b
    WHERE (
            Yson::ConvertToString(document.slug) NOT IN (
                'moi_kartinki', 'moi-kartinki', 'moi_video', 'moji_video', 'moi-video', 'moi_serialy', 'moi-serialy',
                'moi_filmy', 'moi-filmy', 'moi_igry', 'moi_ssylki', 'kartinki', 'video', 'nerazobrannoe', 'raznoe',
                '_empty_', '', '1', 'izbrannoe', 'posmotret', 'novaia-kollektsiia', 'moia', 'a', 'zagruzki', '_wishlist'
            )
            AND Yson::ConvertToInt64(document.stat.pub_cs) >= 3
        )
        OR (
            Yson::ConvertToString(document['features']['corgie_v3']['value']) IN ('2', '3')
        )
    );

    $boards = (
        SELECT
            *
        FROM $parsed_boards
        WHERE updated_date > $boards_updated_from AND updated_date <= $date
        OR is_corgie_v3
    );

    -- SELECT * FROM $boards LIMIT 10;

    $fresh_board_ids = (
        SELECT DISTINCT id
        FROM $boards
    );

    INSERT INTO $shows_clicks_tablename WITH TRUNCATE
    SELECT
        board_id,
        card_id,
        COALESCE(clicks, 0) as clicks,
        `timestamp` as `timestamp`,
        $format_shows_location(service, ui, page_name, location, content_type, content_subtype) as location,
        ui
    FROM RANGE(`//home/collections/analytics/backups/COLA-10_collections_content_shows_squeeze`, $date, $date) as s
    WHERE board_id IN $fresh_board_ids
    ORDER BY board_id;
END DEFINE;

DO $gather_shows_clicks_for_date($day);
