import copy
import datetime

import requests

from exceptions import DataError


def get_board_id_by_selector(selector: str) -> str:
    splitted = selector.split("/")
    try:
        ind = splitted.index("user")
        user = splitted[ind + 1]
        slug = splitted[ind + 2]
    except ValueError:
        return selector
    print(f"user: {user}, slug: {slug}")
    url = f"http://internal.collections.yandex.ru/collections/internalapi/boards/?slug={slug}&owner.login={user}"
    resp = requests.get(url)
    try:
        board_id = resp.json()['results'][0]['id']
    except (KeyError, IndexError):
        raise DataError(f"Was not able to parse ID for board by selector {selector}")
    print(f"The parsed board id is {board_id}")
    return board_id


def main(in1, in2, in3, mr_tables, token1=None, token2=None, param1=None, param2=None, html_file=None):
    out1 = copy.deepcopy(in1)
    out1[0]['$board_id'] = get_board_id_by_selector(in1[0]['board_selector'])
    if not in1[0].get('date', ''):
        out1[0]['$date'] = str(datetime.datetime.now().date())
    else:
        out1[0]['$date'] = in1[0]['date']
    return out1
