DECLARE $date AS String;
DECLARE $board_id AS String;

use arnold;

$start_date = CAST(CAST($date AS Date) - Interval('P30D') AS String);

$rounded_timestamp = (
    SELECT
        location_ui,
        clicks,
        (`timestamp` / 60) * 60 as `timestamp`
    FROM RANGE(`//home/collections/analytics/boards_viewer/shows_clicks`, $start_date, $date)
    WHERE board_id = $board_id
);

SELECT
    `timestamp`,
    location_ui,
    COUNT(*) as shows,
    SUM(clicks) as clicks
FROM $rounded_timestamp
GROUP BY `timestamp`, location_ui
