#!/usr/bin/env python
# coding: utf-8

import sys
reload(sys)
sys.setdefaultencoding("utf-8")

import os
import json
import jinja2
from datetime import datetime
from collections import defaultdict, Counter

SESSION_SPLIT_INTERVAL = 30 * 60


def split_sessions(events, split_interval=SESSION_SPLIT_INTERVAL):
    events.sort(key=lambda x: (
        x.get('track_objects_data_start') if x.get('track_objects_data_start') else int(x.get('cts'))
    ))

    session = [events.pop(0)]
    for event in events:
        if int(event.get('ts')) - int(session[-1].get('ts')) > split_interval:
            yield session
            session = [event]
        else:
            session.append(event)

    yield session


def save_html(uid, html):
    filename = 'sessions/y{}.html'.format(uid)
    if not os.path.exists(os.path.dirname(filename)):
        try:
            os.makedirs(os.path.dirname(filename))
        except OSError:
            pass
    with open(filename, 'w') as f:
        f.write(html)


def format_timestamp(timestamp, format='%Y-%m-%d %H:%M'):
    date = datetime.fromtimestamp(timestamp)
    return date.strftime(format)


def to_pretty_json(value):
    return json.dumps(value, sort_keys=True, indent=4, separators=(',', ': '))


def init_template():
    loader = jinja2.FileSystemLoader('templates')
    env = jinja2.Environment(autoescape=True, loader=loader)
    env.filters['format_timestamp'] = format_timestamp
    env.filters['to_pretty_json'] = to_pretty_json
    return env.get_template('index.tpl')


def prepare_sessions(sessions_raw):
    for session in sessions_raw:
        result = []

        last_track_objects = None
        for r in session:
            if r.get('path') == 'track.objects' and all([x is None for x in r.get('track_objects_data', [])]):
                continue

            if r.get('path') == 'track.objects':
                if last_track_objects is None:
                    last_track_objects = r
                    last_track_objects['track_objects_items'] = []
                else:
                    if len(last_track_objects['track_objects_items']) and r.get('track_objects_data', [])[5][0] != last_track_objects['track_objects_items'][-1]['type']:
                        last_track_objects['track_objects_items'].sort(key=lambda x: x['start'])
                        result.append(last_track_objects)
                        last_track_objects = r
                        last_track_objects['track_objects_items'] = []

                item = {
                    'type': r.get('track_objects_data', [])[5][0],
                    'pos': r.get('track_objects_data', [])[3][0],
                    'start': r.get('track_objects_data', [])[4][0],
                    'finish': r.get('track_objects_data', [])[2][0],
                    'ts': r.get('track_objects_data', [])[2][0] - r.get('track_objects_data', [])[4][0]
                }
                for key in ('track_objects_data_card_preview', 'track_objects_data_card_url', 'track_objects_data_board_preview', 'track_objects_data_board_url', 'track_objects_data_board_title'):
                    if r.get(key):
                        item[key] = r.get(key)

                if item['ts'] >= 100:
                    found = False
                    for i in last_track_objects['track_objects_items']:
                        if item['pos'] == i['pos']:
                            i['ts'] += item['ts']
                            i['start'] = min(i['start'], item['start'])
                            found = True
                    if not found:
                        last_track_objects['track_objects_items'].append(item)
            else:
                if last_track_objects is not None:
                    last_track_objects['track_objects_items'].sort(key=lambda x: x['start'])
                    result.append(last_track_objects)
                    last_track_objects = None

                result.append(r)


        if last_track_objects is not None:
            last_track_objects['track_objects_items'].sort(key=lambda x: x['start'])
            result.append(last_track_objects)

        if result:
            yield result


def calc_sessions_stats(records):
    # насколько большие промежутки между соседними счётчиками
    density = round(
        sum([
            (records[i].get('ts') - records[i - 1].get('ts'))
            for i in range(1, len(records))]
        ) / float(len(records))
        if len(records) > 0 else 0,
        2
    )
    sessions_count = len([
        1
        for i in range(1, len(records))
        if (records[i].get('ts') - records[i - 1].get('ts') > SESSION_SPLIT_INTERVAL)
    ]) + 1
    return dict(
        rows=len(records),
        sessions=sessions_count,
        clicks=len([x for x in records if 'click' in x.get('path')]),
        likes=len([x for x in records if x.get('path') == 'finish.card.like']),
        creates=len([x for x in records if 'create' in x.get('path')]),
        access=len([x for x in records if x.get('path') == 'access']),
        track_objects=len([x for x in records if x.get('path') == 'track.objects']),
        density=density,
        timespent=int(records[-1].get('ts')) - int(records[0].get('ts')),
    )


def calc_path_stats(records):
    stats = Counter()
    for r in records:
        stats[r.get('path')] += 1

    return stats.most_common()


def get_user_session_template_data(yuid, records):
    sessions_raw = split_sessions(records)

    sessions = list(prepare_sessions(sessions_raw))

    sessions_stats = []
    path_stats = []
    for session in sessions:
        sessions_stats.append(calc_sessions_stats(session))
        path_stats.append(calc_path_stats(session))

    return {
        'base_href': '../',
        'yuid': yuid,
        'user_info_template_data': {},
        'sessions': sessions,
        'sessions_stats': sessions_stats,
        'all_sessions_stats': calc_sessions_stats(records),
        'path_stats': path_stats,
    }


def save_user_session_html(idx, yuid, records):
    template = init_template()
    template_data = get_user_session_template_data(yuid, records)
    html = template.render(template_data)
    save_html(yuid, html)


def save_index_html_file(records_by_user):
    f = open('index.html', 'w')
    f.write("""<!doctype html>
    <html class="no-js" lang="">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <title>Collections Sessions Viewer</title>
        <meta name="description" content="">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <link rel="stylesheet" href="{BASE_HREF}css/bootstrap.4.3.1.min.css">
        <link rel="stylesheet" href="{BASE_HREF}css/main.css">
        <script src="{BASE_HREF}js/vendor/jquery-1.11.2.min.js"></script>
        <script src="{BASE_HREF}js/vendor/bootstrap.4.3.1.min.js"></script>
        <script src="{BASE_HREF}js/main.js"></script>
    </head>
    <body>
        <table class="table stats_table">
        <thead>
            <tr>
                <th scope="col">#</th>
                <th scope="col">yuid</th>
                <th scope="col">ui</th>
                <th scope="col">browser</th>
                <th scope="col">sessions</th>
                <th scope="col">rows</th>
                <th scope="col">clicks</th>
                <th scope="col">likes</th>
                <th scope="col">creates</th>
                <th scope="col">access</th>
                <th scope="col">track objects</th>
                <th scope="col">разреженность</th>
                <th scope="col">timespent</th>
            </tr>
        </thead>
        <tbody>
        """.format(BASE_HREF='./'))

    for idx, (yuid, records) in enumerate(records_by_user.iteritems()):
        if len(records) < 3:
            continue
        f.write("""
        <tr>
            <th scope="row">{idx}</th>
            <td><a href="sessions/y{yuid}.html" target="_blank">y{yuid}</a></td>
            <td>{ui}</td>
            <td>{browser}</td>
            <td>{sessions}</td>
            <td>{rows}</td>
            <td>{clicks}</td>
            <td>{likes}</td>
            <td>{creates}</td>
            <td>{access}</td>
            <td>{track_objects}</td>
            <td>{density}</td>
            <td>{timespent}</td>
        </tr>
        """.format(
            idx=(idx+1),
            yuid=yuid,
            ui=records[0]['ui'],
            browser=records[0]['browser'],
            **calc_sessions_stats(records)
        ))

    f.write("""
        </tbody>
        </table>
        </html>
        """)

    f.close()


def collections_sessions_viewer(records):
    records_by_user = defaultdict(list)
    for r in records:
        if r.get('path') in ('view.cards', 'show.card', 'view.boards'):
            continue

        # преобразование данных
        r['ts'] = int(r.get('ts', 0))
        r['counter_data'] = {x[0]: x[1] for x in r.get('counter_data', []) if len(x) == 2}
        for preview_key in ('track_objects_data_card_preview', 'track_objects_data_board_preview', 'card_preview', 'board_preview'):
            if r.get(preview_key):
                r[preview_key] = r.get(preview_key).replace('/preview', '/thumb')

        records_by_user[r.get('yandexuid')].append(r)

    save_index_html_file(records_by_user)

    for idx, (yuid, records) in enumerate(records_by_user.items()):
        save_user_session_html(idx, yuid, records)


def main(*args):
    in1, in2, in3, token, any_param, html_file = args

    collections_sessions_viewer(in1)

    return []