<div class="row">
    <div class="col-md-9">
        <div class="card mb-2 box-shadow {% if event['path'] == 'track.objects': %}bg-track-objects{% elif event['path'] in ('access', 'start.session', 'finish.session'): %}bg-access{% elif 'like' in event['path'] or 'click' in event['path'] or 'create' in event['path'] or 'share' in event['path']: %}bg-click{% else: %}bg-counter-default{% endif %}">
            <div class="card-body">
                {% if event['path'] == 'track.objects': %}

                    <p>
                        {{ event['path'] }}, loc {{ event['loc'] }} {% if event['track_objects_items'][0]: %} type {{ event['track_objects_items'][0]['type'] }} {% endif %}
                    </p>

                    <div class="track_objects_items">
                        {% for item in event['track_objects_items'][:12]:
                            %}<div class="track_objects__card">
                                {% if item['track_objects_data_card_preview']: %}
                                <a href="{{ item['track_objects_data_card_url'] }}" target="_blank">
                                    <img src="{{ item['track_objects_data_card_preview'] }}" class="track_objects__card__preview" />
                                </a>
                                {% endif %}
                                {% if item['track_objects_data_board_preview']: %}
                                <a href="{{ item['track_objects_data_board_url'] }}" target="_blank">
                                    <img src="{{ item['track_objects_data_board_preview'] }}" class="track_objects__card__preview" />
                                </a>
                                {% endif %}

                                <div class="track_objects__card__text">
                                    pos {{ item['pos'] }}, ts {{ item['ts'] / 1000 }}
                                </div>
                            </div>{%
                         endfor %}{% if event['track_objects_items']|length > 12: %}
                        <p>
                            <a class="btn btn-success" data-toggle="collapse" href="#more_cards_{{ event['track_objects_items'][12]['start'] }}" aria-expanded="false" aria-controls="more_cards_{{ event['track_objects_items'][12]['start'] }}">
                              expand {{ event['track_objects_items']|length - 12 }} cards <span class="glyphicon glyphicon-chevron-down"aria-hidden="true"></span>
                            </a>
                            <div class="collapse" id="more_cards_{{ event['track_objects_items'][12]['start'] }}">
                                {% for item in event['track_objects_items'][12:]:
                                %}<div class="track_objects__card">
                                    {% if item['track_objects_data_card_preview']: %}
                                    <a href="{{ item['track_objects_data_card_url'] }}" target="_blank">
                                        <img src="{{ item['track_objects_data_card_preview'] }}" class="track_objects__card__preview" />
                                    </a>
                                    {% endif %}
                                    {% if item['track_objects_data_board_preview']: %}
                                    <a href="{{ item['track_objects_data_board_url'] }}" target="_blank">
                                        <img src="{{ item['track_objects_data_board_preview'] }}" class="track_objects__card__preview" />
                                    </a>
                                    {% endif %}

                                    <div class="track_objects__card__text">
                                        pos {{ item['pos'] }}, ts {{ (item['finish'] - item['start']) / 1000 }}
                                    </div>
                                </div>{%
                             endfor %}
                            </div>
                        </p>
                        {% endif %}


                    </div>

                {% else: %}

                    <p>
                        {{ event['path'] }}, loc {{ event['loc'] }}, page_name {{ event['page_name'] }},
                        {% if event['path'] in ('access', 'start.session'): %}traffic_source {{ event['traffic_source'] }}, {% endif %}
                        {% if event['counter_data']['type']: %} type {{ event['counter_data']['type'] }}, {% endif %}
                        <a href="{{ event['url'] }}" target="_blank">url</a>
                    </p>

                    {% if event['board_title']: %}
                    <p>
                        {{ event['board_title'] }}
                    </p>
                    {% endif %}

                    {% if event['card_preview']: %}
                        <a href="{{ event['card_url'] }}" target="_blank">
                            <img src="{{ event['card_preview'] }}" class="card__preview" />
                        </a>
                    {% elif event['board_preview']: %}
                        <a href="{{ event['board_url'] }}" target="_blank">
                            <img src="{{ event['board_preview'] }}" class="card__preview" />
                        </a>
                    {% endif %}

                {% endif %}

                <p>
                    <a class="underlined" data-toggle="collapse" href="#collapseExample_{{idx}}" aria-expanded="false" aria-controls="collapseExample_{{idx}}">
                      counter data
                    </a>
                    <div class="collapse" id="collapseExample_{{idx}}">
                        <div class="card-text">
                            <pre>{{ event|to_pretty_json|safe}}</pre>
                        </div>
                    </div>
                </p>


            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card mb-2 box-shadow">
            {{ event['ts']|format_timestamp('%H:%M:%S') }}, +{{event['ts'] - session[idx-2]['ts']}}s<br/>

            {% if event['path'] == 'track.objects': %}
                {% if event['track_objects_data_card_id']: %}
                card_id: <a href="{{ event['track_objects_data_card_url'] }}" target="_blank">{{ event['track_objects_data_card_id'] }}</a><br/>
                {% endif %}
                {% if event['track_objects_data_board_id']: %}
                board_id: <a href="{{ event['track_objects_data_board_url'] }}" target="_blank">{{ event['track_objects_data_board_id'] }}</a><br/>
                {% endif %}
            {% endif %}

            {% if event['card_id']: %}
                card_id <a href="https://yandex.ru/collections/card/{{ event['card_id'] }}/" target="_blank">{{ event['card_id'] }}</a><br/>
            {% endif %}
            {% if event['board_id']: %}
                board_id <a href="https://yandex.ru/collections/api/boards/{{ event['board_id'] }}" target="_blank">{{ event['board_id'] }}</a><br/>
            {% endif %}
            {% if event['board_url']: %}
                <a href="{{ event['board_url'] }}" target="_blank">{{ event['board_title'] }}</a><br/>
            {% endif %}
        </div>
    </div>

</div>