<!doctype html>
<html class="no-js" lang="">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Collections Sessions Viewer</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="{{ base_href }}css/bootstrap.4.3.1.min.css">
    <link rel="stylesheet" href="{{ base_href }}css/main.css">
</head>
<body>

<nav class="navbar navbar-expand-md navbar-dark bg-dark fixed-top">
    <a class="navbar-brand" href="/">Collections Sessions Viewer</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault"
            aria-controls="navbarsExampleDefault" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
</nav>

<main role="main" class="container">

</main><!-- /.container -->

<!-- Main jumbotron for a primary marketing message or call to action -->
<div class="jumbotron">
    <div class="container">
        <h1>y{{ yuid }}</h1>
        {{ all_sessions_stats|to_pretty_json|safe }}

        {% if sessions|length and sessions[0]|length: %}
            <p>ui: {{ sessions[0][0]['ui'] }}, browser: {{ sessions[0][0]['browser'] }}</p>
        {% endif %}

        {% if user_info_template_data['collections_stats'] %}
        <p>{{ user_info_template_data['collections_stats'] }}</p>
        {% endif %}
    </div>
</div>

<div class="container">
    <!-- Example row of columns -->
    <div class="row">
        <div class="col-md-12">

            {% if sessions|length: %}
            <div class="accordion feedsAccordion" id="feedsAccordion">
                <div class="card">
                    <div class="card-header list-group-item active">
                        <h4 class="mb-0">
                            User sessions
                        </h4>
                    </div>
                </div>
                {% for session in sessions: %}
                <div class="card">
                    <div class="card-header" id="heading_{{loop.index}}">
                        <h2 class="mb-0">
                            <button class="btn btn-link collapsed taleft" type="button"
                                    data-toggle="collapse" data-target="#session_{{loop.index}}"
                                    aria-expanded="true" aria-controls="#session_{{loop.index}}">
                                {{ session[0]['ts']|format_timestamp() }}, duration {{ (session[-1]['ts'] - session[0]['ts']) / 60.0 }} min<br/>
                                {{ sessions_stats[loop.index - 1]|to_pretty_json|safe }}
                                <span class="glyphicon glyphicon-chevron-down"aria-hidden="true"></span>
                            </button>
                        </h2>
                    </div>

                    <div id="session_{{loop.index}}" class="card-body-wrapper collapse" aria-labelledby="heading_{{loop.index}}"
                         data-parent="#feedsAccordion">
                        <div class="card-body feed-body">

                            <div class="container">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card mb-4 box-shadow">

                                            <div class="yandex-search__logo">
                                                <div class="yandex-search__feed-link">
                                                    <a href="https://yandex.ru" target="_blank"
                                                       class="logo-yandex">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="58" height="44" fill="currentColor" class="turbo-header__logo-svg"><path d="M8.67 22.88V30h2V11.41H7.68c-2.94 0-5.4 1.95-5.4 5.85 0 2.78 1.09 4.29 2.72 5.12L1.52 30h2.31l3.18-7.12h1.66zm0-1.67H7.6c-1.74 0-3.17-.96-3.17-3.95 0-3.1 1.56-4.16 3.17-4.16h1.07v8.11zm22.07 7.13H29.7V16.9h-6.08V18c0 3.49-.13 7.54-1.33 10.33h-.8v4.23h1.81V30h5.62v2.57h1.82v-4.23zm8.81.78l-.46-1.56c-.52.36-1.43.88-2.58.88-1.6 0-2.44-1.56-2.44-4.52h5.46V22.8c0-4.45-1.43-6.09-3.62-6.09-2.78 0-3.95 3.07-3.95 7.28 0 4.03 1.67 6.2 4.37 6.2 1.3 0 2.4-.42 3.22-1.07zM18.31 16.9v5.56H15.3V16.9h-2.03V30h2.03v-5.88h3.01V30h2V16.9h-2zM47.1 30h2.21l-3.71-6.94 3.25-6.16h-2.06l-3.14 6.05V16.9H41.6V30h2.03v-6.53L47.09 30zm6.97.18c1.2 0 2.03-.39 2.73-.99l-.47-1.5c-.46.41-1.22.8-2.2.8-1.64 0-2.42-1.87-2.42-5.15 0-3.3 1.04-4.94 2.5-4.94.82 0 1.6.45 2.15.91l.29-1.92a4.12 4.12 0 00-2.42-.68c-3.07 0-4.66 2.63-4.66 6.74 0 4.47 1.7 6.73 4.5 6.73zM27.7 28.34h-3.5c1.1-2.79 1.23-6.82 1.23-9.57v-.24h2.26v9.8zm8.21-9.96c1.17 0 1.54 1.64 1.54 3.87h-3.36c.13-2.34.58-3.87 1.82-3.87z"></path></svg>
                                                    </a>
                                                    <a href="https://yandex.ru/collections/"
                                                       class="logo-feed" target="_blank"
                                                       data-c="click.main.logo">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="86" height="44" fill="currentColor" class="turbo-header__logo-svg"><path d="M8.03 30H9.5L3.66 19.99l5.36-8.58H7.77l-5.43 8.68v-8.68h-1.3V30h1.3v-9.8l5.7 9.8zm6.24.26c2.26 0 4-2.55 4-6.89 0-4.5-1.74-6.73-4-6.73s-4 2.52-4 6.89c0 4.47 1.74 6.73 4 6.73zm0-.99c-1.54 0-2.78-1.74-2.78-5.82 0-3.98 1.24-5.8 2.78-5.8 1.53 0 2.78 1.69 2.78 5.8 0 3.95-1.25 5.82-2.78 5.82zm7.66-3.82c.2-2.05.36-7.6.36-7.6h3.17V30h1.22V16.9h-5.46s-.2 6.31-.36 8.42c-.18 2.37-.68 3.64-1.48 3.64-.42 0-.57-.08-.57-.08l.1 1.1s.23.1.52.1c1.72 0 2.18-1.67 2.5-4.63zm9.47 0c.2-2.05.36-7.6.36-7.6h3.17V30h1.22V16.9H30.7s-.2 6.31-.36 8.42c-.18 2.37-.68 3.64-1.48 3.64-.42 0-.57-.08-.57-.08l.1 1.1s.23.1.52.1c1.72 0 2.18-1.67 2.5-4.63zm8.2-1.79h5.92c.42-4.66-1.04-7.02-3.3-7.02-2.21 0-3.82 2.52-3.82 6.8 0 4.3 1.27 6.82 4.05 6.82 2.08 0 3.07-1.48 3.07-1.48l-.39-.99s-.9 1.4-2.65 1.4c-1.9 0-2.83-1.95-2.89-5.53zm2.62-6.01c1.33 0 2.37 1.56 2.16 5.04h-4.76c.1-3.27 1.22-5.04 2.6-5.04zm6.83 5.56L53.6 30h1.36l-4.63-7.02 4.32-6.08h-1.2l-4.4 6.16V16.9h-1.22V30h1.23v-6.79zm15.55 9.36v-3.56h-1.2V16.9h-1.22V29h-4.4V16.9h-1.21V30h6.91l.16 2.57h.96zM72.58 30h1.17V16.9h-1.07l-4.26 9.2c-.26.57-.52 1.14-.7 1.74h-.08c.05-.57.1-1.14.1-1.84v-9.1H66.6V30h1.04l4.26-9.23a11 11 0 00.7-1.69h.08c-.05.55-.1 1.12-.1 1.8V30zm10.1 0h1.17V16.9H82.8l-4.27 9.2c-.26.57-.52 1.14-.7 1.74h-.08c.05-.57.1-1.14.1-1.84v-9.1H76.7V30h1.04l4.27-9.23c.28-.57.52-1.12.7-1.69h.08c-.06.55-.1 1.12-.1 1.8V30z"></path></svg>
                                                    </a></div>
                                            </div>

                                            <div class="yandex-search__actions yandex-search__actions_the-feed">
                                                <a
                                                        class="button button_size_M button_type_clear button_ei button_head button_head_favorites button_icon-only header-favorites-button"
                                                        data-c="click.main/loc=head" data-navigate="true"
                                                        href="https://yandex.ru/collections/" target="_blank">
                                                    <svg fill="#8c92a6" width="24" height="24">
                                                        <path d="M5.46 7h10.08c.26 0 .46.22.46.5v12.67c0 .27-.2.5-.46.5a.43.43 0 0 1-.25-.09L10.5 17.1l-4.79 3.48a.43.43 0 0 1-.63-.13.53.53 0 0 1-.08-.28V7.5c0-.28.2-.5.46-.5z"></path>
                                                        <path fill-opacity=".65"
                                                              d="M17 6H7.5a.5.5 0 0 1-.5-.5v-1c0-.28.22-.5.5-.5h11c.28 0 .5.22.5.5v13a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5V6z"></path>
                                                    </svg>
                                                </a>
                                                <a class="button button_size_M button_type_clear button_ei button_head button_head_favorites button_icon-only yandex-search-action"
                                                   data-navigate="true"
                                                   href="#">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                         viewBox="0 0 24 24" fill="none">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                              d="M16.5 7.0625C16.5 10.2579 14.5714 13 12 13C9.42855 13 7.49998 10.2579 7.49998 7.0625C7.49998 3.86714 9.15966 2 12 2C14.8403 2 16.5 3.86714 16.5 7.0625ZM4.10205 20.1429C4.48743 20.6006 6.14457 22 12 22C17.8554 22 19.5125 20.6006 19.8979 20.1429C19.9729 20.0539 20.0004 19.942 19.9888 19.8262C19.8998 18.9436 19.1048 15 12 15C4.89519 15 4.10015 18.9436 4.01119 19.8262C3.99951 19.942 4.02705 20.0539 4.10205 20.1429Z"
                                                              fill="#8c92a6"></path>
                                                    </svg>
                                                </a>
                                            </div>

                                            <div class="counters_statistics">
                                                <a class="underlined" data-toggle="collapse" href="#counters_statistics_{{loop.index}}" aria-expanded="false" aria-controls="counters_statistics_{{loop.index}}">
                                                  counters statistics
                                                </a>
                                                <div class="collapse" id="counters_statistics_{{loop.index}}">
                                                    <div class="card-text">
                                                        <pre>{% for item in path_stats[loop.index - 1]: %}{{item[0]}} {{item[1]}}
{% endfor %}</pre>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {% for event in session: %}
                                    {% with idx=loop.index %}
                                        {% include 'card.tpl' %}
                                    {% endwith %}
                                {% endfor %}
                            </div>
                        </div>
                    </div>
                </div>
                {% endfor %}
            </div>
            {% else: %}
            <p>Нет сессий :(</p>
            {% endif %}
        </div>
    </div>

    <hr>

    <footer>
        <p>&copy; Yandex TheFeed 2019</p>
    </footer>
</div> <!-- /container -->

<script src="{{ base_href }}js/vendor/jquery-1.11.2.min.js"></script>
<script src="{{ base_href }}js/vendor/bootstrap.4.3.1.min.js"></script>
<script src="{{ base_href }}js/main.js"></script>
</body>
</html>
