#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    files as nfl,
    with_hints,
    extended_schema,
    multischema,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    filters as sf
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import itertools

# https://hitman.yandex-team.ru/projects/edinoe_izbrannoe/EI_Stats_MMA_1923

@with_hints(
    output_schema=dict(
        notif_type=str,
        notif_service=str,
        fielddate=str
    )
)

def add_totals_v3(recs):
    for rec in recs:
        for pair in itertools.product(
                (rec.notif_type, '_total_'),
                (rec.notif_service, '_total_'),
                (rec.fielddate, )
                ):
            yield Record(
                notif_type = pair[0],
                notif_service = pair[1],
                fielddate = pair[2]
                )

# https://clubs.at.yandex-team.ru/yt/2642
@cli.statinfra_job

def make_job(job, nirvana, statface_client, options):

    job = job.env(
        yt_spec_defaults=dict(pool_trees=["physical"], tentative_pool_trees=["cloud"]),
        templates=dict(
            job_root=nirvana.directories[0]
        )
    )

    report5 = ns.StatfaceReport() \
        .path('Notifier/Counters/NotificationBlockCreated') \
        .scale('daily') \
        .client(statface_client)

    mydates = options.dates

    for strdate in mydates:

        notifier_events = job.table('//statbox/ydisk-notifier-events-log/'+strdate) \
            .filter(sf.defined('record_type', 'service', 'lifecycle_stage')) \
            .filter(nf.and_(nf.equals("lifecycle_stage", "notification_block_created"),
                            nf.not_(nf.equals("service", "tracker"))
                )) \
            .project(
                notif_type=ne.custom(lambda x: x.replace("_male","").replace("_female",""), 'record_type').add_hints(type=str),
                notif_service='service',
                fielddate=ne.const(strdate).add_hints(type=str)) \
            .map(add_totals_v3) \
            .groupby('fielddate', 'notif_type', 'notif_service') \
            .aggregate(count = na.count()) \
            .put("$job_root/backend_process_data").publish(report5, allow_change_job=True)

#        click_show1m = click_show1.groupby('fielddate', 'notif_type', 'notif_service') \
#            .aggregate(clicks = na.sum('clicks'), shows = na.sum('shows'))
#        notifier_events.join(click_show1m, by=('fielddate', 'notif_type', 'notif_service'), type='full') \
#            .project(ne.all(), convers1 = ne.custom(lambda a, b: 100.0*a/b, 'shows', 'count').add_hints(type=float)) \
#            .put("$job_root/notification_block_created_ctr")# \
#            .publish(report5, allow_change_job=True)

    return job


if __name__ == '__main__':
    cli.run()

