#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    files as nfl,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    filters as sf,
    resources as sr
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import datetime
import time
import re
import ast
import urllib


# https://hitman.yandex-team.ru/projects/edinoe_izbrannoe/EI_Stats_MMA_1923

@with_hints(
    output_schema=dict(
        ui=str,
        long_clicks=int,
        shows=int,
        long_clicks_dau=int,
        shows_dau=int
    )
)
def replace_none(recs):
    for rec in recs:
        try:
            long_clicks = rec.long_clicks
        except:
            long_clicks = 0
        try:
            shows = rec.shows
        except:
            shows = 0
        try:
            long_clicks_dau = rec.long_clicks_dau
        except:
            long_clicks_dau = 0
        try:
            shows_dau = rec.shows_dau
        except:
            shows_dau = 0
        yield Record(ui=rec.ui, long_clicks=long_clicks, shows=shows, long_clicks_dau=long_clicks_dau, shows_dau=shows_dau)


@cli.statinfra_job

def make_job(job, nirvana, statface_client, options):

    job = job.env(
        yt_spec_defaults=dict(
            pool_trees=["physical"], tentative_pool_trees=["cloud"]
        ),
        templates=dict(
            job_root=nirvana.directories[0],
            tmp_root='//home/lego/tmp'
        )
    )

    report4 = ns.StatfaceReport() \
        .path('Notifier/Counters/StatsWAU') \
        .scale('daily') \
        .client(statface_client)

    mydates = options.dates

    for strdate in mydates:

        dau_shows = job.table('$job_root/notif_uids_' + strdate) \
            .groupby('ui') \
            .aggregate(shows_dau=na.count_distinct('uid'))
        dau_long_clicks = job.table('$job_root/user_actions_' + strdate) \
            .filter(sf.equals('clong', 1)) \
            .groupby('ui') \
            .aggregate(long_clicks_dau=na.count_distinct('uid'))


        base = datetime.datetime.strptime(strdate, '%Y-%m-%d').date()
        week = [(base - datetime.timedelta(days=x)).strftime('%Y-%m-%d') for x in range(0, 7)]

        shows = [job.table('$job_root/notif_uids_' + date, ignore_missing=True) for date in week]
        wau_shows = job.concat(*shows) \
            .groupby('ui') \
            .aggregate(shows=na.count_distinct('uid'))

        long_clicks = [job.table('$job_root/user_actions_' + date, ignore_missing=True) for date in week]
        wau_long_clicks = job.concat(*long_clicks).filter(sf.equals('clong', 1)) \
            .groupby('ui').aggregate(long_clicks=na.count_distinct('uid'))


        wau_long_clicks.join(wau_shows, by='ui', type='full') \
            .join(dau_long_clicks, by='ui', type='full') \
            .join(dau_shows, by='ui', type='full') \
            .map(replace_none) \
            .project(ne.all(), fielddate=ne.const(strdate)) \
            .publish(report4, allow_change_job=True)


    return job


if __name__ == '__main__':
    cli.run()

