#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    files as nfl,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    filters as sf,
    resources as sr
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface
import argparse #obligatory for Statface
import getpass #obligatory for Statface
import datetime
import time
import re
import ast
import urllib


# https://hitman.yandex-team.ru/projects/edinoe_izbrannoe/EI_Stats_MMA_1923

# https://yql.yandex-team.ru/Operations/W8CwbPvJNSJoBpI9BIMuDt7B12PtDhG_xUpFbu_rksA=

@with_hints(
    output_schema=dict(
        notif_type=str,
        notif_service=str,
        fielddate=str
    )
)

def add_totals_v3(recs):
    for rec in recs:
        yield rec

        yield Record(notif_type = rec.notif_type,
                    notif_service = "_total_",
                    fielddate = rec.fielddate)

        yield Record(notif_type = "_total_",
                    notif_service = rec.notif_service,
                    fielddate = rec.fielddate)

        yield Record(notif_type = "_total_",
                    notif_service = "_total_",
                    fielddate = rec.fielddate)


# https://clubs.at.yandex-team.ru/yt/2642
@cli.statinfra_job

def make_job(job, nirvana, statface_client, options):

    job = job.env(
        yt_spec_defaults=dict(
            pool_trees=["physical"], tentative_pool_trees=["cloud"]
        ),
        templates=dict(
            job_root=nirvana.directories[0],
            tmp_root='//home/images/tmp'
        )
    )

    report = ns.StatfaceReport() \
        .path('Notifier/Counters/NotificationBlockCreated') \
        .scale('daily') \
        .client(statface_client)

    mydates = options.dates

    for strdate in mydates:
        log = job.table('//statbox/ydisk-notifier-events-log/'+strdate) \
            .filter(sf.defined('record_type', 'service', 'lifecycle_stage')) \
            .filter(nf.equals("lifecycle_stage", "notification_block_created")) \
            .project(
                notif_type=ne.custom(lambda x: x.replace("_male","").replace("_female",""), 'record_type').add_hints(type=str),
                notif_service='service',
                fielddate=ne.const(strdate).add_hints(type=str)) \
            .map(add_totals_v3) \
            .groupby('fielddate', 'notif_type', 'notif_service') \
            .aggregate(count = na.count()) \
            .publish(report, allow_change_job=True)

    return job


if __name__ == '__main__':
    cli.run()

