#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    files as nfl,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne
)
from qb2.api.v1 import (
    QB2,
    filters as sf,
    extractors as se,
    resources as sr
)
from qb2.api.v1.typing import Optional, Json, String

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface


# https://clubs.at.yandex-team.ru/yt/2642
@cli.statinfra_job

def make_job(job, nirvana, options):

    job = job.env(
        yt_spec_defaults=dict(pool_trees=["physical"], tentative_pool_trees=["cloud"]),
        templates=dict(
            job_root=nirvana.directories[0]
        )
    )

    mydates = options.dates

    for strdate in mydates:

        browser_data = job.table('//logs/bs-watch-log/1d/' + strdate) \
            .qb2(log = 'bs-watch-log', fields=['yandexuid', 'puid'], filters=[sf.defined('puid')]) \
            .unique('yandexuid', 'puid') \
            .project(ne.all(exclude='yandexuid'), uid='yandexuid')

        data = job.table('$job_root/data_clicks/clicks_' + strdate)
        data.join(browser_data, by='uid') \
            .put('$job_root/data_clicks/' + strdate,
                schema = dict(recordid=str, ugc_id=Optional[String], path=str, notif_service=str, notif_type=str, puid=str, uid=str, timestamp=int))

    return job


if __name__ == '__main__':
    cli.run()

