#!/usr/bin/env python
# -*- coding: utf-8 -*-

from nile.api.v1 import (
    Record,
    files,
    clusters,
    cli,
    files as nfl,
    with_hints,
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns #obligatory for Statface
)
from qb2.api.v1 import (
    QB2,
    filters as sf,
    resources as sr
)

import os #obligatory for Statface
import sys #obligatory for Statface
import re #obligatory for Statface

@cli.statinfra_job

def make_job(job, nirvana, statface_client, options):

    job = job.env(
        yt_spec_defaults=dict(
            pool_trees=["physical"], tentative_pool_trees=["cloud"]
        ),
        templates=dict(
            job_root=nirvana.directories[0]
        )
    )

    report2 = ns.StatfaceReport() \
        .path('Notifier/Counters/NotifierClicksStatsV2Conversion') \
        .scale('daily') \
        .client(statface_client)

    d = options.dates[-1]

    longclicks = job.table('$job_root/NotifierClicksStatsV2Conversion').filter(sf.not_(sf.equals("page_to", "target")))
    longclicks_tot = job.table("$job_root/user_actions_v2_" + d)

    # CTR
    lc = longclicks.project(ne.all(),
            ctr_long = ne.custom(lambda a, b: 100.0*a/b, 'hits_long', 'hits').add_hints(type=float),
            ctr_overlong = ne.custom(lambda a, b: 100.0*a/b, 'hits_overlong', 'hits').add_hints(type=float))

    # выделим в отдельную таблицу общую статистику по всем нотификациям
    cl_ctr_other, cl_ctr_totals = lc.split(nf.equals("notif_type","_total_"))

    # Exclusion CTR
    cl_ctr_totals2 = cl_ctr_totals \
        .project("ui", "page_to", "page_from", "fielddate", tot = "hits", tot_long = "hits_long", tot_overlong = "hits_overlong")

    df = cl_ctr_totals2.join(cl_ctr_other, by=("ui", "page_to", "page_from", "fielddate")) \
        .filter(nf.custom(lambda a, b: a != b, 'hits', 'tot')) \
        .project(ne.all(),
            ctr_long_minus = ne.custom(lambda a, b, c, d: 100.0*(c - a)/(d - b), 'hits_long', 'hits', 'tot_long', 'tot').add_hints(type=float),
            ctr_overlong_minus = ne.custom(lambda a, b, c, d: 100.0*(c - a)/(d - b), 'hits_overlong', 'hits', 'tot_overlong', 'tot').add_hints(type=float)) \
        .project(ne.all(exclude=("tot", "tot_long", "tot_overlong")))

    # добить таблицу строками с notif_type=="_total_" & service=="_total_", для которых "ctr_long_minus"=="ctr_long", чтобы не было пустот
    new_df = cl_ctr_totals.project(ne.all(), ctr_long_minus = 'ctr_long', ctr_overlong_minus = 'ctr_overlong').concat(df)

    # Get 2 weeks data # нужна статистика за 2 недели по волатильности, считаем общую по каждому 'ui'
    w2 = job.table('$job_root/NotifierClicksStatsV2Conversion1')
    outliers = w2.groupby('ui') \
        .aggregate(ctr_long_lb = na.quantile("ctr_long", 0.25), ctr_long_ub = na.quantile("ctr_long", 0.90)) \
        .project(ne.all(), fielddate = ne.const(d + " 00:00:00"))

    # Load all these data
    new_df.join(outliers, by=("ui", "fielddate")) \
        .publish(report2, allow_change_job=True)


    return job

if __name__ == '__main__':
    cli.run()

