#!/usr/bin/env python
# coding: utf-8

import os
import json
import jinja2
from datetime import datetime
from urlparse import urlparse
from collections import defaultdict, Counter

import sys

reload(sys)
sys.setdefaultencoding("utf-8")

BASE_HREF = 'https://pages.github.yandex-team.ru/nerevar/feed_sessions_viewer/'
# BASE_HREF = 'http://127.0.0.1:8080/'


def format_timestamp(timestamp, format='%Y-%m-%d %H:%M'):
    date = datetime.fromtimestamp(timestamp)
    return date.strftime(format)


def get_domain(url):
    parsed_uri = urlparse(url)
    return parsed_uri.hostname


def get_card_preview(card):
    # STUB_IMAGE_URL = '/img/stub.png'
    # STUB_IMAGE_URL = 'data:image/svg+xml;charset=UTF-8,%3Csvg%20width%3D%22348%22%20height%3D%22225%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20viewBox%3D%220%200%20348%20225%22%20preserveAspectRatio%3D%22none%22%3E%3Cdefs%3E%3Cstyle%20type%3D%22text%2Fcss%22%3E%23holder_16b47c9d373%20text%20%7B%20fill%3A%23eceeef%3Bfont-weight%3Abold%3Bfont-family%3AArial%2C%20Helvetica%2C%20Open%20Sans%2C%20sans-serif%2C%20monospace%3Bfont-size%3A17pt%20%7D%20%3C%2Fstyle%3E%3C%2Fdefs%3E%3Cg%20id%3D%22holder_16b47c9d373%22%3E%3Crect%20width%3D%22348%22%20height%3D%22225%22%20fill%3D%22%2355595c%22%3E%3C%2Frect%3E%3Cg%3E%3Ctext%20x%3D%22116.71875%22%20y%3D%22120.15%22%3EThumbnail%3C%2Ftext%3E%3C%2Fg%3E%3C%2Fg%3E%3C%2Fsvg%3E'
    STUB_IMAGE_URL = ''
    if 'card_log_info' not in card:
        # TODO: поддержать все виды карточек
        return STUB_IMAGE_URL

    # Коллекции
    if get_card_type(card) == 'card':
        if 'sessions_viewer_data' not in card['card_log_info']:
            return STUB_IMAGE_URL

        return 'https://avatars.mds.yandex.net/get-pdb/{}/{}/preview'.format(
            card['card_log_info']['sessions_viewer_data']['card_document']['content'][0]['content']['group_id'],
            card['card_log_info']['sessions_viewer_data']['card_document']['content'][0]['content']['avatars_key'],
        )
    elif get_card_type(card) == 'link':
        thumb_url = card.get('card_log_info', {}).get('sessions_viewer_data', {}).get('web_card_info', {}).get('image')
        if thumb_url:
            if 'tub-com.yandex.net/i?id=' in thumb_url:
                thumb_url += '&n=13'
            return thumb_url
        else:
            return STUB_IMAGE_URL

    # TODO: news, images

    return STUB_IMAGE_URL


def get_card_url(card):
    STUB_PAGE_URL = 'https://yandex.ru'

    if card.get('page_url'):
        return card.get('page_url')

    return STUB_PAGE_URL


def get_card_snippet(card):
    if card.get('card_log_info', {}).get('type') == 'link':
        return card.get('card_log_info', {}).get('sessions_viewer_data', {}).get('web_card_info', {}).get('snippet')


def get_card_type(card):
    return 'user_recent' if card['card_id'] == 'user_recent' else card.get('card_log_info', {}).get('type', 'unknown')


def get_card_template_date(card):
    url = get_card_url(card)

    data = {
        'type': get_card_type(card),
        'title': card['title'],
        'snippet': get_card_snippet(card),
        'card_preview': get_card_preview(card),
        'url': url,
        'domain': get_domain(url),
    }

    if get_card_type(card) == 'card' and card.get('card_log_info'):
        data['card_url'] = 'https://yandex.ru/collections/card/{}/'.format(card['card_log_info']['id'])

    return data


def init_template():
    loader = jinja2.FileSystemLoader('templates')
    env = jinja2.Environment(autoescape=True, loader=loader)
    env.filters['format_timestamp'] = format_timestamp
    return env.get_template('index.tpl')


def calc_feed_stats(feed):
    cards = feed.get('cards', [])
    feed_stats = defaultdict(float)
    feed_stats['cards'] = len(cards)

    click_types = defaultdict(Counter)
    card_types = Counter()

    for card in cards:
        card_type = get_card_type(card)
        card_types[card_type] += 1

        clicks = card.get('clicks', [])
        for click in clicks:
            click_types[click['path']][card_type] += 1
            click_types[click['path']]['all'] += 1
        #
        #     feed_stats['click_{}'.format(click['path'])] += 1
        # if clicks:
        #     feed_stats['clicks'] += len(clicks)
        #     feed_stats['clicks_{}'.format(get_card_type(card))] += len(clicks)

    feed_stats['click_types'] = sorted(click_types.items(), key=lambda x: (x[1].get('all', 0), x[0]), reverse=True)
    feed_stats['card_types'] = card_types.most_common()
    feed_stats['card_types_index'] = [x[0] for x in card_types.most_common()]

    # for path, cnt in sorted(feed_stats['clicks'].items(), key=lambda x: x[1].get('all', 0), reverse=True):
    #     print path, cnt.get('all', 0)


    return feed_stats


def get_user_feeds_template_data(user_feeds):
    uid = user_feeds[0]['uid']

    for feed in user_feeds:
        feed['feed_stats'] = calc_feed_stats(feed)
        for card in feed.get('cards', []):
            card['template_data'] = get_card_template_date(card)

    user_info = user_feeds[0].get('user_info', {})
    user_info_template_data = {}
    if user_info and user_info.get('sessions_viewer_data'):
        user_info_template_data['collections_stats'] = json.dumps(user_info.get('stats', {}))
        user_info_template_data['web_urls'] = sorted(user_info['sessions_viewer_data'].get('web_urls', {}).items(), key=lambda x: x[1], reverse=True)
        user_info_template_data['crypta_data'] = json.dumps(user_info['sessions_viewer_data'].get('exact_socdem'))
        user_info_template_data[
            'favicon_image'] = 'https://favicon.yandex.net/favicon/{}?size=16&color=255%2C255%2C255%2C0&stub=1'.format(
            '/'.join([x[0] for x in user_info_template_data['web_urls'][:20]])
        )

    return {
        'base_href': BASE_HREF,
        'uid': uid,
        'user_info_template_data': user_info_template_data,
        'feeds': user_feeds,
    }


def save_html(uid, html):
    filename = 'sessions/y{}.html'.format(uid)
    if not os.path.exists(os.path.dirname(filename)):
        try:
            os.makedirs(os.path.dirname(filename))
        except OSError:
            pass
    with open(filename, 'w') as f:
        f.write(html)


def calc_feeds_stats(user_feeds):
    shows = defaultdict(int)
    clicks = defaultdict(int)
    for feed in user_feeds:
        for card_type, cnt in feed['feed_stats']['card_types']:
            shows[card_type] += cnt
        for path, counter in feed['feed_stats']['click_types']:
            for card_type, cnt in counter.items():
                clicks[card_type] += cnt

    return dict(
        shows=shows,
        clicks=clicks
    )


def make_htmls(feeds):
    template = init_template()

    users = defaultdict(list)

    for feed in feeds:
        users[feed['uid']].append(feed)

    f = open('index.html', 'w')
    f.write("""<!doctype html>
<html class="no-js" lang="">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>TheLenta Sessions Viewer</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="{BASE_HREF}css/bootstrap.4.3.1.min.css">
    <link rel="stylesheet" href="{BASE_HREF}css/main.css">
    <script src="{BASE_HREF}js/vendor/jquery-1.11.2.min.js"></script>
    <script src="{BASE_HREF}js/vendor/bootstrap.4.3.1.min.js"></script>
    <script src="{BASE_HREF}js/main.js"></script>
</head>
<body>
    <table class="table stats_table">
    <thead>
        <tr>
            <th scope="col">#</th>
            <th scope="col">yuid</th>
            <th scope="col">сессий</th>
            <th scope="col">web clicks</th>
            <th scope="col">web shows</th>
            <th scope="col">news clicks</th>
            <th scope="col">news shows</th>
            <th scope="col">collections clicks</th>
            <th scope="col">collections shows</th>
            <th scope="col">images clicks</th>
            <th scope="col">images shows</th>
        </tr>
    </thead>
    <tbody>
    """.format(BASE_HREF=BASE_HREF))

    for idx, (uid, user_feeds) in enumerate(users.iteritems()):
        template_data = get_user_feeds_template_data(user_feeds)
        html = template.render(template_data)
        save_html(uid, html)

        user_stats = calc_feeds_stats(user_feeds)

        f.write("""
        <tr>
            <th scope="row">{idx}</th>
            <td><a href="sessions/y{yuid}.html" target="_blank">y{yuid}</a></td>
            <td>{feeds_len}</td>
            <td>{clicks_web}</td>
            <td>{shows_web}</td>
            <td>{clicks_news}</td>
            <td>{shows_news}</td>
            <td>{clicks_collections}</td>
            <td>{shows_collections}</td>
            <td>{clicks_images}</td>
            <td>{shows_images}</td>
        </tr>
        """.format(
            idx=(idx+1),
            yuid=uid,
            feeds_len=len(user_feeds),
            clicks_web=user_stats['clicks'].get('link', ''),
            shows_web=user_stats['shows'].get('link', ''),
            clicks_news=user_stats['clicks'].get('news', ''),
            shows_news=user_stats['shows'].get('news', ''),
            clicks_collections=user_stats['clicks'].get('collection', ''),
            shows_collections=user_stats['shows'].get('collection', ''),
            clicks_images=user_stats['clicks'].get('image', ''),
            shows_images=user_stats['shows'].get('image', ''),
        ))

    f.write("""
    </tbody>
    </table>
    </html>
    """)

    f.close()


def main(args):
    feeds = args['in1']

    make_htmls(feeds)

    return []
