<div class="row">
    <div class="col-md-8">
        <div class="card mb-2 box-shadow">
            <div class="card-body">

                <div class="card__title">
                    {% if card['template_data']['type'] == 'user_recent' %}
                    Мои добавленные карточки
                    {% else: %}
                    {{ card['template_data']['title'] }}
                    {% endif %}
                </div>
                {% if card['template_data']['snippet'] %}
                <p class="card-text">{{ card['template_data']['snippet'] }}</p>
                {% endif %}

                {% if card['template_data']['type'] != 'user_recent' and card['template_data']['card_preview'] %}
                <div class="card__preview"
                     style="background-image: url('{{ card['template_data']['card_preview'] }}')">
                     </div>
                {% endif %}

                <div class="card__bottom mt-4 d-flex justify-content-between align-items-center">
                    {% if card['template_data']['type'] == 'user_recent' %}
                    <span>Последние добавленные</span>
                    {% else: %}
                    <a href="{{ card['template_data']['url'] }}" class="card__domain" target="_blank">{{ card['template_data']['domain'] }}</a>
                    {% endif %}

                    <div class="btn-group">
                        <span class="button_card button_card_check">
                            <span class="button__icon"></span>
                        </span>
                        <span class="button_card button_card_like">
                            <span class="button__icon"></span>
                        </span>
                        <span class="button_card button_card_dislike">
                            <span class="button__icon"></span>
                        </span>
                        <span class="button_card button_card_kebab">
                            <span class="button__icon"></span>
                        </span>

                        <small class="text-muted">
                            {% if card['template_data']['card_url'] %}
                            <a href="{{ card['template_data']['card_url'] }}" target="_blank">{{ card['template_data']['type'] }}</a>
                            {% else: %}
                                        {{ card['template_data']['type'] }}
                                    {% endif %}
                        </small>
                    </div>

        </div>
    </div>
</div>
</div>
<div class="col-md-4">
{% if card['clicks']|length %}
<h4>clicks:</h4>

<ul class="list-group">
    {% for click in card['clicks'] %}
    <li class="">
        {{ click['path']}}
        <small>{{ click['timestamp']|format_timestamp('%H:%M:%S') }}</small>
    </li>
    {% endfor %}
</ul>
{% endif %}
</div>
</div>