<!doctype html>
<html class="no-js" lang="">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>TheLenta Sessions Viewer</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="stylesheet" href="{{ base_href }}css/bootstrap.4.3.1.min.css">
    <link rel="stylesheet" href="{{ base_href }}css/main.css">
</head>
<body>

<nav class="navbar navbar-expand-md navbar-dark bg-dark fixed-top">
    <a class="navbar-brand" href="/">TheLenta Sessions Viewer</a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault"
            aria-controls="navbarsExampleDefault" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>
</nav>

<main role="main" class="container">

</main><!-- /.container -->

<!-- Main jumbotron for a primary marketing message or call to action -->
<div class="jumbotron">
    <div class="container">
        <h1>y{{ uid }}</h1>

        {% if user_info_template_data['crypta_data'] %}
        <p>{{ user_info_template_data['crypta_data'] }}</p>
        {% endif %}

        {% if user_info_template_data['collections_stats'] %}
        <p>{{ user_info_template_data['collections_stats'] }}</p>
        {% endif %}
    </div>
</div>

<div class="container">
    <!-- Example row of columns -->
    <div class="row">
        <div class="col-md-4">
            {% if user_info_template_data['web_urls']: %}
            <ul class="list-group list-group-flush">
                <li class="list-group-item active">
                    <h4>User Web History</h4>
                </li>
                {% for domain, cnt in user_info_template_data['web_urls'] %}
                <li class="list-group-item">
                        <div class="favicon__icon"
                             style="background-position: 0px {{ - (loop.index-1) * 16 }}px; background-image: url({{ user_info_template_data['favicon_image'] }})"></div>
                        {{ domain }}, {{ cnt }}
                </li>
                {% endfor %}
            </ul>
            {% endif %}
        </div>
        <div class="col-md-8">

            {% if feeds|length: %}
            <div class="accordion feedsAccordion" id="feedsAccordion">
                <div class="card">
                    <div class="card-header list-group-item active">
                        <h4 class="mb-0">
                            User feeds
                        </h4>
                    </div>
                </div>
                {% for feed in feeds: %}
                <div class="card">
                    <div class="card-header" id="heading_{{loop.index}}">
                        <h2 class="mb-0">
                            <button class="btn btn-link collapsed" type="button"
                                    data-toggle="collapse" data-target="#session_{{loop.index}}"
                                    aria-expanded="true" aria-controls="#session_{{loop.index}}">
                                {{ feed['timestamp']|format_timestamp }}, feed_session_id: {{ feed['feed_session_id']
                                }} <span class="glyphicon glyphicon-chevron-down"
                                                                          aria-hidden="true"></span>
                            </button>
                        </h2>

                        <table class="table table-hover table-sm table-bordered">
                            <thead>
                            <tr>
                                <th scope="col">Cards:</th>
                                <th scope="col" class="text-center">all {{ feed['feed_stats']['cards'] }}:</th>
                                {% for card_type, cnt in feed['feed_stats']['card_types']: %}
                                <th scope="col" class="text-center">{{ card_type }} {{ cnt }}</th>
                                {% endfor %}
                            </tr>
                            </thead>
                            {% if feed['feed_stats']['click_types']: %}
                            <tbody>
                            {% for path, stats in feed['feed_stats']['click_types']: %}
                            <tr>
                                <td>{{ path }}</td>
                                <td class="text-center"><b>{{ stats['all'] }}</b></td>
                                {% for card_type, cnt in feed['feed_stats']['card_types']: %}
                                <td class="text-center">{{ stats.get(card_type, '') }}</td>
                                {% endfor %}
                            </tr>
                            {% endfor %}
                            </tbody>
                            {% endif %}
                        </table>


                    </div>

                    <div id="session_{{loop.index}}" class="card-body-wrapper collapse" aria-labelledby="heading_{{loop.index}}"
                         data-parent="#feedsAccordion">
                        <div class="card-body feed-body">

                            <div class="container">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="card mb-4 box-shadow">

                                            <div class="yandex-search__logo">
                                                <div class="yandex-search__feed-link">
                                                    <a href="https://yandex.ru" target="_blank"
                                                       class="logo-yandex">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="69" height="38">
                                                            <path fill="red"
                                                                  d="M9.35 21.43v8.68h2.44V7.45H8.15c-3.59 0-6.6 2.38-6.6 7.13 0 3.39 1.33 5.23 3.33 6.25L.63 30.11h2.83l3.86-8.68zm0-2.03h-1.3c-2.12 0-3.87-1.17-3.87-4.82 0-3.77 1.91-5.07 3.87-5.07h1.3z"></path>
                                                            <path d="M36.26 28.09H35V14.14h-7.42v1.36c0 4.25-.16 9.19-1.62 12.59h-.98v5.16h2.22v-3.14h6.85v3.14h2.21zm10.75.95l-.57-1.9c-.63.44-1.74 1.07-3.14 1.07-1.96 0-2.98-1.9-2.98-5.51h6.66v-1.37c0-5.42-1.74-7.41-4.41-7.41-3.39 0-4.82 3.74-4.82 8.87 0 4.92 2.03 7.55 5.33 7.55 1.59 0 2.92-.51 3.93-1.3zm-25.9-14.9v6.78h-3.68v-6.78h-2.47v15.97h2.47v-7.16h3.68v7.16h2.44V14.14zM56.2 30.11h2.7l-4.53-8.46 3.96-7.51h-2.51l-3.83 7.38v-7.38h-2.47v15.97h2.47v-7.95zm8.5.23c1.46 0 2.47-.48 3.33-1.21l-.57-1.84c-.57.51-1.49.99-2.7.99-1.99 0-2.95-2.29-2.95-6.28 0-4.03 1.27-6.02 3.05-6.02 1.01 0 1.96.54 2.63 1.11l.35-2.35c-.7-.44-1.52-.82-2.95-.82-3.74 0-5.67 3.2-5.67 8.21 0 5.45 2.06 8.21 5.48 8.21zm-32.14-2.25h-4.25c1.33-3.4 1.49-8.31 1.49-11.67v-.28h2.76zm10.01-12.14c1.43 0 1.87 1.99 1.87 4.72h-4.09c.16-2.85.7-4.72 2.22-4.72z"></path>
                                                        </svg>
                                                    </a>
                                                    <a href="https://yandex.ru/collections/the-feed/?mobile=1"
                                                       class="logo-feed" target="_blank"
                                                       data-c="click.main.logo">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="57" height="38">
                                                            <path d="M4.91 8.75h4.85v21.36h1.59V7.45h-7.8c0 .86-.06 9.79-.7 16.83-.25 3.05-.82 4.44-2.12 4.44-.22 0-.35-.03-.35-.03l.1 1.49s.15.06.53.06c1.94 0 2.92-1.68 3.27-5.83.6-7.2.63-15 .63-15.66zM15.5 22.38h7.23c.51-5.67-1.27-8.56-4.03-8.56-2.69 0-4.66 3.08-4.66 8.31s1.56 8.3 4.95 8.3c2.53 0 3.74-1.8 3.74-1.8l-.48-1.21s-1.11 1.71-3.23 1.71c-2.31 0-3.46-2.38-3.52-6.75zm3.2-7.32c1.62 0 2.89 1.9 2.63 6.15h-5.8c.13-4 1.49-6.15 3.17-6.15zm13.79 15.05h1.49V14.14h-1.49v7.07h-5.45v-7.07h-1.49v15.97h1.49v-7.7h5.45zm12.78-14.74v-1.23h-8.88v1.23h3.71v14.74h1.49V15.37zm5.23 13.86c-1.52 0-2.51-1.3-2.51-3.55 0-2.79 1.27-4 3.9-4h1.71v4.41c-.57 1.71-1.61 3.14-3.1 3.14zm3.55.88h1.36c-.19-.6-.35-1.83-.35-2.94v-8.72c0-3.17-1.49-4.63-4.12-4.63-1.81 0-3.14.79-3.77 1.62l.41 1.42c.76-1.11 2-1.74 3.36-1.74 1.75 0 2.66 1.05 2.66 3.49v1.99h-1.74c-3.45 0-5.32 1.78-5.32 5.2 0 2.92 1.49 4.63 3.64 4.63 1.59 0 2.73-.95 3.49-2.47.09 1.14.25 1.74.38 2.15z"></path>
                                                        </svg>
                                                    </a></div>
                                            </div>

                                            <div class="yandex-search__actions yandex-search__actions_the-feed">
                                                <a
                                                        class="button button_size_M button_type_clear button_ei button_head button_head_favorites button_icon-only header-favorites-button"
                                                        data-c="click.main/loc=head" data-navigate="true"
                                                        href="https://yandex.ru/collections/" target="_blank">
                                                    <svg fill="#8c92a6" width="24" height="24">
                                                        <path d="M5.46 7h10.08c.26 0 .46.22.46.5v12.67c0 .27-.2.5-.46.5a.43.43 0 0 1-.25-.09L10.5 17.1l-4.79 3.48a.43.43 0 0 1-.63-.13.53.53 0 0 1-.08-.28V7.5c0-.28.2-.5.46-.5z"></path>
                                                        <path fill-opacity=".65"
                                                              d="M17 6H7.5a.5.5 0 0 1-.5-.5v-1c0-.28.22-.5.5-.5h11c.28 0 .5.22.5.5v13a.5.5 0 0 1-.5.5h-1a.5.5 0 0 1-.5-.5V6z"></path>
                                                    </svg>
                                                </a>
                                                <a class="button button_size_M button_type_clear button_ei button_head button_head_favorites button_icon-only yandex-search-action"
                                                   data-navigate="true"
                                                   href="#">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                         viewBox="0 0 24 24" fill="none">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                              d="M16.5 7.0625C16.5 10.2579 14.5714 13 12 13C9.42855 13 7.49998 10.2579 7.49998 7.0625C7.49998 3.86714 9.15966 2 12 2C14.8403 2 16.5 3.86714 16.5 7.0625ZM4.10205 20.1429C4.48743 20.6006 6.14457 22 12 22C17.8554 22 19.5125 20.6006 19.8979 20.1429C19.9729 20.0539 20.0004 19.942 19.9888 19.8262C19.8998 18.9436 19.1048 15 12 15C4.89519 15 4.10015 18.9436 4.01119 19.8262C3.99951 19.942 4.02705 20.0539 4.10205 20.1429Z"
                                                              fill="#8c92a6"></path>
                                                    </svg>
                                                </a>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-8">
                                    <div class="card mb-4 box-shadow">
                                        <div class="card-body">
                                            {{ feed['feed_url'] }}
                                        </div>
                                    </div>
                                </div>

                                {% for card in feed.get('cards', []): %}
                                {% include 'card.tpl' %}
                                {% endfor %}
                            </div>
                        </div>
                    </div>
                </div>
                {% endfor %}
            </div>
            {% else: %}
            <p>Нет сессий :(</p>
            {% endif %}
        </div>
    </div>

    <hr>

    <footer>
        <p>&copy; Yandex TheFeed 2019</p>
    </footer>
</div> <!-- /container -->

<script src="{{ base_href }}js/vendor/jquery-1.11.2.min.js"></script>
<script src="{{ base_href }}js/vendor/bootstrap.4.3.1.min.js"></script>
<script src="{{ base_href }}js/main.js"></script>
</body>
</html>
