# coding: utf-8

from analytics.plotter_lib.plotter import Plot, require, DATE_FORMAT
from nile.api.v1 import (
    Record,
    with_hints,
    aggregators as na,
    filters as nf,
)


def get_card_origin_ui(client, ui):
    """
    Определяет платформу добавления карточки
    IMAGESUI-11463, https://stat.yandex-team.ru/-/CKDsJ6pJ
    """
    if not ui:
        ui = ''
    if not client:
        client = ''

    if 'desktop' in ui:
        return 'desktop'
    if 'searchplugin' in client or 'ru.yandex.mobile' in client or client == 'yandexsearch':
        return 'yandexApp'
    if 'touch' in ui:
        return 'mobile'
    if 'pad' in ui:
        return 'tablet'
    if ui == 'common':
        return 'common'

    if not ui and (client == 'lego' or client == 'yabrowser'):
        # lego и yabrowser без ui относим к десктопам
        return 'desktop'
    return 'empty'


@with_hints(output_schema={  # noqa
    'fielddate': str,
    'other': int,
    'collections_fetch_upload_image_desktop': int,
    'collections_fetch_upload_link_desktop': int,
    'collections_fetch_upload_product_desktop': int,
    'collections_fetch_upload_other_desktop': int,
    'collections_fetch_upload_image_touch': int,
    'collections_fetch_upload_link_touch': int,
    'collections_fetch_upload_product_touch': int,
    'collections_fetch_upload_other_touch': int,
    'collections_fetch_upload_other': int,
    'collections_share_desktop': int,
    'collections_share_touch': int,
    'collections_share_other': int,
    'lego_image_desktop': int,
    'lego_image_touch': int,
    'lego_image_other': int,
    'lego_video_desktop': int,
    'lego_video_touch': int,
    'lego_video_other': int,
    'lego_serp_other_desktop': int,
    'lego_serp_link_desktop': int,
    'lego_serp_touch': int,
    'lego_serp_other': int,
    'pp_ios_image': int,
    'pp_ios_link': int,
    'pp_ios_other': int,
    'pp_android_image': int,
    'pp_android_link': int,
    'pp_android_other': int,
    'yabrowser_image_desktop': int,
    'yabrowser_link_desktop': int,
    'yabrowser_video_desktop': int,
    'yabrowser_other_desktop': int,
    'yabrowser_image_touch_ios': int,
    'yabrowser_link_touch_ios': int,
    'yabrowser_other_touch_ios': int,
    'yabrowser_image_touch_android': int,
    'yabrowser_link_touch_android': int,
    'yabrowser_other_touch_android': int,
    'yabrowser_other': int,
    'plugin_image': int,
    'plugin_video': int,
    'plugin_link': int,
    'plugin_other': int
})
def cards_by_origin_mapper(recs):
    for rec in recs:
        outrec = {
            'fielddate': rec.card_created_at_date,
            'other': 0,
            'collections_fetch_upload_image_desktop': 0,
            'collections_fetch_upload_link_desktop': 0,
            'collections_fetch_upload_product_desktop': 0,
            'collections_fetch_upload_other_desktop': 0,
            'collections_fetch_upload_image_touch': 0,
            'collections_fetch_upload_link_touch': 0,
            'collections_fetch_upload_product_touch': 0,
            'collections_fetch_upload_other_touch': 0,
            'collections_fetch_upload_other': 0,
            'collections_share_desktop': 0,
            'collections_share_touch': 0,
            'collections_share_other': 0,
            'lego_image_desktop': 0,
            'lego_image_touch': 0,
            'lego_image_other': 0,
            'lego_video_desktop': 0,
            'lego_video_touch': 0,
            'lego_video_other': 0,
            'lego_serp_other_desktop': 0,
            'lego_serp_link_desktop': 0,
            'lego_serp_touch': 0,
            'lego_serp_other': 0,
            'pp_ios_image': 0,
            'pp_ios_link': 0,
            'pp_ios_other': 0,
            'pp_android_image': 0,
            'pp_android_link': 0,
            'pp_android_other': 0,
            'yabrowser_image_desktop': 0,
            'yabrowser_link_desktop': 0,
            'yabrowser_video_desktop': 0,
            'yabrowser_other_desktop': 0,
            'yabrowser_image_touch_ios': 0,
            'yabrowser_link_touch_ios': 0,
            'yabrowser_other_touch_ios': 0,
            'yabrowser_image_touch_android': 0,
            'yabrowser_link_touch_android': 0,
            'yabrowser_other_touch_android': 0,
            'yabrowser_other': 0,
            'plugin_image': 0,
            'plugin_video': 0,
            'plugin_link': 0,
            'plugin_other': 0
        }

        if rec.card_origin_client_name == 'collections' and rec.card_origin_action in ('fetch', 'upload'):
            if isinstance(rec.card_origin_client_ui, str) and 'desktop' in rec.card_origin_client_ui:
                if rec.card_meta_info_type == 'product':
                    outrec['collections_fetch_upload_product_desktop'] = 1
                elif rec.card_source_type == 'image':
                    outrec['collections_fetch_upload_image_desktop'] = 1
                elif rec.card_source_type == 'link':
                    outrec['collections_fetch_upload_link_desktop'] = 1
                else:
                    outrec['collections_fetch_upload_other_desktop'] = 1
            elif isinstance(rec.card_origin_client_ui, str) and 'touch' in rec.card_origin_client_ui:
                if rec.card_meta_info_type == 'product':
                    outrec['collections_fetch_upload_product_touch'] = 1
                if rec.card_source_type == 'image':
                    outrec['collections_fetch_upload_image_touch'] = 1
                elif rec.card_source_type == 'link':
                    outrec['collections_fetch_upload_link_touch'] = 1
                else:
                    outrec['collections_fetch_upload_other_touch'] = 1
            else:
                outrec['collections_fetch_upload_other'] = 1
        elif rec.card_origin_client_name == 'collections' and rec.card_origin_action == 'share':
            if isinstance(rec.card_origin_client_ui, str) and 'desktop' in rec.card_origin_client_ui:
                outrec['collections_share_desktop'] = 1
            elif isinstance(rec.card_origin_client_ui, str) and 'touch' in rec.card_origin_client_ui:
                outrec['collections_share_touch'] = 1
            else:
                outrec['collections_share_other'] = 1
        elif rec.card_origin_client_name == 'lego':
            if rec.card_source_type == 'image':
                if isinstance(rec.card_origin_client_ui, str) and 'desktop' in rec.card_origin_client_ui:
                    outrec['lego_image_desktop'] = 1
                elif isinstance(rec.card_origin_client_ui, str) and 'touch' in rec.card_origin_client_ui:
                    outrec['lego_image_touch'] = 1
                else:
                    outrec['lego_image_other'] = 1
            elif rec.card_source_type == 'video':
                if isinstance(rec.card_origin_client_ui, str) and 'desktop' in rec.card_origin_client_ui:
                    outrec['lego_video_desktop'] = 1
                elif isinstance(rec.card_origin_client_ui, str) and 'touch' in rec.card_origin_client_ui:
                    outrec['lego_video_touch'] = 1
                else:
                    outrec['lego_video_other'] = 1
            else:
                if isinstance(rec.card_origin_client_ui, str) and 'desktop' in rec.card_origin_client_ui:
                    if rec.card_source_type == 'link':
                        outrec['lego_serp_link_desktop'] = 1
                    else:
                        outrec['lego_serp_other_desktop'] = 1
                elif isinstance(rec.card_origin_client_ui, str) and 'touch' in rec.card_origin_client_ui:
                    outrec['lego_serp_touch'] = 1
                else:
                    outrec['lego_serp_other'] = 1
        elif rec.card_origin_client_name in ('ru.yandex.mobile', 'ru.yandex.mobile.dev', 'ru.yandex.mobile.inhouse', 'yandexsearch'):
            if rec.card_source_type == 'image':
                outrec['pp_ios_image'] = 1
            elif rec.card_source_type == 'link':
                outrec['pp_ios_link'] = 1
            else:
                outrec['pp_ios_other'] = 1
        elif rec.card_origin_client_name in ('ru.yandex.searchplugin', 'ru.yandex.searchplugin.beta', 'ru.yandex.searchplugin.dev', 'ru.yandex.searchplugin.nightly'):
            if rec.card_source_type == 'image':
                outrec['pp_android_image'] = 1
            elif rec.card_source_type == 'link':
                outrec['pp_android_link'] = 1
            else:
                outrec['pp_android_other'] = 1
        elif rec.card_origin_client_name == 'yabrowser':
            if isinstance(rec.card_origin_client_ui, str) and 'desktop' in rec.card_origin_client_ui:
                if rec.card_source_type == 'link':
                    outrec['yabrowser_link_desktop'] = 1
                elif rec.card_source_type == 'image':
                    outrec['yabrowser_image_desktop'] = 1
                elif rec.card_source_type == 'video':
                    outrec['yabrowser_video_desktop'] = 1
                else:
                    outrec['yabrowser_other_desktop'] = 1
            elif isinstance(rec.card_origin_client_ui, str) and 'touch.android' in rec.card_origin_client_ui:
                if rec.card_source_type == 'image':
                    outrec['yabrowser_image_touch_android'] = 1
                elif rec.card_source_type == 'link':
                    outrec['yabrowser_link_touch_android'] = 1
                else:
                    outrec['yabrowser_other_touch_android'] = 1
            elif isinstance(rec.card_origin_client_ui, str) and 'touch.ios' in rec.card_origin_client_ui:
                if rec.card_source_type == 'image':
                    outrec['yabrowser_image_touch_ios'] = 1
                elif rec.card_source_type == 'link':
                    outrec['yabrowser_link_touch_ios'] = 1
                else:
                    outrec['yabrowser_other_touch_ios'] = 1
            else:
                outrec['yabrowser_other'] = 1
        elif rec.card_origin_client_name == 'plugin':
            if rec.card_source_type == 'image':
                outrec['plugin_image'] = 1
            elif rec.card_source_type == 'video':
                outrec['plugin_video'] = 1
            elif rec.card_source_type == 'link':
                outrec['plugin_link'] = 1
            else:
                outrec['plugin_other'] = 1
        else:
            outrec['other'] = 1

        yield Record.from_dict(outrec)


class CardMetrics(Plot):
    @require('PrepCards.without_bookmarks')
    def cards_by_origin(self, streams):
        date_start = self.date.strftime(DATE_FORMAT)
        date_end = self.dateend.strftime(DATE_FORMAT)

        cards = streams['PrepCards.without_bookmarks'].filter(nf.custom(lambda cdt: cdt <= date_end, 'card_created_at_date'))

        public_card_origin = cards \
            .filter(nf.equals('card_is_private', False)) \
            .map(cards_by_origin_mapper) \
            .groupby('fielddate') \
            .aggregate(
                other=na.sum('other'),
                collections_fetch_upload_image_desktop=na.sum('collections_fetch_upload_image_desktop'),
                collections_fetch_upload_link_desktop=na.sum('collections_fetch_upload_link_desktop'),
                collections_fetch_upload_product_desktop=na.sum('collections_fetch_upload_product_desktop'),
                collections_fetch_upload_other_desktop=na.sum('collections_fetch_upload_other_desktop'),
                collections_fetch_upload_image_touch=na.sum('collections_fetch_upload_image_touch'),
                collections_fetch_upload_link_touch=na.sum('collections_fetch_upload_link_touch'),
                collections_fetch_upload_product_touch=na.sum('collections_fetch_upload_product_touch'),
                collections_fetch_upload_other_touch=na.sum('collections_fetch_upload_other_touch'),
                collections_fetch_upload_other=na.sum('collections_fetch_upload_other'),
                collections_share_desktop=na.sum('collections_share_desktop'),
                collections_share_touch=na.sum('collections_share_touch'),
                collections_share_other=na.sum('collections_share_other'),
                lego_image_desktop=na.sum('lego_image_desktop'),
                lego_image_touch=na.sum('lego_image_touch'),
                lego_image_other=na.sum('lego_image_other'),
                lego_video_desktop=na.sum('lego_video_desktop'),
                lego_video_touch=na.sum('lego_video_touch'),
                lego_video_other=na.sum('lego_video_other'),
                lego_serp_link_desktop=na.sum('lego_serp_link_desktop'),
                lego_serp_other_desktop=na.sum('lego_serp_other_desktop'),
                lego_serp_touch=na.sum('lego_serp_touch'),
                lego_serp_other=na.sum('lego_serp_other'),
                pp_ios_image=na.sum('pp_ios_image'),
                pp_ios_link=na.sum('pp_ios_link'),
                pp_ios_other=na.sum('pp_ios_other'),
                pp_android_image=na.sum('pp_android_image'),
                pp_android_link=na.sum('pp_android_link'),
                pp_android_other=na.sum('pp_android_other'),
                yabrowser_image_desktop=na.sum('yabrowser_image_desktop'),
                yabrowser_link_desktop=na.sum('yabrowser_link_desktop'),
                yabrowser_video_desktop=na.sum('yabrowser_video_desktop'),
                yabrowser_other_desktop=na.sum('yabrowser_other_desktop'),
                yabrowser_image_touch_ios=na.sum('yabrowser_image_touch_ios'),
                yabrowser_link_touch_ios=na.sum('yabrowser_link_touch_ios'),
                yabrowser_other_touch_ios=na.sum('yabrowser_other_touch_ios'),
                yabrowser_image_touch_android=na.sum('yabrowser_image_touch_android'),
                yabrowser_link_touch_android=na.sum('yabrowser_link_touch_android'),
                yabrowser_other_touch_android=na.sum('yabrowser_other_touch_android'),
                yabrowser_other=na.sum('yabrowser_other'),
                plugin_image=na.sum('plugin_image'),
                plugin_video=na.sum('plugin_video'),
                plugin_link=na.sum('plugin_link'),
                plugin_other=na.sum('plugin_other')
            ) \
            .filter(nf.custom(lambda fd: fd >= date_start, 'fielddate')) \
            .publish(self.get_statface_report('Collections/Metrics/public_card_origin_count'), allow_change_job=True)
        yield 'public_card_origin', public_card_origin

        card_origin = cards \
            .map(cards_by_origin_mapper) \
            .groupby('fielddate') \
            .aggregate(
                other=na.sum('other'),
                collections_fetch_upload_image_desktop=na.sum('collections_fetch_upload_image_desktop'),
                collections_fetch_upload_link_desktop=na.sum('collections_fetch_upload_link_desktop'),
                collections_fetch_upload_product_desktop=na.sum('collections_fetch_upload_product_desktop'),
                collections_fetch_upload_other_desktop=na.sum('collections_fetch_upload_other_desktop'),
                collections_fetch_upload_image_touch=na.sum('collections_fetch_upload_image_touch'),
                collections_fetch_upload_link_touch=na.sum('collections_fetch_upload_link_touch'),
                collections_fetch_upload_product_touch=na.sum('collections_fetch_upload_product_touch'),
                collections_fetch_upload_other_touch=na.sum('collections_fetch_upload_other_touch'),
                collections_fetch_upload_other=na.sum('collections_fetch_upload_other'),
                collections_share_desktop=na.sum('collections_share_desktop'),
                collections_share_touch=na.sum('collections_share_touch'),
                collections_share_other=na.sum('collections_share_other'),
                lego_image_desktop=na.sum('lego_image_desktop'),
                lego_image_touch=na.sum('lego_image_touch'),
                lego_image_other=na.sum('lego_image_other'),
                lego_video_desktop=na.sum('lego_video_desktop'),
                lego_video_touch=na.sum('lego_video_touch'),
                lego_video_other=na.sum('lego_video_other'),
                lego_serp_link_desktop=na.sum('lego_serp_link_desktop'),
                lego_serp_other_desktop=na.sum('lego_serp_other_desktop'),
                lego_serp_touch=na.sum('lego_serp_touch'),
                lego_serp_other=na.sum('lego_serp_other'),
                pp_ios_image=na.sum('pp_ios_image'),
                pp_ios_link=na.sum('pp_ios_link'),
                pp_ios_other=na.sum('pp_ios_other'),
                pp_android_image=na.sum('pp_android_image'),
                pp_android_link=na.sum('pp_android_link'),
                pp_android_other=na.sum('pp_android_other'),
                yabrowser_image_desktop=na.sum('yabrowser_image_desktop'),
                yabrowser_link_desktop=na.sum('yabrowser_link_desktop'),
                yabrowser_video_desktop=na.sum('yabrowser_video_desktop'),
                yabrowser_other_desktop=na.sum('yabrowser_other_desktop'),
                yabrowser_image_touch_ios=na.sum('yabrowser_image_touch_ios'),
                yabrowser_link_touch_ios=na.sum('yabrowser_link_touch_ios'),
                yabrowser_other_touch_ios=na.sum('yabrowser_other_touch_ios'),
                yabrowser_image_touch_android=na.sum('yabrowser_image_touch_android'),
                yabrowser_link_touch_android=na.sum('yabrowser_link_touch_android'),
                yabrowser_other_touch_android=na.sum('yabrowser_other_touch_android'),
                yabrowser_other=na.sum('yabrowser_other'),
                plugin_image=na.sum('plugin_image'),
                plugin_video=na.sum('plugin_video'),
                plugin_link=na.sum('plugin_link'),
                plugin_other=na.sum('plugin_other')
            ) \
            .filter(nf.custom(lambda fd: fd >= date_start, 'fielddate')) \
            .publish(self.get_statface_report('Collections/Metrics/card_origin'), allow_change_job=True)
        yield 'card_origin', card_origin

    @require('PrepCards.organic_cards_without_spam')
    def good_cards_by_origin(self, streams):
        date_start = self.date.strftime(DATE_FORMAT)
        date_end = self.dateend.strftime(DATE_FORMAT)

        good_cards = streams['PrepCards.organic_cards_without_spam'] \
            .filter(nf.custom(lambda cdt: cdt <= date_end, 'card_created_at_date'))

        open_card_origin_without_spam = good_cards \
            .filter(nf.equals('card_is_private', False)) \
            .map(cards_by_origin_mapper) \
            .groupby('fielddate') \
            .aggregate(
                other=na.sum('other'),
                collections_fetch_upload_image_desktop=na.sum('collections_fetch_upload_image_desktop'),
                collections_fetch_upload_link_desktop=na.sum('collections_fetch_upload_link_desktop'),
                collections_fetch_upload_product_desktop=na.sum('collections_fetch_upload_product_desktop'),
                collections_fetch_upload_other_desktop=na.sum('collections_fetch_upload_other_desktop'),
                collections_fetch_upload_image_touch=na.sum('collections_fetch_upload_image_touch'),
                collections_fetch_upload_link_touch=na.sum('collections_fetch_upload_link_touch'),
                collections_fetch_upload_product_touch=na.sum('collections_fetch_upload_product_touch'),
                collections_fetch_upload_other_touch=na.sum('collections_fetch_upload_other_touch'),
                collections_fetch_upload_other=na.sum('collections_fetch_upload_other'),
                collections_share_desktop=na.sum('collections_share_desktop'),
                collections_share_touch=na.sum('collections_share_touch'),
                collections_share_other=na.sum('collections_share_other'),
                lego_image_desktop=na.sum('lego_image_desktop'),
                lego_image_touch=na.sum('lego_image_touch'),
                lego_image_other=na.sum('lego_image_other'),
                lego_video_desktop=na.sum('lego_video_desktop'),
                lego_video_touch=na.sum('lego_video_touch'),
                lego_video_other=na.sum('lego_video_other'),
                lego_serp_link_desktop=na.sum('lego_serp_link_desktop'),
                lego_serp_other_desktop=na.sum('lego_serp_other_desktop'),
                lego_serp_touch=na.sum('lego_serp_touch'),
                lego_serp_other=na.sum('lego_serp_other'),
                pp_ios_image=na.sum('pp_ios_image'),
                pp_ios_link=na.sum('pp_ios_link'),
                pp_ios_other=na.sum('pp_ios_other'),
                pp_android_image=na.sum('pp_android_image'),
                pp_android_link=na.sum('pp_android_link'),
                pp_android_other=na.sum('pp_android_other'),
                yabrowser_image_desktop=na.sum('yabrowser_image_desktop'),
                yabrowser_link_desktop=na.sum('yabrowser_link_desktop'),
                yabrowser_video_desktop=na.sum('yabrowser_video_desktop'),
                yabrowser_other_desktop=na.sum('yabrowser_other_desktop'),
                yabrowser_image_touch_ios=na.sum('yabrowser_image_touch_ios'),
                yabrowser_link_touch_ios=na.sum('yabrowser_link_touch_ios'),
                yabrowser_other_touch_ios=na.sum('yabrowser_other_touch_ios'),
                yabrowser_image_touch_android=na.sum('yabrowser_image_touch_android'),
                yabrowser_link_touch_android=na.sum('yabrowser_link_touch_android'),
                yabrowser_other_touch_android=na.sum('yabrowser_other_touch_android'),
                yabrowser_other=na.sum('yabrowser_other'),
                plugin_image=na.sum('plugin_image'),
                plugin_video=na.sum('plugin_video'),
                plugin_link=na.sum('plugin_link'),
                plugin_other=na.sum('plugin_other')
            ) \
            .filter(nf.custom(lambda fd: fd >= date_start, 'fielddate')) \
            .publish(self.get_statface_report('Collections/Metrics/open_card_origin_without_spam_count'), allow_change_job=True)
        yield 'open_card_origin_without_spam', open_card_origin_without_spam

        card_origin_without_spam = good_cards \
            .map(cards_by_origin_mapper) \
            .groupby('fielddate') \
            .aggregate(
                other=na.sum('other'),
                collections_fetch_upload_image_desktop=na.sum('collections_fetch_upload_image_desktop'),
                collections_fetch_upload_link_desktop=na.sum('collections_fetch_upload_link_desktop'),
                collections_fetch_upload_product_desktop=na.sum('collections_fetch_upload_product_desktop'),
                collections_fetch_upload_other_desktop=na.sum('collections_fetch_upload_other_desktop'),
                collections_fetch_upload_image_touch=na.sum('collections_fetch_upload_image_touch'),
                collections_fetch_upload_link_touch=na.sum('collections_fetch_upload_link_touch'),
                collections_fetch_upload_product_touch=na.sum('collections_fetch_upload_product_touch'),
                collections_fetch_upload_other_touch=na.sum('collections_fetch_upload_other_touch'),
                collections_fetch_upload_other=na.sum('collections_fetch_upload_other'),
                collections_share_desktop=na.sum('collections_share_desktop'),
                collections_share_touch=na.sum('collections_share_touch'),
                collections_share_other=na.sum('collections_share_other'),
                lego_image_desktop=na.sum('lego_image_desktop'),
                lego_image_touch=na.sum('lego_image_touch'),
                lego_image_other=na.sum('lego_image_other'),
                lego_video_desktop=na.sum('lego_video_desktop'),
                lego_video_touch=na.sum('lego_video_touch'),
                lego_video_other=na.sum('lego_video_other'),
                lego_serp_link_desktop=na.sum('lego_serp_link_desktop'),
                lego_serp_other_desktop=na.sum('lego_serp_other_desktop'),
                lego_serp_touch=na.sum('lego_serp_touch'),
                lego_serp_other=na.sum('lego_serp_other'),
                pp_ios_image=na.sum('pp_ios_image'),
                pp_ios_link=na.sum('pp_ios_link'),
                pp_ios_other=na.sum('pp_ios_other'),
                pp_android_image=na.sum('pp_android_image'),
                pp_android_link=na.sum('pp_android_link'),
                pp_android_other=na.sum('pp_android_other'),
                yabrowser_image_desktop=na.sum('yabrowser_image_desktop'),
                yabrowser_link_desktop=na.sum('yabrowser_link_desktop'),
                yabrowser_video_desktop=na.sum('yabrowser_video_desktop'),
                yabrowser_other_desktop=na.sum('yabrowser_other_desktop'),
                yabrowser_image_touch_ios=na.sum('yabrowser_image_touch_ios'),
                yabrowser_link_touch_ios=na.sum('yabrowser_link_touch_ios'),
                yabrowser_other_touch_ios=na.sum('yabrowser_other_touch_ios'),
                yabrowser_image_touch_android=na.sum('yabrowser_image_touch_android'),
                yabrowser_link_touch_android=na.sum('yabrowser_link_touch_android'),
                yabrowser_other_touch_android=na.sum('yabrowser_other_touch_android'),
                yabrowser_other=na.sum('yabrowser_other'),
                plugin_image=na.sum('plugin_image'),
                plugin_video=na.sum('plugin_video'),
                plugin_link=na.sum('plugin_link'),
                plugin_other=na.sum('plugin_other')
            ) \
            .filter(nf.custom(lambda fd: fd >= date_start, 'fielddate')) \
            .publish(self.get_statface_report('Collections/Metrics/card_origin_without_spam_count'), allow_change_job=True)
        yield 'card_origin_without_spam', card_origin_without_spam
