# coding: utf-8


from analytics.plotter_lib.utils import AddTotalsMapper, PrecomputeTotalsMapper, DATE_FORMAT
from analytics.plotter_lib.plotter import Plot, require
from nile.api.v1 import (
    with_hints,
    extended_schema,
    extractors as ne,
    aggregators as na,
    filters as nf,
)


class CardCommonMetrics(Plot):
    @require('Cards.parsed')
    def calculate_cards_report(self, streams):
        REPORT_KEY_FIELDS = (
            'fielddate', 'is_browser_bookmark', 'is_private', 'is_product', 'source_type', 'origin_client_name',
            'origin_client_ui', 'origin_action', 'meta_info_type'
        )
        date_start = self.date.strftime(DATE_FORMAT)
        date_end = self.dateend.strftime(DATE_FORMAT)

        cards_stream = streams['Cards.parsed'] \
            .project(
                fielddate='card_created_at_date',
                is_browser_bookmark=ne.custom(lambda x: str(x) if isinstance(x, bool) else 'empty', 'card_is_browser_bookmark').with_type(str),
                is_private=ne.custom(lambda x: str(x) if isinstance(x, bool) else 'empty', 'card_is_private').with_type(str),
                is_product=ne.custom(lambda x: str(x), 'card_is_product').with_type(str),
                source_type=ne.custom(lambda x: x if (isinstance(x, str) and x) else 'empty', 'card_source_type').with_type(str),
                origin_client_name=ne.custom(lambda x: x if (isinstance(x, str) and x) else 'empty', 'card_origin_client_name').with_type(str),
                origin_client_ui=ne.custom(lambda x: x if (isinstance(x, str) and x) else 'empty', 'card_origin_client_ui').with_type(str),
                origin_action=ne.custom(lambda x: x if (isinstance(x, str) and x) else 'empty', 'card_origin_action').with_type(str),
                meta_info_type=ne.custom(lambda x: x if (isinstance(x, str) and x) else 'empty', 'card_meta_info_type').with_type(str)
            ) \
            .filter(nf.custom(lambda x: date_start <= x <= date_end, 'fielddate')) \
            .sort(*REPORT_KEY_FIELDS) \
            .map(
                with_hints(output_schema=extended_schema(cards=int))(
                    PrecomputeTotalsMapper(REPORT_KEY_FIELDS, 'cards')
                ),
                ordered=True
            ) \
            .map(
                with_hints(output_schema=extended_schema())(
                    AddTotalsMapper(REPORT_KEY_FIELDS, ['fielddate', 'cards'])
                )
            ) \
            .groupby(*REPORT_KEY_FIELDS) \
            .aggregate(cards=na.sum('cards'))

        return self.publish(cards_stream, self.get_statface_report('Collections/Metrics/cards/CardsCommonReportV4'),
                            allow_change_job=True)
