# coding: utf-8

from analytics.plotter_lib.plotter import Plot, require
from nile.api.v1 import (
    Record,
    with_hints,
    aggregators as na,
)


@with_hints(output_schema={  # noqa
    'fielddate': str,
    'any_session_with_cards_count': int,
    'any_session_without_cards_count': int,
    'click_link_recent_session_with_cards_count': int,
    'click_profile_session_with_cards_count': int,
    'editing_session_with_cards_count': int,
    'add_card_session_with_cards_count': int,
    'feed_interaction_session_with_cards_count': int,
    'empty_session_with_cards_count': int,
    'click_link_recent_session_without_cards_count': int,
    'click_profile_session_without_cards_count': int,
    'editing_session_without_cards_count': int,
    'add_card_session_without_cards_count': int,
    'feed_interaction_session_without_cards_count': int,
    'empty_session_without_cards_count': int
})
def desktop_browser_favorites_sessions_reducer(groups):
    for key, recs in groups:
        outrec = {
            'fielddate': key.fielddate,
            'any_session_with_cards_count': 0,
            'any_session_without_cards_count': 0,
            'click_link_recent_session_with_cards_count': 0,
            'click_profile_session_with_cards_count': 0,
            'editing_session_with_cards_count': 0,
            'add_card_session_with_cards_count': 0,
            'feed_interaction_session_with_cards_count': 0,
            'empty_session_with_cards_count': 0,
            'click_link_recent_session_without_cards_count': 0,
            'click_profile_session_without_cards_count': 0,
            'editing_session_without_cards_count': 0,
            'add_card_session_without_cards_count': 0,
            'feed_interaction_session_without_cards_count': 0,
            'empty_session_without_cards_count': 0
        }

        click_link_recent_session = False
        click_profile_session = False
        editing_session = False
        add_card_session = False
        feed_interaction_session = False

        is_browser_favorite = False
        with_cards = False

        last_ts = 0
        for rec in recs:
            if not isinstance(rec.timestamp, int) or not isinstance(rec.url, str):
                continue
            if rec.timestamp - last_ts > 30 * 60:
                if is_browser_favorite:
                    if with_cards:
                        if click_link_recent_session:
                            outrec['click_link_recent_session_with_cards_count'] += 1
                        if click_profile_session:
                            outrec['click_profile_session_with_cards_count'] += 1
                        if editing_session:
                            outrec['editing_session_with_cards_count'] += 1
                        if add_card_session:
                            outrec['add_card_session_with_cards_count'] += 1
                        if feed_interaction_session:
                            outrec['feed_interaction_session_with_cards_count'] += 1
                        if not click_link_recent_session and not click_profile_session and not editing_session and not add_card_session and not feed_interaction_session:
                            outrec['empty_session_with_cards_count'] += 1
                        outrec['any_session_with_cards_count'] += 1
                    else:
                        if click_link_recent_session:
                            outrec['click_link_recent_session_without_cards_count'] += 1
                        if click_profile_session:
                            outrec['click_profile_session_without_cards_count'] += 1
                        if editing_session:
                            outrec['editing_session_without_cards_count'] += 1
                        if add_card_session:
                            outrec['add_card_session_without_cards_count'] += 1
                        if feed_interaction_session:
                            outrec['feed_interaction_session_without_cards_count'] += 1
                        if not click_link_recent_session and not click_profile_session and not editing_session and not add_card_session and not feed_interaction_session:
                            outrec['empty_session_without_cards_count'] += 1
                        outrec['any_session_without_cards_count'] += 1

                click_link_recent_session = False
                click_profile_session = False
                editing_session = False
                add_card_session = False
                feed_interaction_session = False

                is_browser_favorite = False
                with_cards = False

            last_ts = rec.timestamp

            if rec.path == 'access' and rec.traffic_source == 'bro_desktop':
                is_browser_favorite = True
                try:
                    with_cards = int(rec.s_cards) > 0
                except:
                    with_cards = False

            if not is_browser_favorite:
                continue

            if rec.path == 'click.link_external' and rec.loc == 'userRecent':
                click_link_recent_session = True
            if rec.path == 'access' and rec.page_name == 'profile':
                click_profile_session = True
            if rec.path in ('click.card.move', 'click.card.edit', 'click.card.remove'):
                editing_session = True
            if rec.path in ('finish.card.create', 'finish.card.share'):
                add_card_session = True
            if rec.path in (
                    'click.card', 'click.board', 'click.user', 'click.card.like',
                    'click.card.share') and rec.loc == 'feed':
                feed_interaction_session = True

        if is_browser_favorite:
            if with_cards:
                if click_link_recent_session:
                    outrec['click_link_recent_session_with_cards_count'] += 1
                if click_profile_session:
                    outrec['click_profile_session_with_cards_count'] += 1
                if editing_session:
                    outrec['editing_session_with_cards_count'] += 1
                if add_card_session:
                    outrec['add_card_session_with_cards_count'] += 1
                if feed_interaction_session:
                    outrec['feed_interaction_session_with_cards_count'] += 1
                if not click_link_recent_session and not click_profile_session and not editing_session and not add_card_session and not feed_interaction_session:
                    outrec['empty_session_with_cards_count'] += 1
                outrec['any_session_with_cards_count'] += 1
            else:
                if click_link_recent_session:
                    outrec['click_link_recent_session_without_cards_count'] += 1
                if click_profile_session:
                    outrec['click_profile_session_without_cards_count'] += 1
                if editing_session:
                    outrec['editing_session_without_cards_count'] += 1
                if add_card_session:
                    outrec['add_card_session_without_cards_count'] += 1
                if feed_interaction_session:
                    outrec['feed_interaction_session_without_cards_count'] += 1
                if not click_link_recent_session and not click_profile_session and not editing_session and not add_card_session and not feed_interaction_session:
                    outrec['empty_session_without_cards_count'] += 1
                outrec['any_session_without_cards_count'] += 1

        yield Record.from_dict(outrec)


class DesktopBrowserFavoritesSessions(Plot):
    @require('CollectionsRedirLog.parsed')
    def get_sessions_stats(self, streams):
        return streams['CollectionsRedirLog.parsed'] \
            .groupby('fielddate', 'icookie') \
            .sort('timestamp', 'cts') \
            .reduce(desktop_browser_favorites_sessions_reducer) \
            .groupby('fielddate') \
            .aggregate(
                any_session_with_cards_count=na.sum('any_session_with_cards_count'),
                any_session_without_cards_count=na.sum('any_session_without_cards_count'),
                click_link_recent_session_with_cards_count=na.sum('click_link_recent_session_with_cards_count'),
                click_profile_session_with_cards_count=na.sum('click_profile_session_with_cards_count'),
                editing_session_with_cards_count=na.sum('editing_session_with_cards_count'),
                add_card_session_with_cards_count=na.sum('add_card_session_with_cards_count'),
                feed_interaction_session_with_cards_count=na.sum('feed_interaction_session_with_cards_count'),
                empty_session_with_cards_count=na.sum('empty_session_with_cards_count'),
                click_link_recent_session_without_cards_count=na.sum('click_link_recent_session_without_cards_count'),
                click_profile_session_without_cards_count=na.sum('click_profile_session_without_cards_count'),
                editing_session_without_cards_count=na.sum('editing_session_without_cards_count'),
                add_card_session_without_cards_count=na.sum('add_card_session_without_cards_count'),
                feed_interaction_session_without_cards_count=na.sum('feed_interaction_session_without_cards_count'),
                empty_session_without_cards_count=na.sum('empty_session_without_cards_count')
            ) \
            .publish(self.get_statface_report('Collections/Metrics/desktop_browser_favorites_sessions'), allow_change_job=True)
