# coding: utf-8

import datetime

from analytics.plotter_lib.plotter import Plot, require, DATE_FORMAT
from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne
)


class OpenCollabs(Plot):
    @require('PrepBoards.potential_open_collabs')
    def potential_open_collabs_boards(self, streams):
        calc_date = datetime.datetime.now().strftime(DATE_FORMAT)

        return streams['PrepBoards.potential_open_collabs'] \
            .groupby() \
            .aggregate(value=na.count()) \
            .project('value', fielddate=ne.const(calc_date), metric=ne.const('potential_open_collabs_boards'))

    @require('PrepBoards.potential_open_collabs', 'Cards.parsed')
    def potential_open_collabs_cards_daily(self, streams):
        boards = streams['PrepBoards.potential_open_collabs'] \
            .project('board_id')
        cards = streams['Cards.parsed'] \
            .project(board_id='card_board_id', fielddate='card_created_at_date')

        return boards \
            .join(cards, by='board_id', type='inner') \
            .groupby('fielddate') \
            .aggregate(value=na.count()) \
            .project('value', 'fielddate', metric=ne.const('potential_open_collabs_cards_daily'))

    @require('CollectionsRedirLog.parsed')
    def open_collabs_authors(self, streams):
        return streams['CollectionsRedirLog.parsed'] \
            .filter(nf.and_(nf.equals('path', 'finish.coauthor.button'), nf.equals('type', 'become'))) \
            .groupby('fielddate') \
            .aggregate(value=na.count()) \
            .project('value', 'fielddate', metric=ne.const('open_collabs_authors_daily'))

    @require('PrepBoards.open_collabs')
    def open_collabs_boards(self, streams):
        calc_date = datetime.datetime.now().strftime(DATE_FORMAT)

        return streams['PrepBoards.open_collabs'] \
            .groupby() \
            .aggregate(value=na.count()) \
            .project('value', fielddate=ne.const(calc_date), metric=ne.const('open_collabs_boards'))

    @require('PrepBoards.open_collabs', 'Cards.parsed')
    def open_collabs_cards_daily(self, streams):
        cards = streams['Cards.parsed'] \
            .project(board_id='card_board_id', fielddate='card_created_at_date')

        return streams['PrepBoards.open_collabs'] \
            .project('board_id') \
            .join(cards, by='board_id', type='inner') \
            .groupby('fielddate') \
            .aggregate(value=na.count()) \
            .project('value', 'fielddate', metric=ne.const('open_collabs_cards_daily'))

    @require(
        'OpenCollabs.potential_open_collabs_boards',
        'OpenCollabs.potential_open_collabs_cards_daily',
        'OpenCollabs.open_collabs_authors',
        'OpenCollabs.open_collabs_boards',
        'OpenCollabs.open_collabs_cards_daily'
    )
    def stat(self, streams):
        return self.job.concat(*streams.values()) \
            .publish(self.get_statface_report('Collections/Metrics/collabs/OpenCollabs'), allow_change_job=True)

    @require(
        'PrepBoards.open_collabs',
        'Users.parsed'
    )
    def put_top_by_coauthors(self, streams):
        calc_date = datetime.datetime.now().strftime(DATE_FORMAT)
        return streams['PrepBoards.open_collabs'] \
            .join(
                streams['Users.parsed'].project('user_id', 'user_login'),
                type='inner',
                by_left='board_owner_id',
                by_right='user_id'
            ) \
            .project(
                ne.all(),
                board_url=ne.custom(
                    lambda x, y: 'https://yandex.ru/collections/user/{}/{}/'.format(x, y), 'user_login', 'board_slug'
                ).with_type(str)
            ) \
            .top(100, by='board_coauthors_count') \
            .put('//home/collections/analytics/backups/open_collabs/top_100_by_coauthors/{}'.format(calc_date))
