# coding: utf-8

from analytics.plotter_lib.plotter import Plot, require
from nile.api.v1 import (
    filters as nf,
    extractors as ne,
)
from qb2.api.v1 import (
    filters as qf
)


def get_user_type(user_role, user_labels, toloka_board_owner):
    if 'km' in user_labels or 'km_by_admin' in user_labels:
        return 'km'
    elif 'business' in user_labels:
        return 'company'
    elif user_role == 'redactor':
        return 'redactor'
    elif toloka_board_owner is not None and len(toloka_board_owner) > 0:
        return 'toloker'
    else:
        return 'organic'


class PrepUsers(Plot):
    @require('Users.parsed')
    def banned(self, streams):
        return streams['Users.parsed'] \
            .filter(qf.nonzero('user_ban'))

    @require('Users.parsed', 'PrepBoards.from_toloka')
    def with_organic_flag(self, streams):
        """Возвращает всех пользователей с флажком user_is_organic — True у людей, кто не создавал борды в толоке а также НЕ-редактор"""

        boards_from_toloka = streams['PrepBoards.from_toloka'] \
            .project('board_owner_id') \
            .unique('board_owner_id')

        return streams['Users.parsed'] \
            .join(boards_from_toloka, type='left', by_left='user_id', by_right='board_owner_id') \
            .project(
                ne.all('board_owner_id'),
                user_type=ne.custom(get_user_type, 'user_role', 'user_labels', 'board_owner_id').with_type(str),
                user_is_organic=ne.custom(lambda role, board: True if board is None and role != 'redactor' else False, 'user_role', 'board_owner_id').with_type(bool),
            )

    @require('PrepUsers.with_organic_flag')
    def organics(self, streams):
        """Возвращает данные только органических пользователей"""
        return streams['PrepUsers.with_organic_flag'] \
            .filter(
                nf.and_(
                    nf.equals('user_is_organic', True),
                    nf.custom(lambda x: not x, 'user_ban')
                )
            )
