# coding: utf-8

from analytics.plotter_lib.plotter import Plot, require
from nile.api.v1 import (
    aggregators as na,
    filters as nf,
    extractors as ne
)


class Promo(Plot):
    @require('CollectionsRedirLog.parsed')
    def calculate(self, streams):
        collections_redir_log = streams['CollectionsRedirLog.parsed']

        promo_show_guide = collections_redir_log \
            .groupby('fielddate') \
            .aggregate(
                click_close_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.guide.hide'),
                        nf.equals('key', 'ei_coauthors_recent')
                    )
                ),
                show_count=na.count(
                    nf.and_(
                        nf.equals('path', 'show.guide'),
                        nf.equals('key', 'ei_coauthors_recent')
                    )
                ),
                click_next_count=na.count(
                    nf.and_(
                        nf.equals('path', 'show.guide'),
                        nf.equals('key', 'ei_coauthors_recent')
                    )
                ),
                copy_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.modal.action'),
                        nf.equals('loc', 'coauthor'),
                        nf.equals('type', 'copy')
                    )
                )
            ) \
            .publish(self.get_statface_report('Collections/Metrics/promo/collections_desktop_coauthors_promo_recent'), allow_change_job=True)
        yield 'promo_show_guide', promo_show_guide

        promo_guide_click_next = collections_redir_log \
            .groupby('fielddate') \
            .aggregate(
                click_close_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.guide.hide'),
                        nf.equals('key', 'ei_coauthors_recent')
                    )
                ),
                show_count=na.count(
                    nf.and_(
                        nf.equals('path', 'show.guide'),
                        nf.equals('key', 'ei_coauthors_recent')
                    )
                ),
                click_next_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.guide.next'),
                        nf.equals('key', 'ei_coauthors_recent')
                    )
                ),
                copy_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.modal.action'),
                        nf.equals('loc', 'coauthor'),
                        nf.equals('type', 'copy')
                    )
                )
            ) \
            .publish(self.get_statface_report('Collections/Metrics/promo/collections_desktop_coauthors_promo_recent'), allow_change_job=True)
        yield 'promo_guide_click_next', promo_guide_click_next

        promo_guide_coauthor_invite = collections_redir_log \
            .groupby('fielddate') \
            .aggregate(
                click_close_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.tooltip.action'),
                        nf.equals('tooltip_type', 'coauthorInvite'),
                        nf.equals('action_type', 'close')
                    )
                ),
                show_count=na.count(
                    nf.and_(
                        nf.equals('path', 'show.tooltip'),
                        nf.equals('tooltip_type', 'coauthorInvite')
                    )
                ),
                not_now_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.tooltip.action'),
                        nf.equals('tooltip_type', 'coauthorInvite'),
                        nf.equals('action_type', 'secondary')
                    )
                ),
                invite_count=na.count(
                    nf.and_(
                        nf.equals('path', 'click.tooltip.action'),
                        nf.equals('tooltip_type', 'coauthorInvite'),
                        nf.equals('action_type', 'primary')
                    )
                )
            ) \
            .publish(self.get_statface_report('Collections/Metrics/promo/collections_desktop_coauthors_promo_board'), allow_change_job=True)
        yield 'promo_guide_coauthor_invite', promo_guide_coauthor_invite

        click_tooltip_action = collections_redir_log \
            .filter(nf.equals('path', 'click.tooltip.action')) \
            .project(
                'fielddate',
                'yandexuid',
                tooltip_type=ne.custom(lambda x: x if x else 'empty', 'tooltip_type').with_type(str),
                action_type=ne.custom(lambda x: x if x else 'empty', 'action_type').with_type(str),
            ) \
            .groupby('fielddate', 'tooltip_type', 'action_type') \
            .aggregate(
                users=na.count_distinct('yandexuid'),
                clicks=na.count()
            ) \
            .publish(self.get_statface_report('Collections/Metrics/promo/ClickToolTipAction'), allow_change_job=True)
        yield 'click_tooltip_action', click_tooltip_action
