# coding: utf-8

from analytics.plotter_lib.plotter import Plot, require
from analytics.plotter_lib.utils import AddTotalsMapper, PrecomputeTotalsMapper

from nile.api.v1 import (
    with_hints,
    extended_schema,
    extractors as ne,
    aggregators as na,
)
from qb2.api.v1 import (
    filters as qf,
)


class RedirActions(Plot):
    @require('CollectionsRedirLog.parsed')
    def get_actions_stats(self, streams):
        EMPTY_VALUE = 'empty'
        REPORT_KEY_FIELDS = ('fielddate', 'path', 'ui', 'page_name', 'loc', 'is_owner', 'is_my_company')

        return streams['CollectionsRedirLog.parsed'] \
            .project(
                'fielddate',
                is_my_company=ne.custom(lambda x: x or EMPTY_VALUE, 'is_my_company').with_type(str),
                is_owner=ne.custom(lambda x: x or EMPTY_VALUE, 'is_owner').with_type(str),
                loc=ne.custom(lambda x: x or EMPTY_VALUE, 'loc').with_type(str),
                page_name=ne.custom(lambda x: x or EMPTY_VALUE, 'page_name').with_type(str),
                path=ne.custom(lambda x: x or EMPTY_VALUE, 'path').with_type(str),
                ui=ne.custom(lambda x: x or EMPTY_VALUE, 'ui').with_type(str),
            ) \
            .sort(*REPORT_KEY_FIELDS) \
            .map(
                with_hints(output_schema=extended_schema(hits=int))(
                    PrecomputeTotalsMapper(REPORT_KEY_FIELDS)
                ),
                ordered=True
            ) \
            .map(with_hints(output_schema=extended_schema())(
                AddTotalsMapper(REPORT_KEY_FIELDS, ['fielddate', 'hits'])
            )) \
            .groupby(*REPORT_KEY_FIELDS) \
            .aggregate(
                hits=na.sum('hits')
            ) \
            .publish(self.get_statface_report('Collections/Metrics/social/RedirLogActionsV2'), allow_change_job=True)

    @require('PrepUsers.with_organic_flag', 'CollectionsRedirLog.parsed')
    def get_users_stats(self, streams):
        EMPTY_VALUE = 'empty'
        REPORT_KEY_FIELDS = ['fielddate', 'path', 'ui', 'page_name', 'loc', 'user_type', 'from_company']

        return streams['CollectionsRedirLog.parsed'] \
            .project('user_id', 'fielddate', 'path', 'ui', 'page_name', 'loc') \
            .filter(qf.nonzero('user_id')) \
            .join(
                self.job.concat(
                    streams['PrepUsers.with_organic_flag'].project('user_type', 'user_id', 'user_companies', uid='user_id'),
                    streams['PrepUsers.with_organic_flag'].project('user_type', 'user_companies', user_id='user_login', uid='user_id'),
                ),
                type='left',
                by='user_id'
            ) \
            .project(
                'fielddate',
                user_id=ne.custom(lambda x, y: x if x else y, 'uid', 'user_id').with_type(str),
                user_type=ne.custom(lambda x: x or EMPTY_VALUE, 'user_type').with_type(str),
                loc=ne.custom(lambda x: x or EMPTY_VALUE, 'loc').with_type(str),
                page_name=ne.custom(lambda x: x or EMPTY_VALUE, 'page_name').with_type(str),
                path=ne.custom(lambda x: x or EMPTY_VALUE, 'path').with_type(str),
                ui=ne.custom(lambda x: x or EMPTY_VALUE, 'ui').with_type(str),
                from_company=ne.custom(lambda x: 'true' if x else 'false', 'user_companies').with_type(str)
            ) \
            .map(with_hints(output_schema=extended_schema())(
                AddTotalsMapper(REPORT_KEY_FIELDS + ['user_id'], ['fielddate', 'user_id'])
            )) \
            .unique('user_id', 'user_type', 'path', 'loc', 'page_name', 'fielddate', 'ui', 'from_company') \
            .project(ne.all('user_id')) \
            .groupby(*REPORT_KEY_FIELDS) \
            .aggregate(
                users=na.count()
            ) \
            .publish(self.get_statface_report('Collections/Metrics/social/RedirLogUsersV1'), allow_change_job=True)
