import re
from urlparse import urlparse, parse_qsl
from analytics.collections.plotter_collections.plots.utils import get_collections_page


def parse_cgi_params(url):
    parsed = urlparse(url)
    return dict(parse_qsl(parsed.query, keep_blank_values=True))


YANDEX_DOMAIN_PATTERN = re.compile(
    r'^(www\.)?yandex\.(ru|by|ua|kz|com|com\.tr|com\.am|com\.ge|az|co\.il|kg|lv|lt|md|tj|tm|uz|ee|fr)\/?$'
)


def get_traffic_source(url, referer='', browser=''):  # noqa
    if url is None or url == '':
        return 'no_url'
    if browser is None:
        browser = ''
    if referer is None:
        referer = ''

    referer = referer.strip()
    if referer.startswith('http:') and not referer.startswith('http://'):
        referer = referer.replace('http:', 'http://')

    if referer.startswith('https:') and not referer.startswith('https://'):
        referer = referer.replace('https:', 'https://')

    try:
        url_parsed = urlparse(url)
    except:
        return 'broken_url'

    url_path = url_parsed.path
    url_query_params = parse_cgi_params(url)

    utm_source = url_query_params.get('utm_source', '')
    utm_medium = url_query_params.get('utm_medium', '')
    utm_campaign = url_query_params.get('utm_campaign', '')
    utm_term = url_query_params.get('utm_term', '')
    utm_referer = url_query_params.get('utm_referrer', '')
    from_where = url_query_params.get('from', '')

    referer_parsed = urlparse(referer)
    referer_path = referer_parsed.path or '/'
    referer_domain = referer_parsed.netloc
    referer_query_params = parse_cgi_params(referer)

# UTM-МЕТКИ (по ним считаем в первую очередь)
    if utm_source == 'yandex' and \
       utm_medium == 'serp' and \
       utm_campaign in ('right', 'dynamic', 'static'):
        # Переход из колдунщика Коллекций на серпе (без Просмотрщика)
        return 'serp_kokos'

    # Продвижение Коллекций в Директе
    if utm_source == 'yandex' and utm_medium == 'search':
        return 'yandex_ad'

    if utm_source == 'yandex' and \
       utm_medium == 'from_serpviewer' and \
       utm_campaign in ('right', 'dynamic', 'static'):
        # Переход из просмотрщика Коллекций на серпе в Коллекции
        return 'serp_kokos_viewer'

    if utm_source == 'images' and utm_medium == 'serp' and \
       utm_campaign == '3ko':
        # Переход с врезки Коллекций в поиске по Картинкам
        return 'images_kokoko'

    if utm_source in ('images', 'serp') and utm_medium == 'thumb' and \
       utm_campaign == 'thisimg':
        return 'images_eko'

    if utm_medium == 'header':
        return 'icon_header'

    if utm_medium == 'push':
        return 'push'

    if utm_term == 'collections' and utm_medium == 'notifier':
        return 'bell'

    if utm_medium == 'visited' and not \
       (url_path.startswith('/images/') or url_path.startswith('/images/touch/')):
        return 'visited'

    if utm_source == 'fotki' and not \
       (url_path.startswith('/images/') or url_path.startswith('/images/touch/')) and \
       utm_medium != 'serp':
        return 'fotki'

    if utm_source == 'homescreen':
        return 'utm_source_homescreen'

# Zen
    if utm_source == 'zen_source':
        return 'zen_source'

    if utm_source == 'yamain' and utm_medium == 'informer' and ('zen.yandex.com' in utm_referer or 'zen.yandex' in referer_domain):
        return 'zen_source'

    if 'zen.yandex.com' in utm_referer:
        return 'zen'

    if 'zen.yandex' in referer_domain:
        return 'zen'

# Informers after zen
    if utm_source == 'yandex_app':
        if utm_medium == 'informer' and utm_campaign == 'regular':
            return 'pp_informer'
        if utm_campaign == 'images':
            # TODO: понять, что это такое?
            return 'pp_campaign_images'

    if utm_source == 'yamain' and utm_medium == 'informer' and utm_campaign == 'regular':
        if 'forced_items' in url_query_params.get('rec_flags', ''):
            return 'morda_informer_feed'
        else:
            return 'morda_informer'
# Yandex Browser
    if browser == 'YandexBrowser' and url_path.startswith('/collections/bro/feed'):
        return 'bro_mmorda'

    if browser == 'YandexBrowser' and url_path.startswith('/collections/bro/recent'):
        return 'bro_recent'

    if browser == 'YandexBrowser' and url_path.startswith('/collections/bro/bookmarks'):
        return 'bro_bookmarks'
    if '/collections/?isBrowserFavorites=1' in url or url_path.startswith('/collections/bro'):
        return 'bro_desktop'

# YandexSearchApp
    if browser == 'YandexSearch' and url_path.startswith('/collections/app/recent'):
        return 'pp_mmorda'

    if browser == 'YandexSearch' and from_where == 'multimorda':
        return 'pp_recent'

    if browser == 'YandexSearch' and referer_path.startswith('/searchapp'):
        return 'pp_other'

# Toloka
    if 'iframe-toloka.' in referer_domain:
        return 'toloka'

    if utm_source in ('toloka', 'toloka-collections-feed') and not \
       (url_path.startswith('/images/') or url_path.startswith('/images/touch/')) and \
       utm_medium != 'serp':
        return 'toloka'

    if url.startswith('https://collections-test') or 'l7test.yandex.' in url or 'tunneler-si.yandex.' in url or 'tun.si.yandex.' in referer_domain:
        # внутренние автотесты
        return 'autotests'

# Referer
    if referer == '':
        # Прямой заход в Коллекции, без реферера
        return 'direct'

# Yandex Referer
    if YANDEX_DOMAIN_PATTERN.match(referer_domain):
        # ИЗ КАРТИНОК
        if referer_path in ['/images/', '/images/touch/']:
            return 'images_morda'

        if referer_path == '/clck/jsredir':
            if 'images/search' in referer_query_params.get('from', '') or \
               'images/touch/search' in referer_query_params.get('from', ''):
                # переход из картинок
                return 'images_search'
            else:
                # переход из органики
                return 'yandex'

        if 'images/search' in referer_path or 'images/touch/search' in referer_path:
            return 'images_other'

        # ИЗ КОЛЛЕКЦИЙ
        if '/collections' in referer_path or 'passport.yandex.' in referer_domain:
            # внутренний переход; действия незалогинов проходят через паспорт
            last_page_name = get_collections_page(referer)
            if last_page_name:
                return 'internal_{}'.format(last_page_name)
            else:
                return 'internal'

        # ИЗ ПОИСКА
        if referer_path == '/all':
            # переход со страницы со всеми сервисами (yandex.ru/all)
            return 'yandex_all'

        if url_query_params.get('boardId'):
            # Спецсниппет на серпе [менеджерский юмор]
            return 'serp_collections_snippet'

        if from_where == 'tabbar':
            return 'yandex_tabbar'

        if referer_path == '/' or referer_path == '/showcapcha':
            # Органика Яндекса плюс внутренние переходы, неразмеченные utm-метками
            return 'yandex'

        # Some unclassified Yandex
        return 'yandex_other'

    if 'android-app' in referer and 'org.telegram' in referer:
        return 'telegram'

# GOOGLE, MAIL.RU, socials etc.
    if 'google.' in referer_domain:
        # Google
        return 'google'

    if 'pinterest.' in referer_domain or \
       'facebook.' in referer_domain or \
       'twitter.com' in referer_domain or \
       'click.my.mail.ru' in referer_domain or \
       't.co' in referer_domain or \
       'twitter.com' in referer_domain or \
       'twitter.com' in referer_domain or \
       'instagram.com' in referer_domain or \
       'vk.com' in referer_domain or \
       'ok.ru' in referer_domain:
        # Social Networks
        return 'social'

    if 'duckduckgo.' in referer_domain or \
       'mail.ru' in referer_domain or \
       'rambler.ru' in referer_domain or \
       'yahoo.com' in referer_domain or \
       'tut.by' in referer_domain or \
       'bing.com' in referer_domain:
        # Local Search Players
        return 'mailru_rambler'

    if referer_parsed.scheme and referer_parsed.scheme in ['http', 'https'] and referer_domain:
        # Some Sites in Web
        return 'some_site'

    return 'unknown'
