# coding: utf-8

from analytics.plotter_lib.plotter import Plot, require
from analytics.plotter_lib.utils import AddTotalsMapper

from nile.api.v1 import (
    with_hints,
    aggregators as na,
    extractors as ne
)
from qb2.api.v1 import (
    filters as qf,
    extractors as qe
)


def is_collab(auto_approve, board_permissions):
    if auto_approve is None:
        auto_approve = False
    if board_permissions is None:
        board_permissions = []
    return 'true' if auto_approve or board_permissions else 'false'


class Views(Plot):
    @require(
        'Boards.parsed',
        'CollectionsRedirLog.parsed'
    )
    def board_views(self, streams):
        boards = streams['Boards.parsed'] \
            .project(
                'board_id',
                is_collab=ne.custom(is_collab, 'board_auto_approve_invite_requests', 'board_permissions').with_type(str)
            )

        board_views = streams['CollectionsRedirLog.parsed'] \
            .filter(qf.yql_custom('$p0 IS NOT NULL AND $p1="access"', 'board_id', 'path')) \
            .project('board_id', 'fielddate', is_owner=qe.yql_custom('is_owner', 'COALESCE($p0, "false")', 'is_owner')) \
            .cast(is_owner=str)

        KEYS = ('is_collab', 'is_owner', 'fielddate')

        board_views_joined = board_views \
            .join(boards, by='board_id') \
            .map(with_hints(output_schema={key: str for key in KEYS})(AddTotalsMapper(KEYS))) \
            .groupby(*KEYS) \
            .aggregate(views=na.count())

        return self.publish(board_views_joined, self.get_statface_report('Collections/Metrics/sessions/board_views'))
