from analytics.collections.plotter_collections.plots.card_origin_metrics import get_card_origin_ui


def test_card_origin():
    assert get_card_origin_ui('yabrowser', 'desktop') == 'desktop'
    assert get_card_origin_ui('ru.yandex.searchplugin', None) == 'yandexApp'
    assert get_card_origin_ui('collections', 'desktop') == 'desktop'
    assert get_card_origin_ui('collections', 'desktop.android') == 'desktop'
    assert get_card_origin_ui('lego', 'desktop') == 'desktop'
    assert get_card_origin_ui('lego', 'touch') == 'mobile'
    assert get_card_origin_ui('yandexsearch', 'touch.android') == 'yandexApp'
    assert get_card_origin_ui('collections', 'touch.android') == 'mobile'
    assert get_card_origin_ui('yabrowser', 'touch.android') == 'mobile'
    assert get_card_origin_ui('lego_img_viewer', 'desktop') == 'desktop'
    assert get_card_origin_ui('lego_img_viewer', 'touch') == 'mobile'
    assert get_card_origin_ui('collections', 'desktop') == 'desktop'
    assert get_card_origin_ui('yandexsearch', 'touch.ios') == 'yandexApp'
    assert get_card_origin_ui('collections', 'desktop') == 'desktop'
    assert get_card_origin_ui('lego_imgwiz_viewer', 'desktop') == 'desktop'
    assert get_card_origin_ui('yabrowser', 'touch.ios') == 'mobile'
    assert get_card_origin_ui('lego_imgwiz', 'desktop') == 'desktop'
    assert get_card_origin_ui('serp-components', 'common') == 'common'
    assert get_card_origin_ui('collections', 'touch.ios') == 'mobile'
    assert get_card_origin_ui('collections', 'touch.android') == 'mobile'
    assert get_card_origin_ui('yandexsearch', 'touch.android') == 'yandexApp'
    assert get_card_origin_ui('lego', 'touch.android') == 'mobile'
    assert get_card_origin_ui('lego_img_serp_thumb', 'desktop') == 'desktop'
    assert get_card_origin_ui('yandexsearch', 'touch.ios') == 'yandexApp'
    assert get_card_origin_ui('lego', None) == 'desktop'
    assert get_card_origin_ui('yandexsearch', 'pad.android') == 'yandexApp'
    assert get_card_origin_ui('collections', 'touch.ios') == 'mobile'
    assert get_card_origin_ui('lego_img_viewer', 'common') == 'common'
    assert get_card_origin_ui('collections', 'pad.android') == 'tablet'
    assert get_card_origin_ui('plugin', 'desktop') == 'desktop'
    assert get_card_origin_ui('lego_kokos_viewer', 'desktop') == 'desktop'
    assert get_card_origin_ui(None, None) == 'empty'
    assert get_card_origin_ui('lego', 'desktop') == 'desktop'
    assert get_card_origin_ui('yandexsearch', 'touch.ios') == 'yandexApp'
    assert get_card_origin_ui('collections', 'touch.android') == 'mobile'
    assert get_card_origin_ui('lego', 'touch.ios') == 'mobile'
    assert get_card_origin_ui('turbo', 'touch') == 'mobile'
    assert get_card_origin_ui('yandexsearch', 'touch.android') == 'yandexApp'
    assert get_card_origin_ui('collections', 'pad.ios') == 'tablet'
    assert get_card_origin_ui('collections', 'touch.ios') == 'mobile'
    assert get_card_origin_ui('ru.yandex.searchplugin.beta', None) == 'yandexApp'
    assert get_card_origin_ui('ru.yandex.mobile', None) == 'yandexApp'
    assert get_card_origin_ui('lego_img_viewer', 'pad.android') == 'tablet'
    assert get_card_origin_ui('yabrowser', None) == 'desktop'
    assert get_card_origin_ui('collections', 'pad.ios') == 'tablet'
    assert get_card_origin_ui('collections', 'pad.ios') == 'tablet'
    assert get_card_origin_ui('lego', 'pad.ios') == 'tablet'
    assert get_card_origin_ui('collections', 'pad.android') == 'tablet'
    assert get_card_origin_ui('collections', 'pad.android') == 'tablet'
    assert get_card_origin_ui('collections', 'touch') == 'mobile'
    assert get_card_origin_ui('lego', 'touch.android') == 'mobile'
    assert get_card_origin_ui('lego_kokos', 'desktop') == 'desktop'
    assert get_card_origin_ui('yandexsearch', 'pad.android') == 'yandexApp'
    assert get_card_origin_ui('collections', 'touch') == 'mobile'
    assert get_card_origin_ui('lego_kokos_viewer', 'touch.android') == 'mobile'
    assert get_card_origin_ui('yabrowser', 'touch.android') == 'mobile'
