#!/usr/bin/env python
# coding: utf-8

"""
Скрипт для пересчёта в прошлое выжимок показов
Запускает через multiprocessing каждые полчаса новый плоттер layer sessions в заданных вычислительных пулах
"""

import multiprocessing
import subprocess
import time
import itertools

from datetime import datetime, timedelta
import yt.wrapper as yt


IS_DEBUG = True
FORCE_REWRITE_TABLES = False
TOKEN_PATH = '/home/nerevar/.yql/token'
SLEEP_INTERVAL = 60 * 30  # 30 минут
YT_POOLS = ('images_analytics', 'images-cloud')

yt.config.config['proxy']['url'] = 'arnold'
yt.config.config['token_path'] = TOKEN_PATH

TOKEN = open(TOKEN_PATH, 'r').read().replace('\n', '')
DATE_FORMAT = '%Y-%m-%d'


def date_range(start_date, end_date=None, delta=0):
    """
    Итератор по датам в интервале [start_date, end_date], включительно
    если end_date отсутствует - то возвращает первый день
    возможно вычесть `delta` дней, но минимум всегда будет start_date
    """
    if not end_date:
        yield start_date
        return

    days_range = int((end_date - start_date).days) + 1 - delta

    if days_range <= 1:
        yield start_date
        return

    for n in range(days_range):
        yield start_date + timedelta(n)


def run_plotter(date_start, pool, token, debug=False):
    if debug:
        print '{}: {}'.format(
            pool, date_start
        )
        return

    cmd = '../plotter_run.sh --cluster arnold --pool {pool} --date {date_start} --token {token} --stat-token {token} --layer sessions'.format(
        pool=pool,
        date_start=date_start,
        token=token
    )

    p = subprocess.Popen(cmd, stdout=subprocess.PIPE, stdin=subprocess.PIPE, stderr=subprocess.STDOUT, shell=True)
    stdout, stderr = p.communicate()
    print 'DONE time: "{}", {} {}'.format(
        time.ctime(),
        date_start,
        pool,
    )


jobs = []
yt_pool_index = 0

YT_FOLDER = '//home/collections/analytics/backups/COLA-10_collections_content_shows_squeeze'

# набор дат, которые пересчитать
dates = itertools.chain(
    iter([datetime(2020, 3, 21)]),
    date_range(datetime(2019, 1, 1), datetime(2019, 4, 1)),
)

for i, date in enumerate(dates):
    date_start = date.strftime(DATE_FORMAT)
    print '\n\n=== iterator', i, date_start

    if FORCE_REWRITE_TABLES or not yt.exists('{}/{}'.format(YT_FOLDER, date_start)):
        print '    start {} {}'.format(date_start, YT_POOLS[yt_pool_index])
        p = multiprocessing.Process(target=run_plotter, args=(date_start, YT_POOLS[yt_pool_index], TOKEN, IS_DEBUG, ))
        yt_pool_index += 1
        if yt_pool_index + 1 == len(YT_POOLS):
            yt_pool_index = 0
        p.start()
        jobs.append(p)

        if not IS_DEBUG:
            time.sleep(SLEEP_INTERVAL)

print 'wait for {} jobs'.format(len(jobs))
for job in jobs:
    job.join()

print 'all finished'
