import glob
import os
import sys

import yatest.common
import yql.library.fastcheck.python as fastcheck


def read_script(fname):
    with open(yatest.common.source_path(os.path.join('analytics/ecosystem/YaPay', fname))) as script:
        return script.read()


def test():
    for fname in glob.glob(yatest.common.source_path('analytics/ecosystem/YaPay') + "/*.yql"):
        script = read_script(fname)
        errors = []
        res = fastcheck.check_program(script, cluster_mapping={'hahn': 'yt'}, errors=errors, syntax_version=1)
        if errors:
            print >> sys.stderr, fname, 'is not valid'
        for error in errors:
            print >> sys.stderr, error.message
        assert res
